/*
 * Decompiled with CFR 0.152.
 */
package kenya.ui.indentation;

import java.util.regex.Matcher;
import kenya.ui.indentation.ILineIndentation;

public class LineIndentation
implements ILineIndentation {
    private ILineIndentation next = null;
    private ILineIndentation previous = null;
    private boolean complete = false;
    private boolean reduce = false;
    private int depth = 0;
    private String indentation = "";
    private boolean blockStart = false;
    private boolean blockEnd = false;
    private int lineNumber = 0;

    public synchronized void setNextLine(ILineIndentation nextLine) {
        if (this.next != null) {
            this.next.setPreviousLine(null);
        }
        this.next = nextLine;
        this.recount();
    }

    public synchronized void setPreviousLine(ILineIndentation previousLine) {
        if (this.previous != null) {
            this.previous.setNextLine(null);
        }
        this.previous = previousLine;
        this.recount();
    }

    public synchronized ILineIndentation getNextLine() {
        return this.next;
    }

    public synchronized ILineIndentation getPreviousLine() {
        return this.previous;
    }

    public synchronized boolean isComplete() {
        return this.complete;
    }

    public synchronized String getNextLineIndentation() {
        return this.indentation;
    }

    public synchronized void parseLineText(String thisLineText, String nextLineText) {
        this.complete = false;
        this.reduce = false;
        this.indentation = "";
        this.depth = 0;
        this.blockStart = BLOCKSTART.matcher(thisLineText).matches();
        this.blockEnd = BLOCKEND.matcher(thisLineText).matches();
        if (this.isInBlock()) {
            this.complete = true;
            if (this.previous != null) {
                this.depth = this.previous.getDepth();
            }
        }
        if (this.isInBlock() && this.blockStart || !this.isInBlock()) {
            this.complete = SEMICOLONEND.matcher(thisLineText).matches() || DECREASINGEND.matcher(thisLineText).matches() || SPACELINE.matcher(thisLineText).matches() && (this.previous == null || this.previous.isComplete());
            int braceSkew = this.findBraceSkew(thisLineText);
            if (nextLineText != null && INCREASINGSTART.matcher(nextLineText).matches() && !this.complete && this.findBraceSkew(nextLineText) > 0) {
                this.reduce = true;
            }
            this.depth = this.previous == null ? braceSkew : this.previous.getDepth() + braceSkew;
            if (nextLineText != null && DECREASINGSTART.matcher(nextLineText).matches()) {
                this.reduce = true;
            }
        }
        this.depth = Math.max(0, this.depth);
        this.indentation = "";
        int count = 0;
        if (this.reduce) {
            ++count;
        }
        if (!this.complete) {
            --count;
        }
        while (count < this.depth) {
            this.indentation = this.indentation + "    ";
            ++count;
        }
    }

    private int findBraceSkew(String text) {
        int result = 0;
        Matcher inc = INCREASEREMOVE.matcher(text);
        while (inc.matches()) {
            ++result;
            text = inc.group(1) + inc.group(2);
            inc = INCREASEREMOVE.matcher(text);
        }
        Matcher dec = DECREASEREMOVE.matcher(text);
        while (dec.matches()) {
            --result;
            text = dec.group(1) + dec.group(2);
            dec = DECREASEREMOVE.matcher(text);
        }
        return result;
    }

    public synchronized int getLineNumber() {
        return this.lineNumber;
    }

    public synchronized int getDepth() {
        return this.depth;
    }

    public synchronized ILineIndentation getLine(int lineNumber) {
        int myLineNumber = this.getLineNumber();
        if (myLineNumber < lineNumber) {
            if (this.next == null) {
                return null;
            }
            return this.next.getLine(lineNumber);
        }
        if (myLineNumber > lineNumber) {
            if (this.previous == null) {
                return null;
            }
            return this.previous.getLine(lineNumber);
        }
        return this;
    }

    public synchronized boolean isBlockStart() {
        return this.blockStart;
    }

    public synchronized boolean isBlockEnd() {
        return this.blockEnd;
    }

    public synchronized boolean isInBlock() {
        if (this.previous == null) {
            return this.blockStart || this.blockEnd;
        }
        if (this.blockStart) {
            return true;
        }
        if (this.blockEnd) {
            return true;
        }
        if (this.previous.isBlockEnd()) {
            return false;
        }
        return this.previous.isInBlock();
    }

    public synchronized void recount() {
        if (this.previous != null) {
            this.previous.recount();
        } else {
            this.setLineNumber(0);
        }
    }

    public synchronized void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
        if (this.next != null) {
            this.next.setLineNumber(lineNumber + 1);
        }
    }
}

