/*
 * Decompiled with CFR 0.152.
 */
package mediator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.stackMachine.IStackMachineInformationProvider;
import mediator.util.InformationHolder;

class PartiallyCheckedCode
implements ICheckedCode {
    private final List _errors;
    private final List _infos;
    private final InformationHolder _ih;

    PartiallyCheckedCode(List errors, InformationHolder ih) {
        if (errors == null) {
            throw new NullPointerException("errors list cannot be null!");
        }
        if (ih == null) {
            throw new NullPointerException("Information Holder can't be null");
        }
        this._errors = Collections.unmodifiableList(errors);
        this._infos = Collections.unmodifiableList(new LinkedList());
        this._ih = ih;
    }

    PartiallyCheckedCode(List errors, List infos, InformationHolder ih) {
        if (errors == null) {
            throw new NullPointerException("errors can't be null");
        }
        if (infos == null) {
            throw new NullPointerException("infos can't be null");
        }
        if (ih == null) {
            throw new NullPointerException("Information Holder can't be null");
        }
        this._errors = Collections.unmodifiableList(errors);
        this._infos = Collections.unmodifiableList(infos);
        this._ih = ih;
    }

    public boolean isErroredCode() {
        return true;
    }

    public List getErrors() {
        return this._errors;
    }

    public List getInfos() {
        return this._infos;
    }

    public IJavaCode translate() {
        throw new IllegalStateException("Cannot translate a partially checked Kenya Program.");
    }

    public IStackMachineInformationProvider getBaseStackMachine() {
        throw new IllegalStateException("Build a stack machine to interpret a partially checked Kenya Program.");
    }

    public IClass[] getClasses() {
        return this._ih.getClasses();
    }

    public IVariable[] getConstants() {
        return this._ih.getConstants();
    }

    public IClass[] getEnums() {
        return this._ih.getEnums();
    }

    public IFunction[] getFunctions() {
        return this._ih.getFunctions();
    }
}

