/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine;

import java.util.Map;
import java.util.TreeMap;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class InterpretedMethod
implements IInterpretedMethod {
    private String name = null;
    private IInterpretedClass myClass = null;
    private IAtomicClosure methodBody = null;
    private boolean returnType = false;
    private boolean isStatic = false;
    private final Map mutableVariables = new TreeMap();
    private final Map immutableVariables = new TreeMap();
    private final Object lock = new Object();

    public InterpretedMethod(String name, IInterpretedClass myClass, boolean isStatic, boolean hasReturnType) {
        this.name = name;
        this.myClass = myClass;
        this.isStatic = isStatic;
        this.returnType = hasReturnType;
    }

    public synchronized void setName(String name) {
        if (this.name != null) {
            throw new RuntimeException("Attempt made to redefine InterpretedClass's name: " + this.name);
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setReturnType(boolean hasReturnType) {
        this.returnType = hasReturnType;
    }

    public synchronized boolean hasReturnType() {
        return this.returnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMethodBody(IAtomicClosure body) {
        Object object = this.lock;
        synchronized (object) {
            this.methodBody = body;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAtomicClosure getMethodBody() {
        Object object = this.lock;
        synchronized (object) {
            return this.methodBody;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(StackMachine sm) {
        TreeMap mutableMethodVariablesCopy = null;
        InterpretedMethod interpretedMethod = this;
        synchronized (interpretedMethod) {
            IAtomicClosure methodBody = this.getMethodBody();
            if (methodBody == null) {
                throw new RuntimeException("Attempt made to invoke on a null method body in method " + this);
            }
            mutableMethodVariablesCopy = new TreeMap(this.mutableVariables);
        }
        ClosureMiscHelper.executeClosureInScope(sm.getClosureScope(), this.methodBody, sm);
        interpretedMethod = this;
        synchronized (interpretedMethod) {
            this.mutableVariables.clear();
            this.mutableVariables.putAll(mutableMethodVariablesCopy);
            mutableMethodVariablesCopy.clear();
        }
    }

    public synchronized void addMutableMethodVariable(String name, IType variable) {
        this.mutableVariables.put(name, variable);
    }

    public synchronized void addImmutableMethodVariable(String name, IType variable) {
        this.immutableVariables.put(name, variable);
    }

    public synchronized boolean isStatic() {
        return this.isStatic;
    }

    public synchronized void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public IInterpretedClass getInterpretedClass() {
        return this.myClass;
    }

    public synchronized String toString() {
        return "InterpretedMethod '" + this.name + "' in class " + this.myClass + " (static = " + this.isStatic + ")";
    }

    public synchronized Map getMutableMethodVariables() {
        return this.mutableVariables;
    }

    public synchronized Map getImmutableMethodVariables() {
        return this.immutableVariables;
    }
}

