/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kenya.builtIns.BuiltInMethodsLoader;
import kenya.builtIns.IBuiltInMethod;
import kenya.builtIns.SMLibraryContainer;
import org.wellquite.kenya.stackMachine.InterpretedBuildableClosure;
import org.wellquite.kenya.stackMachine.InterpretedClass;
import org.wellquite.kenya.stackMachine.InterpretedEnumeration;
import org.wellquite.kenya.stackMachine.InterpretedMethod;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.ops.ArrayOpsFactory;
import org.wellquite.kenya.stackMachine.ops.ControlFlowOpsFactory;
import org.wellquite.kenya.stackMachine.ops.LogicalOpsFactory;
import org.wellquite.kenya.stackMachine.ops.NumericOpsFactory;
import org.wellquite.kenya.stackMachine.ops.StackOpsFactory;
import org.wellquite.kenya.stackMachine.types.ArrayTypeFactory;
import org.wellquite.kenya.stackMachine.types.ClassTypeFactory;
import org.wellquite.kenya.stackMachine.types.EnumTypeFactory;
import org.wellquite.kenya.stackMachine.types.IntType;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;

public class StackMachineTest {
    private static Set builtInMethods = BuiltInMethodsLoader.getBuiltInMethods();
    private static Map methods = new TreeMap();

    public static void main(String[] args) {
        for (IBuiltInMethod method : builtInMethods) {
            methods.put(method.getName(), method);
        }
        StackMachineTest.equalityTest();
        StackMachineTest.mathTest();
        StackMachineTest.test1();
        StackMachineTest.test2();
        long totalTime = 0L;
        for (int idx = 0; idx < 3; ++idx) {
            Date start = new Date();
            StackMachineTest.primeTest();
            Date end = new Date();
            totalTime += end.getTime() - start.getTime();
        }
        System.out.println(totalTime / 3L);
    }

    private static void primeTest() {
        InterpretedClass primeClass = new InterpretedClass("prime");
        InterpretedMethod isPrime = new InterpretedMethod("isPrime", primeClass, true, true);
        InterpretedBuildableClosure methodBody = new InterpretedBuildableClosure();
        methodBody.addClosure(StackOpsFactory.storeNewVariable("testNumber", false));
        methodBody.addClosure(StackOpsFactory.fetch("testNumber"));
        methodBody.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("sqrt")).getInterpretedMethod()));
        methodBody.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("ceil")).getInterpretedMethod()));
        methodBody.addClosure(StackOpsFactory.storeNewVariable("target", false));
        methodBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(2)));
        methodBody.addClosure(StackOpsFactory.storeNewVariable("counter", true));
        methodBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(true)));
        methodBody.addClosure(StackOpsFactory.storeNewVariable("prime", true));
        InterpretedBuildableClosure whileCond = new InterpretedBuildableClosure();
        InterpretedBuildableClosure leftAnd = new InterpretedBuildableClosure();
        leftAnd.addClosure(StackOpsFactory.fetch("counter"));
        leftAnd.addClosure(StackOpsFactory.fetch("target"));
        leftAnd.addClosure(LogicalOpsFactory.greaterThanEqual());
        InterpretedBuildableClosure rightAnd = new InterpretedBuildableClosure();
        rightAnd.addClosure(StackOpsFactory.fetch("prime"));
        whileCond.addClosure(LogicalOpsFactory.and(leftAnd, rightAnd));
        InterpretedBuildableClosure whileBody = new InterpretedBuildableClosure();
        InterpretedBuildableClosure ifCond = new InterpretedBuildableClosure();
        ifCond.addClosure(StackOpsFactory.fetch("counter"));
        ifCond.addClosure(StackOpsFactory.fetch("testNumber"));
        ifCond.addClosure(NumericOpsFactory.modulus());
        ifCond.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0)));
        ifCond.addClosure(LogicalOpsFactory.equal());
        InterpretedBuildableClosure ifTrue = new InterpretedBuildableClosure();
        ifTrue.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
        ifTrue.addClosure(methodBody.returnFromThisClosure());
        InterpretedBuildableClosure ifFalse = new InterpretedBuildableClosure();
        ifFalse.addClosure(StackOpsFactory.fetch("counter"));
        ifFalse.addClosure(NumericOpsFactory.inc());
        ifFalse.addClosure(StackOpsFactory.store("counter"));
        whileBody.addClosure(ControlFlowOpsFactory.ifClosure(ifCond, ifTrue, ifFalse));
        methodBody.addClosure(ControlFlowOpsFactory.whileClosure(whileCond, whileBody));
        methodBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(true)));
        methodBody.addClosure(methodBody.returnFromThisClosure());
        isPrime.setMethodBody(methodBody);
        InterpretedMethod main = new InterpretedMethod("main", primeClass, true, false);
        methodBody = new InterpretedBuildableClosure();
        methodBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0)));
        methodBody.addClosure(StackOpsFactory.storeNewVariable("current", true));
        methodBody.addClosure(StackOpsFactory.push(ClassTypeFactory.createClassStaticType(primeClass)));
        methodBody.addClosure(StackOpsFactory.storeNewVariable("primeClass", false));
        whileCond = new InterpretedBuildableClosure();
        whileCond.addClosure(StackOpsFactory.fetch("current"));
        whileCond.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(20000)));
        whileCond.addClosure(LogicalOpsFactory.notEqual());
        whileBody = new InterpretedBuildableClosure();
        whileBody.addClosure(StackOpsFactory.fetch("current"));
        ifCond = new InterpretedBuildableClosure();
        ifCond.addClosure(StackOpsFactory.fetch("primeClass"));
        ifCond.addClosure(StackOpsFactory.invokeForeignStaticMethod("isPrime"));
        ifTrue = new InterpretedBuildableClosure();
        ifTrue.addClosure(StackOpsFactory.fetch("current"));
        ifTrue.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        whileBody.addClosure(ControlFlowOpsFactory.ifClosure(ifCond, ifTrue, null));
        whileBody.addClosure(NumericOpsFactory.inc());
        whileBody.addClosure(StackOpsFactory.store("current"));
        methodBody.addClosure(ControlFlowOpsFactory.whileClosure(whileCond, whileBody));
        main.setMethodBody(methodBody);
        primeClass.addStaticMethod(main);
        primeClass.addStaticMethod(isPrime);
        new StackMachine().invokeMethod(primeClass, "main");
    }

    private static void test1() {
        InterpretedClass pairClass = new InterpretedClass("pair");
        pairClass.addMutableInstanceVariable("x", PrimitiveTypeFactory.createPrimitiveType(5));
        pairClass.addMutableInstanceVariable("y", PrimitiveTypeFactory.createPrimitiveType(6));
        pairClass.addMutableStaticVariable("z", PrimitiveTypeFactory.createPrimitiveType(0));
        InterpretedClass myClass = new InterpretedClass("myClass");
        InterpretedMethod add = new InterpretedMethod("add", myClass, false, false);
        InterpretedBuildableClosure irmb = new InterpretedBuildableClosure();
        irmb.addClosure(StackOpsFactory.storeNewVariable("pair", false));
        irmb.addClosure(StackOpsFactory.fetch("pair"));
        irmb.addClosure(StackOpsFactory.fetchFromClassInstance("x"));
        irmb.addClosure(StackOpsFactory.fetch("pair"));
        irmb.addClosure(StackOpsFactory.fetchFromClassInstance("y"));
        irmb.addClosure(LogicalOpsFactory.greaterThan());
        irmb.addClosure(StackOpsFactory.storeNewVariable("result", false));
        irmb.addClosure(StackOpsFactory.fetch("pair"));
        irmb.addClosure(StackOpsFactory.fetch("result"));
        irmb.addClosure(StackOpsFactory.storeInClassInstance("z"));
        irmb.addClosure(StackOpsFactory.printlnStackPeek());
        add.setMethodBody(irmb);
        myClass.addInstanceMethod(add);
        InterpretedMethod main = new InterpretedMethod("main", myClass, true, false);
        irmb = new InterpretedBuildableClosure();
        irmb.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("Main running.")));
        irmb.addClosure(StackOpsFactory.printlnStackPeek());
        irmb.addClosure(StackOpsFactory.push(ClassTypeFactory.createClassInstanceType(pairClass.createInstance())));
        irmb.addClosure(StackOpsFactory.push(ClassTypeFactory.createClassInstanceType(myClass.createInstance())));
        irmb.addClosure(StackOpsFactory.invokeForeignInstanceMethod("add"));
        irmb.addClosure(StackOpsFactory.printlnStackPeek());
        irmb.addClosure(StackOpsFactory.fetchFromClassInstance("z"));
        irmb.addClosure(StackOpsFactory.printlnStackPeek());
        irmb.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("Main finishing.")));
        irmb.addClosure(StackOpsFactory.printlnStackPeek());
        main.setMethodBody(irmb);
        myClass.addStaticMethod(main);
        new StackMachine().invokeMethod(myClass, "main");
    }

    private static void test2() {
        InterpretedClass myClass = new InterpretedClass("myClass");
        InterpretedMethod main = new InterpretedMethod("main", myClass, true, false);
        InterpretedBuildableClosure mainBody = new InterpretedBuildableClosure();
        mainBody.addClosure(StackOpsFactory.push(ArrayTypeFactory.createArrayType(new IClassInstanceType[]{ClassTypeFactory.createClassInstanceType(myClass.createInstance()), ClassTypeFactory.createClassInstanceType(myClass.createInstance()), ClassTypeFactory.createClassInstanceType(myClass.createInstance())}, myClass.getName())));
        mainBody.addClosure(StackOpsFactory.storeNewVariable("ary", false));
        mainBody.addClosure(StackOpsFactory.fetch("ary"));
        mainBody.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(StackOpsFactory.push(ClassTypeFactory.createClassInstanceType(myClass.createInstance())));
        mainBody.addClosure(StackOpsFactory.fetch("ary"));
        mainBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0)));
        mainBody.addClosure(ArrayOpsFactory.set());
        mainBody.addClosure(StackOpsFactory.fetch("ary"));
        mainBody.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(3)));
        mainBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(2)));
        mainBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(4)));
        mainBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(3)));
        mainBody.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('M')));
        mainBody.addClosure(ArrayOpsFactory.buildMultidimensionalArray());
        mainBody.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        main.setMethodBody(mainBody);
        myClass.addStaticMethod(main);
        new StackMachine().invokeMethod(myClass, "main");
    }

    private static void equalityTest() {
        InterpretedClass classA = new InterpretedClass("classA");
        InterpretedClass mainClass = new InterpretedClass("mainClass");
        InterpretedMethod main = new InterpretedMethod("main", mainClass, true, false);
        InterpretedBuildableClosure mainBody = new InterpretedBuildableClosure();
        InterpretedBuildableClosure condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(65)));
        condition.addClosure(LogicalOpsFactory.equal());
        InterpretedBuildableClosure trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("A == 65")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(65)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("65 == A")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("5 == 5")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5.0)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5.0)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("5.0 == 5.0")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("false == false")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(65.0)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("65.0 == A")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(65.0)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("A == 65.0")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("A")));
        condition.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("A")));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("\"A\" == \"A\"")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        IClassInstanceType wibble = ClassTypeFactory.createClassInstanceType(classA.createInstance());
        condition.addClosure(StackOpsFactory.push(wibble));
        condition.addClosure(StackOpsFactory.push(wibble));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("" + wibble + " == " + wibble)));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        IntType one = PrimitiveTypeFactory.createPrimitiveType(1);
        IntType two = PrimitiveTypeFactory.createPrimitiveType(2);
        IntType three = PrimitiveTypeFactory.createPrimitiveType(3);
        IArrayType ary1 = ArrayTypeFactory.createArrayType(new IntType[]{one, two, three}, one.getTypeName());
        condition.addClosure(StackOpsFactory.push(ary1));
        condition.addClosure(StackOpsFactory.push(ary1));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("" + ary1 + " == " + ary1)));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        IArrayType ary2 = ArrayTypeFactory.createArrayType(new IntType[]{one, two, three}, one.getTypeName());
        condition.addClosure(StackOpsFactory.push(ary1));
        condition.addClosure(StackOpsFactory.push(ary2));
        condition.addClosure(LogicalOpsFactory.notEqual());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("" + ary1 + " != " + ary2)));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        InterpretedEnumeration enumValue = new InterpretedEnumeration("numbers", new Object[]{one, two, three});
        IEnumType enumType1 = EnumTypeFactory.createEnumType(enumValue, two);
        condition.addClosure(StackOpsFactory.push(enumType1));
        condition.addClosure(StackOpsFactory.push(enumType1));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("" + enumType1 + " == " + enumType1)));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        IEnumType enumType2 = EnumTypeFactory.createEnumType(enumValue, two);
        condition.addClosure(StackOpsFactory.push(enumType1));
        condition.addClosure(StackOpsFactory.push(enumType2));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("" + enumType1 + " == " + enumType2)));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        main.setMethodBody(mainBody);
        mainClass.addStaticMethod(main);
        new StackMachine().invokeMethod(mainClass, "main");
    }

    private static void mathTest() {
        InterpretedClass mainClass = new InterpretedClass("mainClass");
        InterpretedMethod main = new InterpretedMethod("main", mainClass, true, false);
        InterpretedBuildableClosure mainBody = new InterpretedBuildableClosure();
        InterpretedBuildableClosure condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(NumericOpsFactory.add());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(10)));
        condition.addClosure(LogicalOpsFactory.equal());
        InterpretedBuildableClosure trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("5 + 5 == 10")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(10)));
        condition.addClosure(NumericOpsFactory.subtract());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("10 - 5 == 5")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(2)));
        condition.addClosure(NumericOpsFactory.multiply());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(10)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("5 * 2 == 10")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(2)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(10)));
        condition.addClosure(NumericOpsFactory.divide());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("10 / 2 == 5")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(2)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(5)));
        condition.addClosure(NumericOpsFactory.modulus());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(1)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("5 % 2 == 1")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(1)));
        condition.addClosure(NumericOpsFactory.add());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(66)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("'A' + 1 == 66")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(1)));
        condition.addClosure(NumericOpsFactory.add());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(66.0)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("'A' + 1 == 66.0")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(1)));
        condition.addClosure(NumericOpsFactory.add());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('B')));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("'A' + 1 == 'B'")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(1)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(NumericOpsFactory.add());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(66)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("1 + 'A' == 66")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(1)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(NumericOpsFactory.add());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(66.0)));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("1 + 'A' == 66.0")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        condition = new InterpretedBuildableClosure();
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(1)));
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('A')));
        condition.addClosure(NumericOpsFactory.add());
        condition.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('B')));
        condition.addClosure(LogicalOpsFactory.equal());
        trueBlock = new InterpretedBuildableClosure();
        trueBlock.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType("1 + 'A' == 'B'")));
        trueBlock.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(((IBuiltInMethod)methods.get("println")).getInterpretedMethod()));
        mainBody.addClosure(ControlFlowOpsFactory.ifClosure(condition, trueBlock, null));
        main.setMethodBody(mainBody);
        mainClass.addStaticMethod(main);
        new StackMachine().invokeMethod(mainClass, "main");
    }
}

