/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ActionPresentation;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.ExtensionEventHandlerMessages;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.ObjectActionContributorReader;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.ShowViewMenu;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.decorators.DecoratorRegistryReader;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetPartAssociationsReader;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.EditorRegistryReader;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.PropertyPagesRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistryReader;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.themes.ITheme;

class ExtensionEventHandler
implements IRegistryChangeListener {
    private static final String TAG_CATEGORY = "category";
    private static final String ATT_TARGET_ID = "targetID";
    private static final String TAG_PART = "part";
    private static final String ATT_ID = "id";
    private static final String TAG_PROVIDER = "imageprovider";
    private static final String TAG_ACTION_SET_PART_ASSOCIATION = "actionSetPartAssociation";
    private Workbench workbench;
    private List changeList = new ArrayList(10);

    public ExtensionEventHandler(Workbench workbench) {
        this.workbench = workbench;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registryChanged(IRegistryChangeEvent event) {
        block17: {
            block16: {
                try {
                    IExtensionDelta[] delta = event.getExtensionDeltas(WorkbenchPlugin.PI_WORKBENCH);
                    IWorkbenchWindow[] win = PlatformUI.getWorkbench().getWorkbenchWindows();
                    if (win.length == 0) {
                        Object var14_4 = null;
                        this.changeList.clear();
                        return;
                    }
                    Display display = win[0].getShell().getDisplay();
                    if (display == null) {
                        break block16;
                    }
                    ArrayList<IExtensionDelta> appearList = new ArrayList<IExtensionDelta>(5);
                    ArrayList<IExtensionDelta> revokeList = new ArrayList<IExtensionDelta>(5);
                    String id = null;
                    int numPerspectives = 0;
                    int numActionSetPartAssoc = 0;
                    int i = 0;
                    while (true) {
                        block19: {
                            block18: {
                                if (i >= delta.length) break;
                                id = delta[i].getExtensionPoint().getSimpleIdentifier();
                                if (delta[i].getKind() != 1) break block18;
                                if (id.equals("actionSets")) {
                                    appearList.add(0, delta[i]);
                                    break block19;
                                } else if (!(id.equals("perspectives") || id.equals("views") || id.equals("actionSets"))) {
                                    appearList.add(appearList.size() - numPerspectives, delta[i]);
                                }
                                break block19;
                            }
                            if (delta[i].getKind() == 2) {
                                if (id.equals("actionSetPartAssociations")) {
                                    revokeList.add(0, delta[i]);
                                    ++numActionSetPartAssoc;
                                } else if (id.equals("perspectives")) {
                                    revokeList.add(numActionSetPartAssoc, delta[i]);
                                } else {
                                    revokeList.add(delta[i]);
                                }
                            }
                        }
                        ++i;
                    }
                    Iterator iter = appearList.iterator();
                    IExtensionDelta extDelta = null;
                    while (true) {
                        if (!iter.hasNext()) {
                            this.resetCurrentPerspective(display);
                            break block17;
                        }
                        extDelta = (IExtensionDelta)iter.next();
                        IExtensionPoint extPt = extDelta.getExtensionPoint();
                        IExtension ext = extDelta.getExtension();
                        this.asyncAppear(display, extPt, ext);
                    }
                }
                catch (Throwable throwable) {
                    Object var14_6 = null;
                    this.changeList.clear();
                    throw throwable;
                }
            }
            Object var14_5 = null;
            this.changeList.clear();
            return;
        }
        Object var14_7 = null;
        this.changeList.clear();
    }

    private void asyncAppear(Display display, final IExtensionPoint extpt, final IExtension ext) {
        Runnable run = new Runnable(){

            public void run() {
                ExtensionEventHandler.this.appear(extpt, ext);
            }
        };
        display.syncExec(run);
    }

    private void asyncRevoke(Display display, final IExtensionPoint extpt, final IExtension ext) {
        Runnable run = new Runnable(){

            public void run() {
                ExtensionEventHandler.this.revoke(extpt, ext);
            }
        };
        display.syncExec(run);
    }

    private void appear(IExtensionPoint extPt, IExtension ext) {
        String name = extPt.getSimpleIdentifier();
        if (name.equalsIgnoreCase("newWizards")) {
            this.loadNewWizards(ext);
            return;
        }
        if (name.equalsIgnoreCase("editors")) {
            this.loadEditor(ext);
            return;
        }
        if (name.equalsIgnoreCase("perspectiveExtensions")) {
            this.loadPerspectiveExtensions(ext);
            return;
        }
        if (name.equalsIgnoreCase("actionSetPartAssociations")) {
            this.loadActionSetPartAssociation(ext);
            return;
        }
        if (name.equalsIgnoreCase("workingSets")) {
            this.loadWorkingSets(ext);
            return;
        }
        if (name.equalsIgnoreCase("popupMenus")) {
            this.loadPopupMenu(ext);
            return;
        }
        if (name.equalsIgnoreCase("preferencePages")) {
            this.loadPreferencePages(ext);
            return;
        }
        if (name.equalsIgnoreCase("propertyPages")) {
            this.loadPropertyPages(ext);
            return;
        }
        if (name.equalsIgnoreCase("fontDefinitions")) {
            this.loadFontDefinitions(ext);
            return;
        }
        if (name.equalsIgnoreCase("decorators")) {
            this.loadDecorators(ext);
            return;
        }
        if (name.equalsIgnoreCase("themes")) {
            this.loadThemes(ext);
            return;
        }
    }

    private void loadFontDefinitions(IExtension ext) {
        ThemeRegistryReader reader = new ThemeRegistryReader();
        reader.setRegistry((ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry());
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
        Collection fonts = reader.getFontDefinitions();
        FontDefinition[] fontDefs = fonts.toArray(new FontDefinition[fonts.size()]);
        ThemeElementHelper.populateRegistry(this.workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme"), fontDefs, this.workbench.getPreferenceStore());
    }

    private void loadThemes(IExtension ext) {
        ThemeRegistryReader reader = new ThemeRegistryReader();
        ThemeRegistry registry = (ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry();
        reader.setRegistry(registry);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
        Collection colors = reader.getColorDefinitions();
        ColorDefinition[] colorDefs = colors.toArray(new ColorDefinition[colors.size()]);
        ITheme theme = this.workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme");
        ThemeElementHelper.populateRegistry(theme, colorDefs, this.workbench.getPreferenceStore());
        Collection fonts = reader.getFontDefinitions();
        FontDefinition[] fontDefs = fonts.toArray(new FontDefinition[fonts.size()]);
        ThemeElementHelper.populateRegistry(theme, fontDefs, this.workbench.getPreferenceStore());
        Map data = reader.getData();
        registry.addData(data);
    }

    private void loadDecorators(IExtension ext) {
        DecoratorRegistryReader reader = new DecoratorRegistryReader();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
        Collection decorators = reader.getValues();
        DecoratorManager manager = (DecoratorManager)this.workbench.getDecoratorManager();
        Iterator i2 = decorators.iterator();
        while (i2.hasNext()) {
            manager.addDecorator((DecoratorDefinition)i2.next());
        }
    }

    private void loadNewWizards(IExtension ext) {
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            NewWizardsRegistryReader reader = new NewWizardsRegistryReader();
            reader.readElement(elements[i]);
            ++i;
        }
        this.changeList.add(MessageFormat.format(ExtensionEventHandlerMessages.getString("ExtensionEventHandler.change_format"), ext.getNamespace(), ExtensionEventHandlerMessages.getString("ExtensionEventHandler.newWizards")));
    }

    private void loadPropertyPages(IExtension ext) {
        PropertyPageContributorManager manager = PropertyPageContributorManager.getManager();
        PropertyPagesRegistryReader reader = new PropertyPagesRegistryReader(manager);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
    }

    private void loadPreferencePages(IExtension ext) {
        PreferenceManager manager = this.workbench.getPreferenceManager();
        List nodes = manager.getElements(1);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            WorkbenchPreferenceNode node = PreferencePageRegistryReader.createNode(this.workbench, elements[i]);
            if (node != null) {
                String category = node.getCategory();
                if (category == null) {
                    manager.addToRoot((IPreferenceNode)node);
                } else {
                    WorkbenchPreferenceNode parent = null;
                    Iterator j = nodes.iterator();
                    while (j.hasNext()) {
                        WorkbenchPreferenceNode element = (WorkbenchPreferenceNode)j.next();
                        if (!category.equals(element.getId())) continue;
                        parent = element;
                        break;
                    }
                    if (parent == null) {
                        WorkbenchPlugin.log("Invalid preference page path: " + category);
                        manager.addToRoot((IPreferenceNode)node);
                    } else {
                        parent.add((IPreferenceNode)node);
                    }
                }
            }
            ++i;
        }
    }

    private void loadPopupMenu(IExtension ext) {
        ObjectActionContributorManager oMan = ObjectActionContributorManager.getManager();
        ObjectActionContributorReader oReader = new ObjectActionContributorReader();
        oReader.setManager(oMan);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        boolean clearPopups = false;
        int i = 0;
        while (i < elements.length) {
            oReader.readElement(elements[i]);
            if (elements[i].getName().equals("viewerContribution")) {
                clearPopups = true;
            }
            ++i;
        }
        if (clearPopups) {
            PopupMenuExtender.getManager().clearCaches();
        }
    }

    private void revoke(IExtensionPoint extPt, IExtension ext) {
        String name = extPt.getSimpleIdentifier();
        if (name.equalsIgnoreCase("newWizards")) {
            return;
        }
        if (name.equalsIgnoreCase("views")) {
            this.unloadView(ext);
            return;
        }
        if (name.equalsIgnoreCase("editors")) {
            this.unloadEditor(ext);
            return;
        }
        if (name.equalsIgnoreCase("perspectives")) {
            this.unloadPerspective(ext);
            return;
        }
        if (name.equalsIgnoreCase("actionSets")) {
            this.unloadActionSets(ext);
            return;
        }
        if (name.equalsIgnoreCase("actionSetPartAssociations")) {
            this.unloadActionSetPartAssociation(ext);
            return;
        }
        if (name.equalsIgnoreCase("workingSets")) {
            this.unloadWorkingSets(ext);
            return;
        }
    }

    private void restoreViewState(MultiStatus result, String id) {
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IMemento memento = (IMemento)((WorkbenchPage)pages[j]).getStateMap().remove(id);
                if (memento != null) {
                    IMemento[] viewMems = memento.getChildren("view");
                    ViewFactory viewFactory = ((WorkbenchPage)pages[j]).getViewFactory();
                    int k = 0;
                    while (k < viewMems.length) {
                        viewFactory.restoreViewState(viewMems[k]);
                        this.createOpenPerspectiveView(pages[j], viewFactory, viewMems[k]);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void createOpenPerspectiveView(IWorkbenchPage page, ViewFactory viewFactory, IMemento memento) {
        String id = memento.getString(ATT_ID);
        String perspId = memento.getString("perspective");
        Perspective persp = ((WorkbenchPage)page).getActivePerspective();
        if (persp.getDesc().getId().equals(perspId)) {
            try {
                viewFactory.createView(id);
                page.showView(id);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void unloadView(IExtension ext) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("ViewFactory.problemsSavingViews"), null);
        IViewRegistry vReg = WorkbenchPlugin.getDefault().getViewRegistry();
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                ArrayList<String> viewsRemoved = new ArrayList<String>();
                IConfigurationElement[] elements = ext.getConfigurationElements();
                int k = 0;
                while (k < elements.length) {
                    String id;
                    if (elements[k].getName().equals("view") && (id = elements[k].getAttribute(ATT_ID)) != null) {
                        ViewFactory viewFactory = ((WorkbenchPage)pages[j]).getViewFactory();
                        IViewReference viewRef = viewFactory.getView(id);
                        if (viewRef != null) {
                            ((WorkbenchPage)pages[j]).hideView(viewRef);
                            ((WorkbenchPage)pages[j]).getViewFactory().releaseView(viewRef);
                        }
                        viewsRemoved.add(id);
                        ((ViewRegistry)vReg).remove(id);
                    }
                    ++k;
                }
                Object[] showViewIdsRemoved = this.findShowViewIdsRemoved(((WorkbenchPage)pages[j]).getShowViewActionIds(), viewsRemoved);
                if (showViewIdsRemoved.length > 0) {
                    this.removeViewIdsFromShowViewMenu(window, showViewIdsRemoved);
                }
                ++j;
            }
            ++i;
        }
        if (result.getSeverity() != 0) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Workbench.problemsSaving"), (String)WorkbenchMessages.getString("Workbench.problemsSavingMsg"), (IStatus)result);
        }
    }

    private void saveViewState(IWorkbenchPage page, String id, IMemento memento) {
        Perspective persp = ((WorkbenchPage)page).getActivePerspective();
        if (persp.findView(id) != null) {
            memento.putString("perspective", persp.getDesc().getId());
        }
    }

    private Object[] findShowViewIdsRemoved(ArrayList showViewIds, ArrayList viewsRemoved) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] showViewIdList = showViewIds.toArray();
        Object[] viewsRemovedList = viewsRemoved.toArray();
        int i = 0;
        while (i < showViewIdList.length) {
            int j = 0;
            while (j < viewsRemovedList.length) {
                if (((String)viewsRemovedList[j]).equals((String)showViewIdList[i])) {
                    list.add(viewsRemovedList[j]);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray();
    }

    private void removeViewIdsFromShowViewMenu(IWorkbenchWindow window, Object[] viewsRemoved) {
        MenuManager menuManager = ((WorkbenchWindow)window).getMenuManager();
        IContributionItem[] items = menuManager.getItems();
        menuManager = null;
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof MenuManager && ((MenuManager)items[i]).getMenuText().equals("&Window")) {
                menuManager = (MenuManager)items[i];
                break;
            }
            ++i;
        }
        if (menuManager == null) {
            return;
        }
        items = menuManager.getItems();
        menuManager = null;
        i = 0;
        while (i < items.length) {
            if (items[i] instanceof MenuManager && ((MenuManager)items[i]).getMenuText().equals("Show &View")) {
                menuManager = (MenuManager)items[i];
                break;
            }
            ++i;
        }
        if (menuManager == null) {
            return;
        }
        items = menuManager.getItems();
        if (items.length < 1 || !(items[0] instanceof ShowViewMenu)) {
            return;
        }
        i = 0;
        while (i < viewsRemoved.length) {
            ((ShowViewMenu)items[0]).removeAction((String)viewsRemoved[i]);
            ++i;
        }
    }

    private void loadEditor(IExtension ext) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Workbench.problemsRestoring"), null);
        IEditorRegistry eReg = WorkbenchPlugin.getDefault().getEditorRegistry();
        EditorRegistryReader eReader = new EditorRegistryReader();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATT_ID);
            if (id == null || eReg.findEditor(id) == null) {
                eReader.readElement((EditorRegistry)eReg, elements[i]);
            }
            ++i;
        }
        if (result.getSeverity() == 4) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Workspace.problemsTitle"), (String)WorkbenchMessages.getString("Workbench.problemsRestoringMsg"), (IStatus)result);
        }
    }

    private void restoreEditorState(IConfigurationElement element, MultiStatus result) {
        String id = element.getAttribute(ATT_ID);
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference existingVisible = ((WorkbenchPage)pages[j]).getEditorPresentation().getVisibleEditor();
                EditorManager editorManager = ((WorkbenchPage)pages[j]).getEditorManager();
                ArrayList visibleEditors = new ArrayList(5);
                IEditorPart[] activeEditor = new IEditorPart[1];
                ArrayList errorWorkbooks = new ArrayList(1);
                IMemento memento = (IMemento)((WorkbenchPage)pages[j]).getStateMap().remove(id);
                if (memento != null) {
                    IMemento[] editorMems = memento.getChildren("editor");
                    int k = 0;
                    while (k < editorMems.length) {
                        if (this.checkOpenable(editorMems[k], pages[j])) {
                            editorManager.restoreEditorState(editorMems[k], visibleEditors, activeEditor, errorWorkbooks, result);
                        }
                        ++k;
                    }
                    if (existingVisible == null) {
                        k = 0;
                        while (k < visibleEditors.size()) {
                            editorManager.setVisibleEditor((IEditorReference)visibleEditors.get(k), false);
                            ++k;
                        }
                    } else {
                        editorManager.setVisibleEditor(existingVisible, true);
                    }
                    if (visibleEditors.size() == 1) {
                        Iterator iter = errorWorkbooks.iterator();
                        while (iter.hasNext()) {
                            iter.next();
                            ((WorkbenchPage)pages[j]).getEditorPresentation().fixVisibleEditor();
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean checkOpenable(IMemento memento, IWorkbenchPage page) {
        IMemento inputMem = memento.getChild("input");
        String factoryID = null;
        if (inputMem != null) {
            factoryID = inputMem.getString("factoryID");
        }
        if (factoryID == null) {
            return false;
        }
        IElementFactory factory = WorkbenchPlugin.getDefault().getElementFactory(factoryID);
        if (factory == null) {
            return false;
        }
        IAdaptable input = factory.createElement(inputMem);
        if (input == null || !(input instanceof IEditorInput)) {
            return false;
        }
        IEditorInput editorInput = (IEditorInput)input;
        IEditorReference[] edRefs = page.getEditorReferences();
        int i = 0;
        while (i < edRefs.length) {
            IEditorInput edInput;
            IEditorPart editor = edRefs[i].getEditor(false);
            if (editor != null && (edInput = editor.getEditorInput()).equals(editorInput)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void unloadEditor(IExtension ext) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("EditorManager.problemsSavingEditors"), null);
        EditorRegistry eReg = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATT_ID);
            int j = 0;
            while (j < windows.length) {
                WorkbenchWindow window = (WorkbenchWindow)windows[j];
                IWorkbenchPage[] pages = window.getPages();
                int k = 0;
                while (k < pages.length) {
                    this.closeEditors(pages[k], id, result);
                    ++k;
                }
                ++j;
            }
            eReg.remove(id);
            ++i;
        }
        if (result.getSeverity() != 0) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Workbench.problemsSaving"), (String)WorkbenchMessages.getString("Workbench.problemsSavingMsg"), (IStatus)result);
        }
    }

    private void closeEditors(IWorkbenchPage page, String id, MultiStatus result) {
        XMLMemento memento = XMLMemento.createWriteRoot("editors");
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editorRefs[i].getId().equals(id)) {
                IEditorReference e = editorRefs[i];
                IEditorPart editor = e.getEditor(true);
                EditorManager editorManager = ((WorkbenchPage)page).getEditorManager();
                if (editor == null) {
                    IMemento mem = editorManager.getMemento(editorRefs[i]);
                    if (mem != null) {
                        IMemento editorMem = memento.createChild("editor");
                        editorMem.putMemento(mem);
                    }
                } else {
                    editorManager.saveEditorState(memento, e, result);
                }
                page.closeEditor(editor, true);
            }
            ++i;
        }
    }

    private void unloadPerspective(IExtension ext) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("ViewFactory.problemsSavingViews"), null);
        IPerspectiveRegistry pReg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IPerspectiveDescriptor desc;
            String id;
            if (elements[i].getName().equals("perspective") && (id = elements[i].getAttribute(ATT_ID)) != null && (desc = pReg.findPerspectiveWithId(id)) != null) {
                ((PerspectiveRegistry)pReg).deletePerspective(desc);
                IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
                int j = 0;
                while (j < windows.length) {
                    WorkbenchWindow window = (WorkbenchWindow)windows[j];
                    IWorkbenchPage[] pages = window.getPages();
                    int k = 0;
                    while (k < pages.length) {
                        ((WorkbenchPage)pages[k]).closePerspective(desc, true);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (result.getSeverity() != 0) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Workbench.problemsSaving"), (String)WorkbenchMessages.getString("Workbench.problemsSavingMsg"), (IStatus)result);
        }
    }

    private void loadPerspectiveExtensions(IExtension ext) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IPerspectiveDescriptor persp = page.getPerspective();
        if (persp == null) {
            return;
        }
        String currentId = persp.getId();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATT_TARGET_ID);
            if (id != null && id.equals(currentId)) {
                this.changeList.add(MessageFormat.format(ExtensionEventHandlerMessages.getString("ExtensionEventHandler.change_format"), ext.getNamespace(), ExtensionEventHandlerMessages.getString("ExtensionEventHandler.newPerspectiveExtension")));
                break;
            }
            ++i;
        }
    }

    private void restorePerspectiveState(MultiStatus result, String id) {
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = pages.length - 1;
            while (j >= 0) {
                IMemento memento = (IMemento)((WorkbenchPage)pages[j]).getStateMap().remove(id);
                if (memento != null) {
                    try {
                        Perspective persp = new Perspective(null, (WorkbenchPage)pages[j]);
                        result.merge(persp.restoreState(memento));
                        ((WorkbenchPage)pages[j]).addPerspective(persp);
                        ((WorkbenchWindow)windows[i]).addPerspectiveShortcut(persp.getDesc(), (WorkbenchPage)pages[j]);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
                --j;
            }
            ++i;
        }
    }

    private void resetCurrentPerspective(Display display) {
        if (this.changeList.isEmpty()) {
            return;
        }
        final StringBuffer message = new StringBuffer(ExtensionEventHandlerMessages.getString("ExtensionEventHandler.following_changes"));
        Iterator i = this.changeList.iterator();
        while (i.hasNext()) {
            message.append(i.next());
        }
        message.append(ExtensionEventHandlerMessages.getString("ExtensionEventHandler.need_to_reset"));
        display.asyncExec(new Runnable(){

            public void run() {
                Shell parentShell = null;
                IWorkbenchWindow window = ExtensionEventHandler.this.workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    if (ExtensionEventHandler.this.workbench.getWorkbenchWindowCount() == 0) {
                        return;
                    }
                    window = ExtensionEventHandler.this.workbench.getWorkbenchWindows()[0];
                }
                if (MessageDialog.openQuestion((Shell)(parentShell = window.getShell()), (String)ExtensionEventHandlerMessages.getString("ExtensionEventHandler.reset_perspective"), (String)message.toString())) {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null) {
                        return;
                    }
                    page.resetPerspective();
                }
            }
        });
    }

    private void unloadActionSets(IExtension ext) {
        ActionSetRegistry aReg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                int k = 0;
                while (k < elements.length) {
                    String id;
                    if (elements[k].getName().equals("actionSet") && (id = elements[k].getAttribute(ATT_ID)) != null) {
                        aReg.remove(id);
                        this.removeActionSet((WorkbenchPage)pages[j], id);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void removeActionSet(WorkbenchPage page, String id) {
        Perspective persp = page.getActivePerspective();
        ActionPresentation actionPresentation = ((WorkbenchWindow)page.getWorkbenchWindow()).getActionPresentation();
        IActionSet[] actionSets = actionPresentation.getActionSets();
        int i = 0;
        while (i < actionSets.length) {
            ActionSetDescriptor desc = ((PluginActionSet)actionSets[i]).getDesc();
            if (id.equals(desc.getId())) {
                PluginActionSetBuilder builder = new PluginActionSetBuilder();
                builder.removeActionExtensions((PluginActionSet)actionSets[i], page.getWorkbenchWindow());
                actionPresentation.removeActionSet(desc);
            }
            ++i;
        }
        if (persp != null) {
            persp.removeActionSet(id);
        }
    }

    private void loadActionSetPartAssociation(IExtension ext) {
        ActionSetRegistry aReg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        ActionSetPartAssociationsReader reader = new ActionSetPartAssociationsReader(aReg);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
    }

    private void unloadActionSetPartAssociation(IExtension ext) {
        ActionSetRegistry aReg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String type = elements[i].getName();
            if (type.equals(TAG_ACTION_SET_PART_ASSOCIATION)) {
                String actionSetId = elements[i].getAttribute(ATT_TARGET_ID);
                IConfigurationElement[] children = elements[i].getChildren();
                int j = 0;
                while (j < children.length) {
                    String partId;
                    IConfigurationElement child = children[j];
                    type = child.getName();
                    if (type.equals(TAG_PART) && (partId = child.getAttribute(ATT_ID)) != null) {
                        aReg.removeAssociation(actionSetId, partId);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void loadWorkingSets(IExtension ext) {
        WorkingSetRegistry wReg = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        WorkingSetRegistryReader reader = new WorkingSetRegistryReader(wReg);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
    }

    private void unloadWorkingSets(IExtension ext) {
        WorkingSetRegistry wReg = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            wReg.removeWorkingSetDescriptor(elements[i].getAttribute(ATT_ID));
            ++i;
        }
    }

    private void stopView(IExtension ext) {
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IConfigurationElement[] elements = ext.getConfigurationElements();
                int k = 0;
                while (k < elements.length) {
                    ViewFactory viewFactory;
                    IViewReference viewRef;
                    String id;
                    if (elements[k].getName().equals("view") && (id = elements[k].getAttribute(ATT_ID)) != null && (viewRef = (viewFactory = ((WorkbenchPage)pages[j]).getViewFactory()).getView(id)) != null) {
                        ((WorkbenchPage)pages[j]).hideView(viewRef);
                        ((WorkbenchPage)pages[j]).getViewFactory().releaseView(viewRef);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void stopEditor(IExtension ext) {
        IConfigurationElement[] elements = ext.getConfigurationElements();
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATT_ID);
            int j = 0;
            while (j < windows.length) {
                WorkbenchWindow window = (WorkbenchWindow)windows[j];
                IWorkbenchPage[] pages = window.getPages();
                int k = 0;
                while (k < pages.length) {
                    IEditorReference[] editorRefs = pages[k].getEditorReferences();
                    int l = 0;
                    while (l < editorRefs.length) {
                        IEditorPart editor;
                        if (editorRefs[l].getId().equals(id) && (editor = editorRefs[l].getEditor(true)) != null) {
                            pages[k].closeEditor(editor, true);
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void stopPerspective(IExtension ext) {
        IPerspectiveRegistry pReg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IPerspectiveDescriptor desc;
            String id;
            if (elements[i].getName().equals("perspective") && (id = elements[i].getAttribute(ATT_ID)) != null && (desc = pReg.findPerspectiveWithId(id)) != null) {
                ((PerspectiveRegistry)pReg).deletePerspective(desc);
                IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
                int j = 0;
                while (j < windows.length) {
                    WorkbenchWindow window = (WorkbenchWindow)windows[j];
                    IWorkbenchPage[] pages = window.getPages();
                    int k = 0;
                    while (k < pages.length) {
                        Perspective persp = ((WorkbenchPage)pages[k]).findPerspective(desc);
                        if (persp == null) {
                            return;
                        }
                        ((WorkbenchPage)pages[k]).closePerspective(desc, true);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void stopActionSets(IExtension ext) {
        WorkbenchPlugin.getDefault().getActionSetRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                int k = 0;
                while (k < elements.length) {
                    String id;
                    if (elements[k].getName().equals("actionSet") && (id = elements[k].getAttribute(ATT_ID)) != null) {
                        ((WorkbenchPage)pages[j]).hideActionSet(id);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

