/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.contexts.ContextDefinition;
import org.eclipse.ui.internal.util.Util;

final class Persistence {
    static final String PACKAGE_BASE = "contexts";
    static final String PACKAGE_FULL = "org.eclipse.ui.contexts";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String TAG_CONTEXT = "context";
    static final String TAG_ID = "id";
    static final String TAG_NAME = "name";
    static final String TAG_PARENT = "parent";
    static final String TAG_PARENT_ID = "parentId";
    static final String TAG_PARENT_SCOPE = "parentScope";
    static final String TAG_SOURCE_ID = "sourceId";
    static /* synthetic */ Class class$0;

    static ContextDefinition readContextDefinition(IMemento memento, String sourceIdOverride) {
        String sourceId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String parentId = memento.getString(TAG_PARENT_ID);
        String string = sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        if (parentId == null) {
            parentId = memento.getString(TAG_PARENT_SCOPE);
        }
        if (parentId == null) {
            parentId = memento.getString(TAG_PARENT);
        }
        return new ContextDefinition(id, name, parentId, sourceId);
    }

    static List readContextDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ContextDefinition> list = new ArrayList<ContextDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readContextDefinition(mementos[i], sourceIdOverride));
            ++i;
        }
        return list;
    }

    static void writeContextDefinition(IMemento memento, ContextDefinition contextDefinition) {
        if (memento == null || contextDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ID, contextDefinition.getId());
        memento.putString(TAG_NAME, contextDefinition.getName());
        memento.putString(TAG_PARENT_ID, contextDefinition.getParentId());
        memento.putString(TAG_SOURCE_ID, contextDefinition.getSourceId());
    }

    static void writeContextDefinitions(IMemento memento, String name, List contextDefinitions) {
        if (memento == null || name == null || contextDefinitions == null) {
            throw new NullPointerException();
        }
        contextDefinitions = new ArrayList(contextDefinitions);
        Iterator iterator = contextDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.contexts.ContextDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = contextDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeContextDefinition(memento.createChild(name), (ContextDefinition)iterator.next());
        }
    }

    private Persistence() {
    }
}

