/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PreferenceErrorDialog;
import org.eclipse.ui.internal.dialogs.PreferenceImportExportFileSelectionPage;

public class WorkbenchPreferenceDialog
extends FilteredPreferenceDialog {
    private static final int LOAD_ID = 1025;
    private static final int SAVE_ID = 1026;
    static final String FILE_PATH_SETTING = "PreferenceImportExportFileSelectionPage.filePath";

    public WorkbenchPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.loadPressed();
                return;
            }
            case 1026: {
                this.savePressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1025, WorkbenchMessages.getString("WorkbenchPreferenceDialog.load"), false);
        this.createButton(parent, 1026, WorkbenchMessages.getString("WorkbenchPreferenceDialog.save"), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void loadPressed() {
        IPath filePath = this.getFilePath(false);
        if (filePath == null) {
            return;
        }
        this.importPreferences(filePath);
        this.close();
    }

    private IPath getFilePath(boolean export) {
        String currentFileName = this.getFileNameSetting(export);
        FileDialog fileDialog = null;
        fileDialog = export ? new FileDialog(this.getShell(), 8192) : new FileDialog(this.getShell(), 4096);
        if (currentFileName != null) {
            fileDialog.setFileName(currentFileName);
        }
        fileDialog.setFilterExtensions(PreferenceImportExportFileSelectionPage.DIALOG_PREFERENCE_EXTENSIONS);
        currentFileName = fileDialog.open();
        if (currentFileName == null) {
            return null;
        }
        String fileName = new File(currentFileName).getName();
        if (fileName.lastIndexOf(".") == -1) {
            currentFileName = String.valueOf(currentFileName) + ".epf";
        }
        this.setFileNameSetting(currentFileName);
        return new Path(currentFileName);
    }

    private void setFileNameSetting(String currentFileName) {
        if (currentFileName != null) {
            WorkbenchPlugin.getDefault().getDialogSettings().put(FILE_PATH_SETTING, currentFileName);
        }
    }

    private String getFileNameSetting(boolean export) {
        String lastFileName = WorkbenchPlugin.getDefault().getDialogSettings().get(FILE_PATH_SETTING);
        if (lastFileName == null) {
            if (export) {
                return String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + WorkbenchMessages.getString("ImportExportPages.preferenceFileName") + ".epf";
            }
        } else if (export || new File(lastFileName).exists()) {
            return lastFileName;
        }
        return null;
    }

    protected void savePressed() {
        IPath filePath = this.getFilePath(false);
        if (filePath == null) {
            return;
        }
        this.exportPreferences(filePath);
        this.close();
    }

    private boolean exportPreferences(IPath path) {
        File selectedFile = path.toFile();
        if (selectedFile.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.existsErrorMessage", new Object[]{path.toOSString()}))) {
            return false;
        }
        try {
            Preferences.exportPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.saveErrorMessage", new Object[]{path.toOSString()}), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private boolean importPreferences(IPath path) {
        int result;
        IStatus status = Preferences.validatePreferenceVersions((IPath)path);
        if (status.getSeverity() == 4) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyErrorMessage", new Object[]{path.toOSString()}), (IStatus)status);
            return false;
        }
        if (status.getSeverity() == 2 && (result = PreferenceErrorDialog.openError(this.getShell(), WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyWarningMessage", new Object[]{path.toOSString()}), status)) != 0) {
            return false;
        }
        try {
            Preferences.importPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadErrorMessage", new Object[]{path.toOSString()}), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }
}

