/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dnd.DragUtil;

public class SwtUtil {
    private SwtUtil() {
    }

    public static boolean isDisposed(Control toTest) {
        return toTest == null || toTest.isDisposed();
    }

    public static boolean isChild(Control potentialParent, Control childToTest) {
        if (childToTest == null) {
            return false;
        }
        if (childToTest == potentialParent) {
            return true;
        }
        return SwtUtil.isChild(potentialParent, (Control)childToTest.getParent());
    }

    public static Control findControl(Display displayToSearch, Point locationToFind) {
        Shell[] shells = displayToSearch.getShells();
        return SwtUtil.findControl((Control[])shells, locationToFind);
    }

    public static Control findControl(Control[] toSearch, Point locationToFind) {
        int idx = toSearch.length - 1;
        while (idx >= 0) {
            Rectangle bounds;
            Control next = toSearch[idx];
            if (!next.isDisposed() && next.isVisible() && (bounds = DragUtil.getDisplayBounds(next)).contains(locationToFind)) {
                if (next instanceof Composite) {
                    Composite cfr_ignored_0 = (Composite)next;
                    Control result = SwtUtil.findControl((Composite)next, locationToFind);
                    if (result != null) {
                        return result;
                    }
                }
                return next;
            }
            --idx;
        }
        return null;
    }

    public static Control findControl(Composite toSearch, Point locationToFind) {
        Control[] children = toSearch.getChildren();
        return SwtUtil.findControl(children, locationToFind);
    }
}

