/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.newapi;

import java.util.ArrayList;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.presentations.newapi.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.newapi.AbstractTabFolderListener;
import org.eclipse.ui.internal.presentations.newapi.AbstractTabItem;
import org.eclipse.ui.internal.presentations.newapi.IPresentablePartList;
import org.eclipse.ui.internal.presentations.newapi.TabDragHandler;
import org.eclipse.ui.internal.presentations.newapi.TabOrder;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public final class TabbedStackPresentation
extends StackPresentation {
    private static final String TAB_DATA = "part";
    private static final String BOLD_DATA = "isBold";
    private AbstractTabFolder tabFolder;
    private TabOrder tabs;
    private TabDragHandler dragBehavior;
    private int ignoreSelectionChanges = 0;
    private boolean initializing = true;
    private int dragStart = -1;
    private IPresentablePartList tabOrderListener = new IPresentablePartList(){

        public void insert(IPresentablePart part, int idx) {
            TabbedStackPresentation.this.doInsert(part, idx);
        }

        public void remove(IPresentablePart part) {
            TabbedStackPresentation.this.doRemove(part);
        }

        public void move(IPresentablePart part, int newIndex) {
            TabbedStackPresentation.this.doMove(part, newIndex);
        }

        public int size() {
            return TabbedStackPresentation.this.tabFolder.getItemCount();
        }

        public void select(IPresentablePart toSelect) {
            TabbedStackPresentation.this.doSelect(toSelect);
        }
    };
    private IPropertyListener childPropertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int property) {
            if (source instanceof IPresentablePart) {
                IPresentablePart part = (IPresentablePart)source;
                TabbedStackPresentation.this.childPropertyChanged(part, property);
            }
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            IPresentablePart part = TabbedStackPresentation.this.getPartForTab(e.widget);
            part.removePropertyListener(TabbedStackPresentation.this.childPropertyChangeListener);
        }
    };
    private DisposeListener toolbarDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            TabbedStackPresentation.this.setToolbar(null);
        }
    };
    private AbstractTabFolderListener tabFolderListener = new AbstractTabFolderListener(){

        public void stateButtonPressed(int buttonId) {
            TabbedStackPresentation.this.getSite().setState(buttonId);
        }

        public void closeButtonPressed(AbstractTabItem item) {
            IPresentablePart part = TabbedStackPresentation.this.getPartForTab(item.getControl());
            TabbedStackPresentation.this.getSite().close(new IPresentablePart[]{part});
        }

        public void showList() {
            TabbedStackPresentation.this.showPartList();
        }

        public void showPaneMenu(Point location) {
            TabbedStackPresentation.this.showPaneMenu(location);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void dragStart(AbstractTabItem beingDragged, Point initialLocation) {
            if (beingDragged == null) {
                TabbedStackPresentation.this.getSite().dragStart(initialLocation, false);
                return;
            }
            TabbedStackPresentation.this.dragStart = TabbedStackPresentation.this.tabFolder.indexOf(beingDragged);
            try {
                IPresentablePart part = TabbedStackPresentation.this.getPartForTab(beingDragged.getControl());
                TabbedStackPresentation.this.getSite().dragStart(part, initialLocation, false);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                TabbedStackPresentation.this.dragStart = -1;
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            TabbedStackPresentation.this.dragStart = -1;
        }
    };
    private ShellListener shellListener = new ShellAdapter(){

        public void shellActivated(ShellEvent e) {
            TabbedStackPresentation.this.tabFolder.shellActive(true);
        }

        public void shellDeactivated(ShellEvent e) {
            TabbedStackPresentation.this.tabFolder.shellActive(false);
        }
    };

    public TabbedStackPresentation(IStackPresentationSite site, AbstractTabFolder folder, TabOrder tabs, TabDragHandler dragBehavior) {
        super(site);
        this.tabFolder = folder;
        this.tabs = tabs;
        this.dragBehavior = dragBehavior;
        folder.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TabbedStackPresentation.this.presentationDisposed();
            }
        });
        folder.allowMaximizeButton(this.getSite().supportsState(1));
        folder.allowMinimizeButton(this.getSite().supportsState(0));
        folder.addListener(this.tabFolderListener);
        this.tabFolder.getControl().getShell().addShellListener(this.shellListener);
        this.tabFolder.shellActive(this.tabFolder.getControl().getDisplay().getActiveShell() == this.tabFolder.getControl().getShell());
    }

    private void childPropertyChanged(IPresentablePart part, int property) {
        AbstractTabItem tab = this.getTab(part);
        if (tab == null) {
            return;
        }
        switch (property) {
            case 148: {
                if (this.getCurrent() == part) break;
                tab.getControl().setData(BOLD_DATA, (Object)BOLD_DATA);
                this.initTab(tab, part);
                break;
            }
            case 1: 
            case 147: 
            case 261: 
            case 770: {
                if (this.getCurrent() != part) break;
                this.initTab(tab, part);
                this.layout(true);
                break;
            }
            default: {
                this.initTab(tab, part);
            }
        }
    }

    protected void initTab(AbstractTabItem item, IPresentablePart part) {
        if (!Util.equals(part.getName(), item.getPartName())) {
            item.setPartName(part.getName());
        }
        if (item.getImage() != part.getTitleImage()) {
            item.setImage(part.getTitleImage());
        }
        if (!Util.equals(part.getTitleToolTip(), item.getTitleToolTip())) {
            item.setTitleToolTip(part.getTitleToolTip());
        }
        boolean isBold = item.getControl().getData(BOLD_DATA) != null;
        item.setBusyState(part.isBusy(), isBold);
    }

    private IPresentablePart getCurrent() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.getSite().getSelectedPart();
    }

    private IPresentablePart getPartForTab(Widget tab) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        IPresentablePart part = (IPresentablePart)tab.getData(TAB_DATA);
        return part;
    }

    protected final AbstractTabItem getTab(IPresentablePart part) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        AbstractTabItem[] items = this.tabFolder.getItems();
        int idx = 0;
        while (idx < items.length) {
            AbstractTabItem item = items[idx];
            if (this.getPartForTab(item.getControl()) == part) {
                return item;
            }
            ++idx;
        }
        return null;
    }

    private int indexOf(IPresentablePart part) {
        AbstractTabItem item = this.getTab(part);
        if (item == null) {
            return -1;
        }
        return this.tabFolder.indexOf(item);
    }

    private boolean isDisposed() {
        return this.tabFolder != null && !SwtUtil.isDisposed(this.tabFolder.getControl());
    }

    public void setBounds(Rectangle bounds) {
        this.tabFolder.getControl().setBounds(bounds);
        this.layout(false);
    }

    public void layout(boolean changed) {
        this.tabFolder.layout(changed);
        IPresentablePart current = this.getSite().getSelectedPart();
        if (current != null) {
            Rectangle clientArea = this.tabFolder.getClientArea();
            Point clientAreaStart = this.tabFolder.getControl().getParent().toControl(this.tabFolder.getControl().toDisplay(clientArea.x, clientArea.y));
            clientArea.x = clientAreaStart.x;
            clientArea.y = clientAreaStart.y;
            current.setBounds(clientArea);
        }
    }

    public Point computeMinimumSize() {
        return this.tabFolder.computeMinimumSize();
    }

    public void dispose() {
        this.tabFolder.getControl().dispose();
    }

    private void presentationDisposed() {
        this.setToolbar(null);
        this.tabFolder.disposed();
    }

    public void setActive(int newState) {
        this.tabFolder.setActive(newState);
    }

    public void setVisible(boolean isVisible) {
        this.tabFolder.getControl().setVisible(isVisible);
        IPresentablePart current = this.getSite().getSelectedPart();
        if (current != null) {
            current.setVisible(true);
        }
        if (isVisible) {
            this.layout(true);
        }
    }

    public void setState(int state) {
        this.tabFolder.setState(state);
    }

    public Control getControl() {
        return this.tabFolder.getControl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPart(IPresentablePart newPart, Object cookie) {
        ++this.ignoreSelectionChanges;
        try {
            if (this.initializing) {
                this.tabs.addInitial(newPart, this.tabOrderListener);
            } else if (cookie == null) {
                this.tabs.add(newPart, this.tabOrderListener);
            } else {
                int insertionPoint = this.dragBehavior.getInsertionPosition(cookie);
                this.tabs.insert(newPart, insertionPoint, this.tabOrderListener);
            }
            Object var4_6 = null;
            --this.ignoreSelectionChanges;
            return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.ignoreSelectionChanges;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doInsert(IPresentablePart part, int insertionIndex) {
        AbstractTabItem item;
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        if (this.getTab(part) != null) {
            return;
        }
        insertionIndex = Math.min(insertionIndex, this.tabFolder.getItemCount());
        ++this.ignoreSelectionChanges;
        try {
            item = this.tabFolder.add(insertionIndex);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.ignoreSelectionChanges;
            throw throwable;
        }
        {
            Object var4_6 = null;
            --this.ignoreSelectionChanges;
            item.setCloseable(this.getSite().isCloseable(part));
        }
        item.getControl().setData(TAB_DATA, (Object)part);
        this.initTab(item, part);
        part.addPropertyListener(this.childPropertyChangeListener);
        item.getControl().addDisposeListener(this.tabDisposeListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRemove(IPresentablePart toRemove) {
        ++this.ignoreSelectionChanges;
        try {
            AbstractTabItem item = this.getTab(toRemove);
            item.getControl().dispose();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            --this.ignoreSelectionChanges;
            throw throwable;
        }
        {
            Object var3_5 = null;
            --this.ignoreSelectionChanges;
            return;
        }
    }

    private void doSelect(IPresentablePart toSelect) {
        if (this.ignoreSelectionChanges > 0) {
            return;
        }
        AbstractTabItem selectedItem = this.getTab(toSelect);
        this.tabFolder.setSelection(selectedItem);
        if (selectedItem != null && !selectedItem.getControl().isDisposed()) {
            if (selectedItem.getControl().getData(BOLD_DATA) != null) {
                selectedItem.getControl().setData(BOLD_DATA, null);
                this.initTab(selectedItem, toSelect);
            }
            this.setToolbar(toSelect.getToolBar());
        } else {
            this.setToolbar(null);
        }
        this.layout(true);
    }

    private void setToolbar(Control newToolbar) {
        Control oldToolbar = this.tabFolder.getToolbar();
        if (oldToolbar != null && !oldToolbar.isDisposed()) {
            oldToolbar.removeDisposeListener(this.toolbarDisposeListener);
        }
        if (newToolbar != null) {
            newToolbar.addDisposeListener(this.toolbarDisposeListener);
        }
        this.tabFolder.setToolbar(newToolbar);
    }

    protected void doMove(IPresentablePart part, int newIndex) {
        int currentIndex = this.indexOf(part);
        if (currentIndex == newIndex) {
            return;
        }
        this.doRemove(part);
        this.doInsert(part, newIndex);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePart(IPresentablePart oldPart) {
        ++this.ignoreSelectionChanges;
        try {
            this.tabs.remove(oldPart, this.tabOrderListener);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            --this.ignoreSelectionChanges;
            throw throwable;
        }
        {
            Object var2_4 = null;
            --this.ignoreSelectionChanges;
            return;
        }
    }

    public void selectPart(IPresentablePart toSelect) {
        this.initializing = false;
        this.tabs.select(toSelect, this.tabOrderListener);
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        return this.dragBehavior.dragOver(currentControl, location, this.dragStart);
    }

    public void showSystemMenu() {
    }

    public void showPaneMenu() {
        this.showPaneMenu(this.tabFolder.getPaneMenuLocation());
    }

    public void showPaneMenu(Point location) {
    }

    public Control[] getTabList(IPresentablePart part) {
        ArrayList<Control> list = new ArrayList<Control>();
        if (this.tabFolder.getTabPosition() == 1024 && part.getControl() != null) {
            list.add(part.getControl());
        }
        Control[] tabFolderTabList = this.tabFolder.getTabList();
        int i = 0;
        while (i < tabFolderTabList.length) {
            list.add(tabFolderTabList[i]);
            ++i;
        }
        if (this.tabFolder.getTabPosition() == 128 && part.getControl() != null) {
            list.add(part.getControl());
        }
        return list.toArray(new Control[list.size()]);
    }
}

