/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ErrorInfo;
import org.eclipse.ui.internal.progress.ErrorNotificationDialog;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ErrorNotificationManager {
    private static final String ERROR_JOB = "errorstate.gif";
    static final String ERROR_JOB_KEY = "ERROR_JOB";
    private Collection errors = Collections.synchronizedSet(new HashSet());
    private ErrorNotificationDialog dialog;
    private boolean dialogActive = false;

    void setUpImages(URL iconsRoot) throws MalformedURLException {
        JFaceResources.getImageRegistry().put(ERROR_JOB_KEY, ImageDescriptor.createFromURL((URL)new URL(iconsRoot, ERROR_JOB)));
    }

    void addError(IStatus status, String jobName) {
        final Throwable exception = status.getException();
        if (exception != null && exception instanceof OutOfMemoryError) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ExceptionHandler.getInstance().handleException(exception);
                }
            });
            return;
        }
        this.errors.add(new ErrorInfo(status, jobName));
        if (this.dialogActive) {
            if (this.dialog != null) {
                this.refreshDialog();
            }
        } else {
            this.openErrorDialog(jobName, status);
        }
    }

    private void refreshDialog() {
        UIJob refreshJob = new UIJob(ProgressMessages.getString("ErrorNotificationManager.RefreshErrorDialogJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ErrorNotificationManager.this.dialog.refresh();
                return Status.OK_STATUS;
            }
        };
        refreshJob.setSystem(true);
        refreshJob.schedule();
    }

    Collection getErrors() {
        return this.errors;
    }

    private void openErrorDialog(String jobName, IStatus status) {
        if (!PlatformUI.isWorkbenchRunning()) {
            WorkbenchPlugin.log(jobName, status);
            return;
        }
        this.dialogActive = true;
        WorkbenchJob job = new WorkbenchJob(ProgressMessages.getString("ErrorNotificationManager.OpenErrorDialogJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench instanceof Workbench && ((Workbench)workbench).isClosing()) {
                    return Status.CANCEL_STATUS;
                }
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    return Status.CANCEL_STATUS;
                }
                ErrorNotificationManager.this.dialog = new ErrorNotificationDialog(window.getShell());
                ErrorNotificationManager.this.dialog.open();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    void removeErrors(Collection errorsToRemove) {
        this.errors.removeAll(errorsToRemove);
        this.removeFromFinishedJobs(errorsToRemove);
    }

    private void removeFromFinishedJobs(Collection errorsToRemove) {
        Iterator errorIterator = errorsToRemove.iterator();
        HashSet<IStatus> errorStatuses = new HashSet<IStatus>();
        while (errorIterator.hasNext()) {
            ErrorInfo next = (ErrorInfo)errorIterator.next();
            errorStatuses.add(next.getErrorStatus());
        }
        JobTreeElement[] infos = FinishedJobs.getInstance().getJobInfos();
        int i = 0;
        while (i < infos.length) {
            JobInfo info;
            if (infos[i].isJobInfo() && errorStatuses.contains((info = (JobInfo)infos[i]).getJob().getResult())) {
                FinishedJobs.getInstance().remove(info);
            }
            ++i;
        }
    }

    void clearAllErrors() {
        this.removeFromFinishedJobs(this.errors);
        this.errors.clear();
    }

    void clearDialog() {
        this.dialog = null;
        this.dialogActive = false;
    }
}

