/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PropertyPagesRegistryReader
extends RegistryReader {
    public static final String ATT_NAME_FILTER = "nameFilter";
    public static final String ATT_FILTER_NAME = "name";
    public static final String ATT_FILTER_VALUE = "value";
    public static final String ATT_CLASS = "class";
    private static final String TAG_PAGE = "page";
    private static final String TAG_FILTER = "filter";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private static final String ATT_ICON = "icon";
    private static final String ATT_OBJECTCLASS = "objectClass";
    private static final String ATT_ADAPTABLE = "adaptable";
    private static final String P_TRUE = "true";
    private HashMap filterProperties;
    private PropertyPageContributorManager manager;

    public PropertyPagesRegistryReader(PropertyPageContributorManager manager) {
        this.manager = manager;
    }

    private void processChildElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_FILTER)) {
            String key = element.getAttribute("name");
            String value = element.getAttribute(ATT_FILTER_VALUE);
            if (key == null || value == null) {
                return;
            }
            if (this.filterProperties == null) {
                this.filterProperties = new HashMap();
            }
            this.filterProperties.put(key, value);
        }
    }

    private void processPageElement(IConfigurationElement element) {
        String pluginId = element.getDeclaringExtension().getNamespace();
        String pageId = element.getAttribute(ATT_ID);
        String pageName = element.getAttribute("name");
        String iconName = element.getAttribute(ATT_ICON);
        String pageClassName = element.getAttribute(ATT_CLASS);
        String objectClassName = element.getAttribute(ATT_OBJECTCLASS);
        String adaptable = element.getAttribute(ATT_ADAPTABLE);
        if (pageId == null) {
            RegistryReader.logMissingAttribute(element, ATT_ID);
            return;
        }
        if (objectClassName == null) {
            RegistryReader.logMissingAttribute(element, ATT_OBJECTCLASS);
            return;
        }
        if (pageClassName == null) {
            RegistryReader.logMissingAttribute(element, ATT_CLASS);
            return;
        }
        this.filterProperties = null;
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            this.processChildElement(children[i]);
            ++i;
        }
        RegistryPageContributor contributor = new RegistryPageContributor(pluginId, pageId, pageName, iconName, this.filterProperties, objectClassName, P_TRUE.equalsIgnoreCase(adaptable), element);
        this.registerContributor(objectClassName, contributor);
    }

    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_PAGE)) {
            this.processPageElement(element);
            this.readElementChildren(element);
            return true;
        }
        return element.getName().equals(TAG_FILTER);
    }

    private void registerContributor(String objectClassName, IPropertyPageContributor contributor) {
        this.manager.registerContributor(contributor, objectClassName);
    }

    public void registerPropertyPages(IExtensionRegistry registry) {
        this.readRegistry(registry, "org.eclipse.ui", "propertyPages");
    }
}

