/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;

public class ThemeDescriptor
implements IThemeDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private Collection colors = new ArrayList();
    private IConfigurationElement configElement;
    private String description;
    private Collection fonts = new ArrayList();
    private String id;
    private String name;
    private Map dataMap = new HashMap();

    public ThemeDescriptor(IConfigurationElement e) throws CoreException {
        this.configElement = e;
        this.processExtension();
    }

    void add(ColorDefinition definition) {
        this.colors.add(definition);
    }

    void add(FontDefinition definition) {
        this.fonts.add(definition);
    }

    void setData(String key, Object data) {
        this.dataMap.put(key, data);
    }

    public ColorDefinition[] getColors() {
        ColorDefinition[] defs = this.colors.toArray(new ColorDefinition[this.colors.size()]);
        Arrays.sort(defs, IThemeRegistry.ID_COMPARATOR);
        return defs;
    }

    public String getDescription() {
        return this.description;
    }

    public FontDefinition[] getFonts() {
        FontDefinition[] defs = this.fonts.toArray(new FontDefinition[this.fonts.size()]);
        Arrays.sort(defs, IThemeRegistry.ID_COMPARATOR);
        return defs;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.name;
    }

    private void processExtension() throws CoreException {
        this.id = this.configElement.getAttribute(ATT_ID);
        this.name = this.configElement.getAttribute(ATT_NAME);
    }

    void setDescription(String description) {
        this.description = description;
    }

    public Map getData() {
        return Collections.unmodifiableMap(this.dataMap);
    }
}

