/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebSite;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IPersistStreamInit;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Browser
extends Composite {
    OleFrame frame;
    OleControlSite site;
    OleAutomation auto;
    boolean back;
    boolean forward;
    Point location;
    Point size;
    int globalDispatch;
    String html;
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    static final int BeforeNavigate2 = 250;
    static final int CommandStateChange = 105;
    static final int DocumentComplete = 259;
    static final int NavigateComplete2 = 252;
    static final int NewWindow2 = 251;
    static final int OnVisible = 254;
    static final int ProgressChange = 108;
    static final int RegisterAsBrowser = 552;
    static final int StatusTextChange = 102;
    static final int TitleChange = 113;
    static final int WindowClosing = 263;
    static final int WindowSetHeight = 267;
    static final int WindowSetLeft = 264;
    static final int WindowSetTop = 265;
    static final int WindowSetWidth = 266;
    static final short CSC_NAVIGATEFORWARD = 1;
    static final short CSC_NAVIGATEBACK = 2;
    static final int INET_E_DEFAULT_ACTION = -2146697199;
    static final int URLPOLICY_ALLOW = 0;
    static final int URLPOLICY_DISALLOW = 3;
    static final int URLZONE_LOCAL_MACHINE = 0;
    static final int URLZONE_INTRANET = 1;
    static final int URLACTION_ACTIVEX_MIN = 4608;
    static final int URLACTION_ACTIVEX_MAX = 5119;
    static final int URLACTION_JAVA_MIN = 7168;
    static final int URLPOLICY_JAVA_LOW = 196608;
    static final int URLACTION_JAVA_MAX = 7423;
    static final int DISPID_AMBIENT_DLCONTROL = -5512;
    static final int DLCTL_DLIMAGES = 16;
    static final int DLCTL_VIDEOS = 32;
    static final int DLCTL_BGSOUNDS = 64;
    static final int DLCTL_NO_SCRIPTS = 128;
    static final int DLCTL_NO_JAVA = 256;
    static final int DLCTL_NO_RUNACTIVEXCTLS = 512;
    static final int DLCTL_NO_DLACTIVEXCTLS = 1024;
    static final int DLCTL_DOWNLOADONLY = 2048;
    static final int DLCTL_NO_FRAMEDOWNLOAD = 4096;
    static final int DLCTL_RESYNCHRONIZE = 8192;
    static final int DLCTL_PRAGMA_NO_CACHE = 16384;
    static final int DLCTL_FORCEOFFLINE = 0x10000000;
    static final int DLCTL_NO_CLIENTPULL = 0x20000000;
    static final int DLCTL_SILENT = 0x40000000;
    static final int DOCHOSTUIFLAG_THEME = 262144;
    static final String ABOUT_BLANK = "about:blank";
    static final String URL_CAB = ".cab";
    static final String URL_DIRECTOR = "http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab";
    static final String URL_JAVA = "http://java.sun.com/products/plugin/autodl/jinstall";
    static final String URL_JAVA_15 = "http://java.sun.com/update";
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";

    public Browser(Composite parent, int style) {
        super(parent, style);
        this.frame = new OleFrame(this, 0);
        try {
            this.site = new WebSite((Composite)this.frame, 0, "Shell.Explorer");
        }
        catch (SWTException sWTException) {
            this.dispose();
            SWT.error(2);
        }
        this.site.doVerb(-5);
        this.auto = new OleAutomation(this.site);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                if (Browser.this.auto != null) {
                    Browser.this.auto.dispose();
                }
                Browser.this.auto = null;
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Browser.this.frame.setBounds(Browser.this.getClientArea());
            }
        });
        OleListener listener = new OleListener(){

            public void handleEvent(OleEvent event) {
                switch (event.type) {
                    case 250: {
                        Variant varResult = event.arguments[1];
                        String url = varResult.getString();
                        LocationEvent newEvent = new LocationEvent(Browser.this);
                        newEvent.display = Browser.this.getDisplay();
                        newEvent.widget = Browser.this;
                        newEvent.location = url;
                        newEvent.doit = true;
                        int i = 0;
                        while (i < Browser.this.locationListeners.length) {
                            Browser.this.locationListeners[i].changing(newEvent);
                            ++i;
                        }
                        Variant cancel = event.arguments[6];
                        if (cancel == null) break;
                        int pCancel = cancel.getByRef();
                        COM.MoveMemory(pCancel, new short[]{newEvent.doit ? (short)0 : -1}, 2);
                        break;
                    }
                    case 105: {
                        boolean enabled = false;
                        Variant varResult = event.arguments[0];
                        int command = varResult.getInt();
                        varResult = event.arguments[1];
                        enabled = varResult.getBoolean();
                        switch (command) {
                            case 2: {
                                Browser.this.back = enabled;
                                break;
                            }
                            case 1: {
                                Browser.this.forward = enabled;
                            }
                        }
                        break;
                    }
                    case 259: {
                        Variant varResult = event.arguments[0];
                        IDispatch dispatch = varResult.getDispatch();
                        varResult = event.arguments[1];
                        String url = varResult.getString();
                        if (Browser.this.html != null && url.equals(Browser.ABOUT_BLANK)) {
                            int charCount = Browser.this.html.length();
                            char[] chars = new char[charCount];
                            Browser.this.html.getChars(0, charCount, chars, 0);
                            Browser.this.html = null;
                            int byteCount = OS.WideCharToMultiByte(65001, 0, chars, charCount, null, 0, null, null);
                            byte[] UTF8BOM = new byte[]{-17, -69, -65};
                            int hGlobal = OS.GlobalAlloc(0, UTF8BOM.length + byteCount);
                            if (hGlobal == 0) break;
                            OS.MoveMemory(hGlobal, UTF8BOM, UTF8BOM.length);
                            OS.WideCharToMultiByte(65001, 0, chars, charCount, hGlobal + UTF8BOM.length, byteCount, null, null);
                            int[] ppstm = new int[1];
                            if (OS.CreateStreamOnHGlobal(hGlobal, true, ppstm) == 0) {
                                int[] ppvObject;
                                int[] rgdispid = Browser.this.auto.getIDsOfNames(new String[]{"Document"});
                                Variant pVarResult = Browser.this.auto.getProperty(rgdispid[0]);
                                IDispatch dispatchDocument = pVarResult.getDispatch();
                                int result = dispatchDocument.QueryInterface(COM.IIDIPersistStreamInit, ppvObject = new int[1]);
                                if (result == 0) {
                                    IPersistStreamInit persistStreamInit = new IPersistStreamInit(ppvObject[0]);
                                    if (persistStreamInit.InitNew() == 0) {
                                        persistStreamInit.Load(ppstm[0]);
                                    }
                                    persistStreamInit.Release();
                                }
                                pVarResult.dispose();
                                IUnknown stream = new IUnknown(ppstm[0]);
                                stream.Release();
                                break;
                            }
                            OS.GlobalFree(hGlobal);
                            break;
                        }
                        Variant variant = new Variant(Browser.this.auto);
                        IDispatch top = variant.getDispatch();
                        LocationEvent locationEvent = new LocationEvent(Browser.this);
                        locationEvent.display = Browser.this.getDisplay();
                        locationEvent.widget = Browser.this;
                        locationEvent.location = url;
                        locationEvent.top = top.getAddress() == dispatch.getAddress();
                        int i = 0;
                        while (i < Browser.this.locationListeners.length) {
                            Browser.this.locationListeners[i].changed(locationEvent);
                            ++i;
                        }
                        if (Browser.this.globalDispatch == 0 || dispatch.getAddress() != Browser.this.globalDispatch) break;
                        Browser.this.globalDispatch = 0;
                        ProgressEvent progressEvent = new ProgressEvent(Browser.this);
                        progressEvent.display = Browser.this.getDisplay();
                        progressEvent.widget = Browser.this;
                        int i2 = 0;
                        while (i2 < Browser.this.progressListeners.length) {
                            Browser.this.progressListeners[i2].completed(progressEvent);
                            ++i2;
                        }
                        break;
                    }
                    case 252: {
                        Variant varResult = event.arguments[0];
                        IDispatch dispatch = varResult.getDispatch();
                        if (Browser.this.globalDispatch != 0) break;
                        Browser.this.globalDispatch = dispatch.getAddress();
                        break;
                    }
                    case 251: {
                        boolean doit;
                        WindowEvent newEvent = new WindowEvent(Browser.this);
                        newEvent.display = Browser.this.getDisplay();
                        newEvent.widget = Browser.this;
                        int i = 0;
                        while (i < Browser.this.openWindowListeners.length) {
                            Browser.this.openWindowListeners[i].open(newEvent);
                            ++i;
                        }
                        Browser browser = newEvent.browser;
                        boolean bl = doit = browser != null && !browser.isDisposed();
                        if (doit) {
                            Variant variant = new Variant(browser.auto);
                            IDispatch iDispatch = variant.getDispatch();
                            Variant ppDisp = event.arguments[0];
                            int byref = ppDisp.getByRef();
                            if (byref != 0) {
                                COM.MoveMemory(byref, new int[]{iDispatch.getAddress()}, 4);
                            }
                        }
                        Variant cancel = event.arguments[1];
                        int pCancel = cancel.getByRef();
                        COM.MoveMemory(pCancel, new short[]{doit ? (short)0 : -1}, 2);
                        break;
                    }
                    case 254: {
                        Variant arg1 = event.arguments[0];
                        boolean visible = arg1.getBoolean();
                        WindowEvent newEvent = new WindowEvent(Browser.this);
                        newEvent.display = Browser.this.getDisplay();
                        newEvent.widget = Browser.this;
                        if (visible) {
                            int i = 0;
                            while (i < Browser.this.visibilityWindowListeners.length) {
                                newEvent.location = Browser.this.location;
                                newEvent.size = Browser.this.size;
                                Browser.this.visibilityWindowListeners[i].show(newEvent);
                                Browser.this.location = null;
                                Browser.this.size = null;
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < Browser.this.visibilityWindowListeners.length) {
                                Browser.this.visibilityWindowListeners[i].hide(newEvent);
                                ++i;
                            }
                        }
                        break;
                    }
                    case 108: {
                        Variant arg1 = event.arguments[0];
                        int nProgress = arg1.getType() != 3 ? 0 : arg1.getInt();
                        Variant arg2 = event.arguments[1];
                        int nProgressMax = arg2.getType() != 3 ? 0 : arg2.getInt();
                        ProgressEvent newEvent = new ProgressEvent(Browser.this);
                        newEvent.display = Browser.this.getDisplay();
                        newEvent.widget = Browser.this;
                        newEvent.current = nProgress;
                        newEvent.total = nProgressMax;
                        if (nProgress == -1) break;
                        int i = 0;
                        while (i < Browser.this.progressListeners.length) {
                            Browser.this.progressListeners[i].changed(newEvent);
                            ++i;
                        }
                        break;
                    }
                    case 102: {
                        Variant arg1 = event.arguments[0];
                        if (arg1.getType() != 8) break;
                        String text = arg1.getString();
                        StatusTextEvent newEvent = new StatusTextEvent(Browser.this);
                        newEvent.display = Browser.this.getDisplay();
                        newEvent.widget = Browser.this;
                        newEvent.text = text;
                        int i = 0;
                        while (i < Browser.this.statusTextListeners.length) {
                            Browser.this.statusTextListeners[i].changed(newEvent);
                            ++i;
                        }
                        break;
                    }
                    case 113: {
                        Variant arg1 = event.arguments[0];
                        if (arg1.getType() != 8) break;
                        String title = arg1.getString();
                        TitleEvent newEvent = new TitleEvent(Browser.this);
                        newEvent.display = Browser.this.getDisplay();
                        newEvent.widget = Browser.this;
                        newEvent.title = title;
                        int i = 0;
                        while (i < Browser.this.titleListeners.length) {
                            Browser.this.titleListeners[i].changed(newEvent);
                            ++i;
                        }
                        break;
                    }
                    case 263: {
                        WindowEvent newEvent = new WindowEvent(Browser.this);
                        newEvent.display = Browser.this.getDisplay();
                        newEvent.widget = Browser.this;
                        int i = 0;
                        while (i < Browser.this.closeWindowListeners.length) {
                            Browser.this.closeWindowListeners[i].close(newEvent);
                            ++i;
                        }
                        Variant cancel = event.arguments[1];
                        int pCancel = cancel.getByRef();
                        COM.MoveMemory(pCancel, new short[1], 2);
                        Browser.this.dispose();
                        break;
                    }
                    case 267: {
                        if (Browser.this.size == null) {
                            Browser.this.size = new Point(0, 0);
                        }
                        Variant arg1 = event.arguments[0];
                        Browser.this.size.y = arg1.getInt();
                        break;
                    }
                    case 264: {
                        if (Browser.this.location == null) {
                            Browser.this.location = new Point(0, 0);
                        }
                        Variant arg1 = event.arguments[0];
                        Browser.this.location.x = arg1.getInt();
                        break;
                    }
                    case 265: {
                        if (Browser.this.location == null) {
                            Browser.this.location = new Point(0, 0);
                        }
                        Variant arg1 = event.arguments[0];
                        Browser.this.location.y = arg1.getInt();
                        break;
                    }
                    case 266: {
                        if (Browser.this.size == null) {
                            Browser.this.size = new Point(0, 0);
                        }
                        Variant arg1 = event.arguments[0];
                        Browser.this.size.x = arg1.getInt();
                    }
                }
                Variant[] arguments = event.arguments;
                int i = 0;
                while (i < arguments.length) {
                    arguments[i].dispose();
                    ++i;
                }
            }
        };
        this.site.addEventListener(250, listener);
        this.site.addEventListener(105, listener);
        this.site.addEventListener(259, listener);
        this.site.addEventListener(252, listener);
        this.site.addEventListener(251, listener);
        this.site.addEventListener(254, listener);
        this.site.addEventListener(108, listener);
        this.site.addEventListener(102, listener);
        this.site.addEventListener(113, listener);
        this.site.addEventListener(263, listener);
        this.site.addEventListener(267, listener);
        this.site.addEventListener(264, listener);
        this.site.addEventListener(265, listener);
        this.site.addEventListener(266, listener);
        Variant variant = new Variant(true);
        this.auto.setProperty(552, variant);
        variant.dispose();
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = newCloseWindowListeners;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = listener;
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, this.locationListeners.length);
        this.locationListeners = newLocationListeners;
        this.locationListeners[this.locationListeners.length - 1] = listener;
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, this.progressListeners.length);
        this.progressListeners = newProgressListeners;
        this.progressListeners[this.progressListeners.length - 1] = listener;
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, this.statusTextListeners.length);
        this.statusTextListeners = newStatusTextListeners;
        this.statusTextListeners[this.statusTextListeners.length - 1] = listener;
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, this.titleListeners.length);
        this.titleListeners = newTitleListeners;
        this.titleListeners[this.titleListeners.length - 1] = listener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = listener;
    }

    public boolean back() {
        this.checkWidget();
        if (!this.back) {
            return false;
        }
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"GoBack"});
        Variant pVarResult = this.auto.invoke(rgdispid[0]);
        return pVarResult != null && pVarResult.getType() == 0;
    }

    protected void checkSubclass() {
        int index;
        String name = this.getClass().getName();
        if (!name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    public boolean forward() {
        this.checkWidget();
        if (!this.forward) {
            return false;
        }
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"GoForward"});
        Variant pVarResult = this.auto.invoke(rgdispid[0]);
        return pVarResult != null && pVarResult.getType() == 0;
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return this.back;
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return this.forward;
    }

    public String getUrl() {
        this.checkWidget();
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"LocationURL"});
        Variant pVarResult = this.auto.getProperty(rgdispid[0]);
        if (pVarResult == null || pVarResult.getType() != 8) {
            return "";
        }
        return pVarResult.getString();
    }

    public void refresh() {
        this.checkWidget();
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Refresh"});
        this.auto.invoke(rgdispid[0]);
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            if (listener == this.closeWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, index);
        System.arraycopy(this.closeWindowListeners, index + 1, newCloseWindowListeners, index, this.closeWindowListeners.length - index - 1);
        this.closeWindowListeners = newCloseWindowListeners;
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.locationListeners.length) {
            if (listener == this.locationListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, index);
        System.arraycopy(this.locationListeners, index + 1, newLocationListeners, index, this.locationListeners.length - index - 1);
        this.locationListeners = newLocationListeners;
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            if (listener == this.openWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.progressListeners.length) {
            if (listener == this.progressListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, index);
        System.arraycopy(this.progressListeners, index + 1, newProgressListeners, index, this.progressListeners.length - index - 1);
        this.progressListeners = newProgressListeners;
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            if (listener == this.statusTextListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, index);
        System.arraycopy(this.statusTextListeners, index + 1, newStatusTextListeners, index, this.statusTextListeners.length - index - 1);
        this.statusTextListeners = newStatusTextListeners;
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.titleListeners.length) {
            if (listener == this.titleListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, index);
        System.arraycopy(this.titleListeners, index + 1, newTitleListeners, index, this.titleListeners.length - index - 1);
        this.titleListeners = newTitleListeners;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            if (listener == this.visibilityWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, index);
        System.arraycopy(this.visibilityWindowListeners, index + 1, newVisibilityWindowListeners, index, this.visibilityWindowListeners.length - index - 1);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        this.html = html;
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Stop"});
        this.auto.invoke(rgdispid[0]);
        rgdispid = this.auto.getIDsOfNames(new String[]{"Navigate", "URL"});
        Variant[] rgvarg = new Variant[]{new Variant(ABOUT_BLANK)};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        Variant pVarResult = this.auto.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
        return pVarResult != null && pVarResult.getType() == 0;
    }

    public boolean setUrl(String url) {
        int[] rgdispidNamedArgs;
        Variant[] rgvarg;
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        this.html = null;
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Navigate", "URL"});
        Variant pVarResult = this.auto.invoke(rgdispid[0], rgvarg = new Variant[]{new Variant(url)}, rgdispidNamedArgs = new int[]{rgdispid[1]});
        return pVarResult != null && pVarResult.getType() == 0;
    }

    public void stop() {
        this.checkWidget();
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Stop"});
        this.auto.invoke(rgdispid[0]);
    }
}

