/*
 * Decompiled with CFR 0.152.
 */
package kenya;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kenya.errors.SourceCodeException;
import kenya.gui.editor.FileLoaderSaver;
import kenya.gui.editor.utils.EditingWindowUtilsFactory;
import kenya.gui.editor.utils.InterpreterLastPointReachedCatcher;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;
import mediator.stackMachine.IStackMachineInformationProvider;
import mediator.util.StreamHandler;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.IJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.types.ArrayTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class Kenya {
    public static final String VERSION = "4.1";
    public static final boolean DEBUG_OUTPUT = new Boolean(System.getProperty("KENYA_DEBUG", "false"));
    private static boolean exiting = false;
    static final List exitListeners = new ArrayList();
    private static final AbstractJob exitJob = new AbstractJob(){

        public void execute() {
            ArrayList exiters = new ArrayList(exitListeners);
            for (int idx = 0; idx < exiters.size(); ++idx) {
                AbstractJob exitingJob = (AbstractJob)exiters.get(idx);
                if (exitingJob == null) continue;
                exitingJob.execute();
            }
            JobDispatch.shutDownAllJobs();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    };
    private static final String license = IJavaCode.NEWLINE + "   Kenya" + IJavaCode.NEWLINE + "   Copyright (C) 2004 Tristan Allwood," + IJavaCode.NEWLINE + "                 2004 Matthew Sackman" + IJavaCode.NEWLINE + IJavaCode.NEWLINE + "   This program is free software; you can redistribute it and/or" + IJavaCode.NEWLINE + "   modify it under the terms of the GNU General Public License" + IJavaCode.NEWLINE + "   as published by the Free Software Foundation; either version 2" + IJavaCode.NEWLINE + "   of the License, or (at your option) any later version." + IJavaCode.NEWLINE + IJavaCode.NEWLINE + "   This program is distributed in the hope that it will be useful," + IJavaCode.NEWLINE + "   but WITHOUT ANY WARRANTY; without even the implied warranty of" + IJavaCode.NEWLINE + "   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the" + IJavaCode.NEWLINE + "   GNU General Public License for more details." + IJavaCode.NEWLINE + IJavaCode.NEWLINE + "   You should have received a copy of the GNU General Public License" + IJavaCode.NEWLINE + "   along with this program; if not, write to the Free Software" + IJavaCode.NEWLINE + "   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA." + IJavaCode.NEWLINE + IJavaCode.NEWLINE + "   The authors can be contacted by email at toa02@doc.ic.ac.uk" + IJavaCode.NEWLINE + "                                             ms02@doc.ic.ac.uk" + IJavaCode.NEWLINE;
    private static final String help = IJavaCode.NEWLINE + "Kenya: \tA teaching language designed by Tristan Allwood and Matthew Sackman (c) 2004." + IJavaCode.NEWLINE + "        Based upon work previously done by Robert Chatley and others, in 2001" + IJavaCode.NEWLINE + IJavaCode.NEWLINE + "Usage:" + IJavaCode.NEWLINE + "        kenya [options] kenyaFile [arguments]" + IJavaCode.NEWLINE + IJavaCode.NEWLINE + "If no options are specified, then the Kenya GUI will be used." + IJavaCode.NEWLINE + IJavaCode.NEWLINE + "Any options will cause Kenya to run on the command line, valid options are:" + IJavaCode.NEWLINE + "-s|--translate         Translate the Kenya program to Java if it is valid" + IJavaCode.NEWLINE + "-c|--execute <path>    Execute the Kenya program, using Path as a place to save " + IJavaCode.NEWLINE + "                           the .java and .class file" + IJavaCode.NEWLINE + "-i|--interpret         Interpret the Kenya program" + IJavaCode.NEWLINE + "-h|--help              Show this help message." + IJavaCode.NEWLINE + "-d|--debug             Print out debugging information." + IJavaCode.NEWLINE + "-p|--parse             Stop after the parsing stage." + IJavaCode.NEWLINE + "-f|--typefind          Stop after the type-finding stage." + IJavaCode.NEWLINE + "-e|--definitionfind    Stop after the definition finding stage." + IJavaCode.NEWLINE + "-l|--builtinload       Stop after the built-in method loading stage." + IJavaCode.NEWLINE + "-t|--typecheck         Stop after the type-checking stage." + IJavaCode.NEWLINE + "-y|--structcheck       Stop after the variable-value checking stage." + IJavaCode.NEWLINE + "-n|--license           Show the licensing information for Kenya." + IJavaCode.NEWLINE;

    public static void main(String[] args) {
        int opt;
        Getopt op = new Getopt("Kenya", args, "hdpfeltyscin", new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("debug", 0, null, 100), new LongOpt("parse", 0, null, 112), new LongOpt("typefind", 0, null, 102), new LongOpt("definitionfind", 0, null, 101), new LongOpt("builtinload", 0, null, 108), new LongOpt("typecheck", 0, null, 116), new LongOpt("structcheck", 0, null, 121), new LongOpt("translate", 0, null, 115), new LongOpt("execute", 1, null, 99), new LongOpt("interpret", 0, null, 105), new LongOpt("license", 0, null, 110)});
        int debugOptions = 0;
        boolean translate = false;
        boolean execute = false;
        String path = null;
        boolean interpret = false;
        block14: while ((opt = op.getopt()) != -1) {
            switch (opt) {
                case 104: {
                    Kenya.printHelp();
                    System.exit(0);
                    continue block14;
                }
                case 110: {
                    Kenya.printLicense();
                    System.exit(0);
                    continue block14;
                }
                case 100: {
                    debugOptions |= 1;
                    continue block14;
                }
                case 112: {
                    debugOptions |= 2;
                    continue block14;
                }
                case 102: {
                    debugOptions |= 4;
                    continue block14;
                }
                case 101: {
                    debugOptions |= 8;
                    continue block14;
                }
                case 108: {
                    debugOptions |= 0x10;
                    continue block14;
                }
                case 116: {
                    debugOptions |= 0x20;
                    continue block14;
                }
                case 121: {
                    debugOptions |= 0x40;
                    continue block14;
                }
                case 115: {
                    translate = true;
                    continue block14;
                }
                case 99: {
                    execute = true;
                    path = op.getOptarg();
                    continue block14;
                }
                case 105: {
                    interpret = true;
                    continue block14;
                }
            }
            Kenya.printHelp();
            System.exit(1);
        }
        int argIndex = op.getOptind();
        if (argIndex < args.length) {
            if (!(debugOptions != 0 || translate || execute || interpret)) {
                for (int idx = argIndex; idx < args.length; ++idx) {
                    String fileName = args[idx];
                    FileLoaderSaver fls = new FileLoaderSaver();
                    fls.setPath(fileName);
                    EditingWindowUtilsFactory.createAndOpenEditorWindow(fls);
                }
            } else {
                String[] argsLeft = new String[args.length - argIndex];
                System.arraycopy(args, argIndex, argsLeft, 0, argsLeft.length);
                Kenya.doCommandLine(argsLeft, debugOptions, translate, execute, interpret, path);
            }
        } else if (!(debugOptions != 0 || translate || execute || interpret)) {
            EditingWindowUtilsFactory.createAndOpenEditorWindow();
        } else {
            Kenya.printError("Command Line Kenya needs files to operate upon.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCommandLine(String[] files, int dbg, boolean translate, boolean execute, boolean interpret, String filePath) {
        block19: {
            StackMachine sm = new StackMachine();
            try {
                FileReader fis = new FileReader(files[0]);
                ICheckedCode icc = Mediator.check(fis, dbg, System.out);
                if (icc.isErroredCode()) {
                    Iterator it = icc.getErrors().iterator();
                    while (it.hasNext()) {
                        SourceCodeException sce = (SourceCodeException)it.next();
                        System.err.println(sce.getMessage());
                    }
                    System.out.println(files[0] + ": INVALID CODE.");
                    break block19;
                }
                System.out.println(files[0] + ": VALID CODE.");
                if (interpret) {
                    IStackMachineInformationProvider ismp = icc.getBaseStackMachine();
                    InterpreterLastPointReachedCatcher ilprc = new InterpreterLastPointReachedCatcher(sm);
                    sm.addPositionReachedListener(ilprc);
                    sm.setStepMode(false);
                    try {
                        ClosureScope scope = new ClosureScope();
                        ClosureMiscHelper.executeClosureInScope(scope, ismp.getPreInitClosure(), sm);
                        IType[] array = new IType[files.length - 1];
                        for (int idx = 1; idx < files.length; ++idx) {
                            array[idx - 1] = StringTypeFactory.createStringType(files[idx]);
                        }
                        sm.push(ArrayTypeFactory.createArrayType(array));
                        sm.invokeMethod(ismp.getEntryPointClass(), ismp.getEntryPoint());
                        break block19;
                    }
                    catch (Throwable t) {
                        sm.getErr().println(t + " at " + ilprc.getLastPointData());
                        break block19;
                    }
                    finally {
                        Kenya.exit();
                    }
                }
                if (translate) {
                    String s;
                    BufferedReader r = new BufferedReader(icc.translate().getPlaceHeldCode());
                    while ((s = r.readLine()) != null) {
                        System.out.println(s);
                    }
                } else if (execute) {
                    boolean res;
                    long v = 0L;
                    String s = "_Command";
                    IJavaCode ijc = icc.translate();
                    while (!ijc.isValidClassName(s + v)) {
                        ++v;
                    }
                    String[] args = new String[files.length - 1];
                    System.arraycopy(files, 1, args, 0, args.length);
                    final PipedOutputStream stdInPOS = new PipedOutputStream();
                    PipedInputStream stdIn = new PipedInputStream(stdInPOS);
                    BufferedWriter stdInWriter = new BufferedWriter(new OutputStreamWriter(stdInPOS));
                    BufferedWriter stdOutWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    BufferedWriter stdErrWriter = new BufferedWriter(new OutputStreamWriter(System.err));
                    BufferedReader stdInReader = new BufferedReader(new InputStreamReader(stdIn));
                    final StreamHandler sh = new StreamHandler(new BufferedReader(new InputStreamReader(System.in)), stdInWriter);
                    JobDispatch.enqueueJob(sh);
                    JobDispatch.enqueueJob(new AbstractJob(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute() {
                            try {
                                StreamHandler streamHandler = sh;
                                synchronized (streamHandler) {
                                    while (!sh.isFinished()) {
                                        sh.wait();
                                    }
                                }
                                if (DEBUG_OUTPUT) {
                                    System.out.println("stream handler B finished");
                                }
                                stdInPOS.close();
                                if (DEBUG_OUTPUT) {
                                    System.out.println("stream handler BB finished");
                                }
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                    });
                    if (DEBUG_OUTPUT) {
                        System.out.println("about to execute");
                    }
                    if (!(res = icc.translate().execute(filePath, s + v, stdInReader, stdInWriter, stdOutWriter, stdErrWriter, args)) && DEBUG_OUTPUT) {
                        System.err.println("Translate & Execute failed");
                    }
                    System.in.close();
                    System.out.flush();
                    System.err.flush();
                    Kenya.exit();
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("File Not Found: " + files[0]);
            }
            catch (IOException ioe) {
                System.err.println("IOException on: " + files[0]);
            }
        }
        Kenya.exit();
    }

    public static void printError(String message) {
        System.err.println("Kenya:  " + message);
        System.err.println(help);
        System.exit(1);
    }

    public static void printHelp() {
        System.out.println(help);
    }

    public static void printLicense() {
        System.out.println(license);
    }

    public static synchronized void exit() {
        if (!exiting) {
            exiting = true;
            JobDispatch.enqueueJob(exitJob);
        }
    }

    public static synchronized boolean isExiting() {
        return exiting;
    }

    public static synchronized void addExitListener(IJob listener) {
        if (listener == null) {
            System.err.println("Attempt made to add a null exit listener.");
            throw new NullPointerException();
        }
        exitListeners.add(listener);
    }

    public static synchronized void removeExitListener(AbstractJob listener) {
        exitListeners.remove(listener);
    }
}

