/*
 * Decompiled with CFR 0.152.
 */
package kenya.builtIns;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import kenya.builtIns.IBuiltInMethodFactory;

public class BuiltInMethodsLoader {
    private static Set builtInMethods = null;
    private static final String builtInMethodsPackage = (class$kenya$builtIns$BuiltInMethodsLoader == null ? (class$kenya$builtIns$BuiltInMethodsLoader = BuiltInMethodsLoader.class$("kenya.builtIns.BuiltInMethodsLoader")) : class$kenya$builtIns$BuiltInMethodsLoader).getPackage().getName() + ".builtInMethods";
    private static String builtInMethodsLocation;
    private static final String methodListFileName = "builtInMethodList";
    static /* synthetic */ Class class$kenya$builtIns$BuiltInMethodsLoader;

    public static Set getBuiltInMethods() {
        if (builtInMethods == null) {
            builtInMethods = BuiltInMethodsLoader.loadBuiltInMethods();
        }
        return builtInMethods;
    }

    private static synchronized Set loadBuiltInMethods() {
        BuiltInMethodsLoader.findMethodsLocation();
        String listLocation = builtInMethodsLocation + methodListFileName;
        URL listUrl = ClassLoader.getSystemClassLoader().getResource(listLocation);
        HashSet builtInMethods = new HashSet();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(listUrl.openStream()));
            while (in.ready()) {
                IBuiltInMethodFactory bim;
                String line = in.readLine();
                if (BuiltInMethodsLoader.isComment(line) || (bim = BuiltInMethodsLoader.loadBuiltInMethod(line)) == null) continue;
                builtInMethods.addAll(bim.buildMethods());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found :" + listUrl.getFile() + ": " + e.getMessage());
            e.printStackTrace();
            return builtInMethods;
        }
        catch (IOException e) {
            System.err.println("IOException when reading " + listUrl.getFile() + ": " + e.getMessage());
            e.printStackTrace();
            return builtInMethods;
        }
        return builtInMethods;
    }

    private static IBuiltInMethodFactory loadBuiltInMethod(String name) {
        try {
            Class<?> loadedClass = Class.forName(builtInMethodsPackage + "." + name, true, (class$kenya$builtIns$BuiltInMethodsLoader == null ? (class$kenya$builtIns$BuiltInMethodsLoader = BuiltInMethodsLoader.class$("kenya.builtIns.BuiltInMethodsLoader")) : class$kenya$builtIns$BuiltInMethodsLoader).getClassLoader());
            Class<?>[] interfaces = loadedClass.getInterfaces();
            boolean found = false;
            for (int idx = 0; idx < interfaces.length && !found; ++idx) {
                if (!interfaces[idx].getName().equals(IBuiltInMethodFactory.LOCATION)) continue;
                found = true;
            }
            if (!found) {
                return null;
            }
            IBuiltInMethodFactory m = (IBuiltInMethodFactory)loadedClass.newInstance();
            return m;
        }
        catch (Exception e) {
            System.err.println("Unable to load class '" + name + "': " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static void findMethodsLocation() {
        String packageName = (class$kenya$builtIns$BuiltInMethodsLoader == null ? (class$kenya$builtIns$BuiltInMethodsLoader = BuiltInMethodsLoader.class$("kenya.builtIns.BuiltInMethodsLoader")) : class$kenya$builtIns$BuiltInMethodsLoader).getPackage().getName();
        if (!(packageName = packageName.replace('.', '/')).endsWith("/")) {
            packageName = packageName + "/";
        }
        builtInMethodsLocation = packageName + "builtInMethods/";
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.length() == 0;
    }

    public static void main(String[] args) {
        Set methods = BuiltInMethodsLoader.getBuiltInMethods();
        System.out.println("I got " + methods.size() + " methods.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

