/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kenya.gui.editor.DefaultSeaDrawer;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.ICustomPaintListener;
import kenya.gui.editor.ISeaDrawer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractHighlighter
implements ICustomPaintListener {
    private final Color seaColor;
    private final Color backgroundColor;
    private final EditingWindow window;
    private final Set rows = new HashSet();
    private static final ISeaDrawer seaDrawer = new DefaultSeaDrawer();
    private final Set highlights = new HashSet();

    protected AbstractHighlighter(EditingWindow window, Color seaColor, Color background) {
        this.window = window;
        this.seaColor = seaColor;
        this.backgroundColor = background;
    }

    public synchronized void addHighlight(int offset, int length, int lineNumber) {
        this.highlights.add(new Point(offset, length));
        this.rows.add(new Integer(lineNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (!this.window.isVisible()) {
            return;
        }
        StyledText text = this.window.getKenyaTextWidget();
        HashSet highlightsCopy = null;
        AbstractHighlighter abstractHighlighter = this;
        synchronized (abstractHighlighter) {
            highlightsCopy = new HashSet(this.highlights);
        }
        if (highlightsCopy != null) {
            Iterator it = highlightsCopy.iterator();
            while (it.hasNext()) {
                int baseline;
                Point point = (Point)it.next();
                int startChar = point.x;
                if (startChar >= text.getCharCount()) {
                    startChar = text.getCharCount() - 1;
                }
                Point start = text.getLocationAtOffset(startChar);
                int endChar = point.x + point.y;
                if (endChar >= text.getCharCount()) {
                    endChar = text.getCharCount() - 1;
                }
                Point end = text.getLocationAtOffset(endChar);
                start.y = baseline = start.y + text.getLineHeight() - 1;
                end.y = baseline;
                if (e.x >= end.x || e.x + e.width < start.x || e.y >= baseline || e.y + e.height < baseline) continue;
                seaDrawer.drawLine(gc, start.x, baseline, end.x, baseline, this.seaColor);
            }
        }
    }

    public synchronized void clearHighlights() {
        this.highlights.clear();
        this.rows.clear();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized boolean isHighlightOnLine(int line) {
        return this.rows.contains(new Integer(line));
    }
}

