/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kenya.gui.editor.AbstractHighlighter;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.ErrorHighlighter;
import kenya.gui.editor.IHighlightingManager;
import kenya.gui.editor.LinkedLocationHighlighter;
import kenya.gui.editor.WarningHighlighter;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DefaultHighlightingManager
implements IHighlightingManager {
    public static final Color WHITE = new Color((Device)Display.getDefault(), 255, 244, 212);
    private final EditingWindow window;
    private final ErrorHighlighter errorH;
    private final WarningHighlighter warningH;
    private final LinkedLocationHighlighter linkedLocationH;
    private final Map pointsToErrors = new HashMap();
    private final Map pointsToWarnings = new HashMap();

    public DefaultHighlightingManager(EditingWindow window, ErrorHighlighter error, WarningHighlighter warning, LinkedLocationHighlighter linkedLocation) {
        this.window = window;
        this.errorH = error;
        this.warningH = warning;
        this.linkedLocationH = linkedLocation;
    }

    public ErrorHighlighter getErrorHighlighter() {
        return this.errorH;
    }

    public WarningHighlighter getWarningHighlighter() {
        return this.warningH;
    }

    public LinkedLocationHighlighter getLinkedLocationHighlighter() {
        return this.linkedLocationH;
    }

    public void paint(PaintEvent e) {
        this.errorH.paintControl(e);
        this.warningH.paintControl(e);
        this.linkedLocationH.paintControl(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DefaultHighlightingManager defaultHighlightingManager = this;
        synchronized (defaultHighlightingManager) {
            this.errorH.clearHighlights();
            this.warningH.clearHighlights();
            this.linkedLocationH.clearHighlights();
            this.pointsToErrors.clear();
            this.pointsToWarnings.clear();
        }
        this.window.selectInKenyaErrorTable(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceCodeError(final ISourceCodeError error) {
        if (!this.window.isVisible()) {
            return;
        }
        StyledText text = this.window.getKenyaTextWidget();
        if (Thread.currentThread().equals(text.getDisplay().getThread())) {
            DefaultHighlightingManager defaultHighlightingManager = this;
            synchronized (defaultHighlightingManager) {
                ISourceCodeLocation location = error.getLocation();
                int row = location.getLineNumber() - 1;
                int column = location.getColumnNumber() - 1;
                int length = location.getTokenLength();
                if (!this.window.isVisible() || text.isDisposed()) {
                    return;
                }
                int myRow = row;
                if (myRow < text.getContent().getLineCount() && myRow >= 0) {
                    int offset = text.getOffsetAtLine(myRow) + column;
                    this.errorH.addHighlight(offset, length, row);
                    Point point = new Point(offset, offset + length);
                    this.registerError(point, error);
                }
            }
        } else {
            text.getDisplay().syncExec(new Runnable(){

                public void run() {
                    DefaultHighlightingManager.this.addSourceCodeError(error);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceCodeWarning(final ISourceCodeInformation warning) {
        if (!this.window.isVisible()) {
            return;
        }
        StyledText text = this.window.getKenyaTextWidget();
        if (Thread.currentThread().equals(text.getDisplay().getThread())) {
            DefaultHighlightingManager defaultHighlightingManager = this;
            synchronized (defaultHighlightingManager) {
                ISourceCodeLocation location = warning.getLocation();
                int row = location.getLineNumber() - 1;
                int column = location.getColumnNumber() - 1;
                int length = location.getTokenLength();
                if (!this.window.isVisible() || text.isDisposed()) {
                    return;
                }
                int myRow = row;
                if (myRow >= text.getLineCount()) {
                    myRow = text.getLineCount() - 1;
                }
                int offset = text.getOffsetAtLine(myRow) + column;
                this.warningH.addHighlight(offset, length, row);
                Point point = new Point(offset, offset + length);
                this.registerWarning(point, warning);
            }
        } else {
            text.getDisplay().syncExec(new Runnable(){

                public void run() {
                    DefaultHighlightingManager.this.addSourceCodeWarning(warning);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlight(final ISourceCodeLocation location, final AbstractHighlighter highlighter) {
        if (!this.window.isVisible()) {
            return;
        }
        StyledText text = this.window.getKenyaTextWidget();
        if (Thread.currentThread().equals(text.getDisplay().getThread())) {
            DefaultHighlightingManager defaultHighlightingManager = this;
            synchronized (defaultHighlightingManager) {
                int row = location.getLineNumber() - 1;
                int column = location.getColumnNumber() - 1;
                int length = location.getTokenLength();
                if (!this.window.isVisible() || text.isDisposed()) {
                    return;
                }
                int myRow = row;
                if (myRow >= text.getLineCount()) {
                    myRow = text.getLineCount() - 1;
                }
                int offset = text.getOffsetAtLine(myRow) + column;
                highlighter.addHighlight(offset, length, myRow);
            }
        } else {
            text.getDisplay().syncExec(new Runnable(){

                public void run() {
                    DefaultHighlightingManager.this.addHighlight(location, highlighter);
                }
            });
        }
    }

    public MouseListener createKenyaMouseListener(final EditingWindow window) {
        MouseListener mouseListener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    int offset = window.getKenyaTextWidget().getCaretOffset();
                    DefaultHighlightingManager.this.showLinkedHighlights(offset);
                }
            }
        };
        return mouseListener;
    }

    public void showLinkedHighlights(int offset) {
        ISourceCodeInformation error = this.searchForErrorOrWarning(offset);
        if (error != null) {
            this.linkedLocationH.clearHighlights();
            ISourceCodeLocation[] locations = error.getLinkedInformation();
            if (locations != null) {
                for (int idx = 0; idx < locations.length; ++idx) {
                    this.addHighlight(locations[idx], this.linkedLocationH);
                }
            }
            this.window.selectInKenyaErrorTable(error);
            this.window.safeRedraw();
        }
    }

    private synchronized void registerError(Point location, ISourceCodeError error) {
        this.pointsToErrors.put(location, error);
    }

    private synchronized void registerWarning(Point location, ISourceCodeInformation warning) {
        this.pointsToWarnings.put(location, warning);
    }

    private synchronized ISourceCodeInformation searchForErrorOrWarning(int offset) {
        Point point;
        Iterator it = this.pointsToErrors.keySet().iterator();
        while (it.hasNext()) {
            point = (Point)it.next();
            if (point.x >= offset || point.y < offset) continue;
            return (ISourceCodeInformation)this.pointsToErrors.get(point);
        }
        it = this.pointsToWarnings.keySet().iterator();
        while (it.hasNext()) {
            point = (Point)it.next();
            if (point.x >= offset || point.y < offset) continue;
            return (ISourceCodeInformation)this.pointsToWarnings.get(point);
        }
        return null;
    }

    public LineBackgroundListener createKenyaLineBackgroundListener(final EditingWindow window) {
        window.getKenyaLineNumberWidget().setBackground(WHITE);
        return new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent event) {
                int lineNumber = window.getKenyaLineNumberWidget().getLineAtOffset(event.lineOffset);
                event.lineBackground = DefaultHighlightingManager.this.errorH.isHighlightOnLine(lineNumber) ? DefaultHighlightingManager.this.errorH.getBackgroundColor() : (DefaultHighlightingManager.this.warningH.isHighlightOnLine(lineNumber) ? DefaultHighlightingManager.this.warningH.getBackgroundColor() : (DefaultHighlightingManager.this.linkedLocationH.isHighlightOnLine(lineNumber) ? DefaultHighlightingManager.this.linkedLocationH.getBackgroundColor() : WHITE));
            }
        };
    }
}

