/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kenya.Kenya;
import kenya.gui.editor.DefaultHighlightingManager;
import kenya.gui.editor.FileLoaderSaver;
import kenya.gui.editor.HumanErrorLabelContentProvider;
import kenya.gui.editor.IHighlightingManager;
import kenya.gui.editor.JavacErrorLabelContentProvider;
import kenya.gui.editor.KenyaErrorContentProvider;
import kenya.gui.editor.icons.ButtonManager;
import kenya.gui.editor.icons.IButtonManager;
import kenya.gui.editor.indenter.IndentationStrategy;
import kenya.gui.editor.menuActions.AboutAction;
import kenya.gui.editor.menuActions.CloseAction;
import kenya.gui.editor.menuActions.EditorBigFontAction;
import kenya.gui.editor.menuActions.EditorFixedFontAction;
import kenya.gui.editor.menuActions.EditorHugeFontAction;
import kenya.gui.editor.menuActions.EditorMediumFontAction;
import kenya.gui.editor.menuActions.EditorProportionalFontAction;
import kenya.gui.editor.menuActions.EditorSmallFontAction;
import kenya.gui.editor.menuActions.ExitAction;
import kenya.gui.editor.menuActions.FormatAction;
import kenya.gui.editor.menuActions.IOBigFontAction;
import kenya.gui.editor.menuActions.IOFixedFontAction;
import kenya.gui.editor.menuActions.IOHugeFontAction;
import kenya.gui.editor.menuActions.IOMediumFontAction;
import kenya.gui.editor.menuActions.IOProportionalFontAction;
import kenya.gui.editor.menuActions.IOSmallFontAction;
import kenya.gui.editor.menuActions.JavaSaveAction;
import kenya.gui.editor.menuActions.JavaSaveAsAction;
import kenya.gui.editor.menuActions.KenyaSaveAction;
import kenya.gui.editor.menuActions.KenyaSaveAsAction;
import kenya.gui.editor.menuActions.NewAction;
import kenya.gui.editor.menuActions.OpenAction;
import kenya.gui.editor.menuActions.OpenInNewAction;
import kenya.gui.editor.menuActions.SavePromptAction;
import kenya.gui.editor.menuActions.SwitchToInterpreter;
import kenya.gui.editor.menuActions.SwitchToJava;
import kenya.gui.editor.menuActions.SwitchToKenya;
import kenya.gui.editor.menuActions.UniqueCheckedManager;
import kenya.gui.editor.utils.CarrotPainter;
import kenya.gui.editor.utils.EditorControlListener;
import kenya.gui.editor.utils.InterpreterContinueButtonSelectionListener;
import kenya.gui.editor.utils.InterpreterInspectorContentProvider;
import kenya.gui.editor.utils.InterpreterInspectorLabelProvider;
import kenya.gui.editor.utils.InterpreterInspectorListContentProvider;
import kenya.gui.editor.utils.InterpreterInspectorListLabelProvider;
import kenya.gui.editor.utils.InterpreterInterpretSelectionListener;
import kenya.gui.editor.utils.InterpreterMouseListener;
import kenya.gui.editor.utils.InterpreterPaintListener;
import kenya.gui.editor.utils.InterpreterStepModeButtonSelectionListener;
import kenya.gui.editor.utils.JavaExecuteButtonSelectionListener;
import kenya.gui.editor.utils.JavaLineStyler;
import kenya.gui.editor.utils.JavaPaintListener;
import kenya.gui.editor.utils.JavaTerminateButtonSelectionListener;
import kenya.gui.editor.utils.KenyaKeyListener;
import kenya.gui.editor.utils.KenyaLineStyler;
import kenya.gui.editor.utils.KenyaPaintListener;
import kenya.gui.editor.utils.KenyaTableSelectionChangedListener;
import kenya.gui.editor.utils.KenyaTextChangedListener;
import kenya.gui.editor.utils.NumbersSelectionListener;
import kenya.gui.editor.utils.TabSelectionAdapter;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;

public class EditingWindow
extends ApplicationWindow {
    public static final int KENYATABINDEX = 0;
    public static final int JAVATABINDEX = 1;
    public static final int INTERPRETERTABINDEX = 2;
    private final Runnable runGetKenyaCaretOffset = new Runnable(){

        public void run() {
            EditingWindow.this.getKenyaCaretOffset();
        }
    };
    private final Runnable runLoadFromKenyaFile = new Runnable(){

        public void run() {
            EditingWindow.this.loadFromKenyaFile();
        }
    };
    private final Runnable runSafeRedraw = new Runnable(){

        public void run() {
            EditingWindow.this.safeRedraw();
        }
    };
    private final Runnable runIsVisible = new Runnable(){

        public void run() {
            EditingWindow.this.isVisible();
        }
    };
    private final Runnable runGetKenyaText = new Runnable(){

        public void run() {
            EditingWindow.this.getKenyaText();
        }
    };
    private final Runnable runRebuildInterpreterNumbers = new Runnable(){

        public void run() {
            EditingWindow.this.rebuildInterpreterNumbers();
        }
    };
    private final Runnable runRebuildJavaNumbers = new Runnable(){

        public void run() {
            EditingWindow.this.rebuildJavaNumbers();
        }
    };
    private final Runnable runCloseWindow = new Runnable(){

        public void run() {
            EditingWindow.this.closeWindow();
        }
    };
    private final Runnable runRebuildKenyaNumbers = new Runnable(){

        public void run() {
            EditingWindow.this.rebuildKenyaNumbers();
        }
    };
    private final Object secondaryLock = new Object();
    private final StringBuffer kenyaNumbersBuffer = new StringBuffer();
    private int kenyaNumbersLineCount = -1;
    private final StringBuffer javaNumbersBuffer = new StringBuffer();
    private int javaNumbersLineCount = -1;
    private final StringBuffer interpreterNumbersBuffer = new StringBuffer();
    private int interpreterNumbersLineCount = -1;
    private volatile IButtonManager buttonManager = null;
    private volatile TabFolder topTabs = null;
    private volatile SelectionListener tabSelectionListener = null;
    private volatile StyledText interpreterText = null;
    private volatile StyledText interpreterNumbers = null;
    private volatile StyledText javaText = null;
    private volatile StyledText javaNumbers = null;
    private volatile StyledText kenyaText = null;
    private volatile StyledText kenyaNumbers = null;
    private volatile TableViewer kenyaHumanErrorTable = null;
    private volatile TableViewer kenyaJavacErrorTable = null;
    private final KenyaErrorContentProvider kenyaTableContents = new KenyaErrorContentProvider();
    private volatile Button javaExecuteButton = null;
    private volatile Button javaEOFButton = null;
    private volatile Button javaTerminateButton = null;
    private volatile Text javaStdInText = null;
    private volatile StyledText javaStdOutText = null;
    private volatile Text javaArgsText = null;
    private volatile Label javaArgsLabel = null;
    private String[] javaArgsResult = null;
    private volatile IJavaCode javaCode = null;
    private final String javaDefaultClassName;
    private volatile String javaClassName = null;
    private volatile boolean javaRunning = false;
    private volatile String kenyaWidgetText = "";
    private volatile boolean isVisible = false;
    private volatile int caretOffset = 0;
    private final Date lastKeyEvent = new Date();
    private volatile boolean reparse = false;
    private volatile IAction javaSaveAction = null;
    private volatile IAction javaSaveAsAction = null;
    private volatile FileLoaderSaver javaFileLoaderSaver = null;
    private volatile FileLoaderSaver kenyaFileLoaderSaver = null;
    private volatile KenyaLineStyler kenyaLineStyler = null;
    private volatile JavaLineStyler javaLineStyler = null;
    private volatile IHighlightingManager highlights = null;
    private volatile boolean modified = false;
    private final IndentationStrategy is = new IndentationStrategy();
    private volatile CarrotPainter carrotPainter = null;
    private volatile IStackMachineInformationProvider baseStackMachine = null;
    private volatile StackMachine stackMachine = null;
    private volatile Button interpreterInterpretButton = null;
    private volatile StyledText interpreterStdOutText = null;
    private volatile Text interpreterStdInText = null;
    private volatile Button interpreterTrackButton = null;
    private volatile Button interpreterEOFButton = null;
    private volatile Button interpreterTerminateButton = null;
    private volatile Button interpreterStepModeButton = null;
    private volatile boolean interpreterStepMode = false;
    private volatile boolean interpreterTrackMode = false;
    private volatile Button interpreterContinueButton = null;
    private volatile TreeViewer interpreterInspector = null;
    private volatile ListViewer interpreterList = null;
    private volatile Text interpreterArgsText = null;
    private volatile Label interpreterArgsLabel = null;
    private String[] interpreterArgsResult = null;
    private volatile String lastDir = null;

    public EditingWindow(String dcn) {
        super(null);
        this.addStatusLine();
        this.addMenuBar();
        this.javaDefaultClassName = dcn;
    }

    protected synchronized Control createContents(Composite parent) {
        this.buttonManager = new ButtonManager(this);
        this.topTabs = new TabFolder(parent, 0);
        TabItem kenyaTab = new TabItem(this.topTabs, 0);
        kenyaTab.setText("&Kenya");
        TabItem javaTab = new TabItem(this.topTabs, 0);
        javaTab.setText("&Java");
        TabItem interpreterTab = new TabItem(this.topTabs, 0);
        interpreterTab.setText("&Debugger");
        SashForm kenyaTopControl = new SashForm((Composite)this.topTabs, 2560);
        kenyaTab.setControl((Control)kenyaTopControl);
        this.buildKenya(kenyaTopControl);
        SashForm javaTopControl = new SashForm((Composite)this.topTabs, 2560);
        javaTab.setControl((Control)javaTopControl);
        this.buildJava(javaTopControl);
        SashForm interpreterTopControl = new SashForm((Composite)this.topTabs, 2560);
        interpreterTab.setControl((Control)interpreterTopControl);
        this.buildInterpreter(interpreterTopControl);
        this.tabSelectionListener = new TabSelectionAdapter(this);
        this.topTabs.addSelectionListener(this.tabSelectionListener);
        FontData fontdata = this.kenyaText.getFont().getFontData()[0];
        fontdata.setName("courier");
        fontdata.setHeight(12);
        Font ioFont = new Font((Device)this.topTabs.getDisplay(), fontdata);
        this.setIOFonts(ioFont);
        fontdata = this.kenyaText.getFont().getFontData()[0];
        fontdata.setName("arial");
        fontdata.setHeight(12);
        Font editorFont = new Font((Device)this.topTabs.getDisplay(), fontdata);
        this.setEditorFonts(editorFont);
        parent.setSize(600, 800);
        return this.topTabs;
    }

    protected void handleShellCloseEvent() {
        this.closeWindow();
    }

    private void buildKenya(SashForm kenyaTopControl) {
        kenyaTopControl.setLayout((Layout)new FillLayout());
        this.setKenyaLineStyler(new KenyaLineStyler());
        SashForm editorSash = new SashForm((Composite)kenyaTopControl, 256);
        this.kenyaNumbers = new StyledText((Composite)editorSash, 524296);
        this.kenyaNumbers.setEditable(false);
        this.kenyaNumbers.setDoubleClickEnabled(false);
        this.kenyaNumbers.setEnabled(false);
        this.kenyaNumbers.addSelectionListener((SelectionListener)new NumbersSelectionListener(this.kenyaNumbers));
        this.kenyaText = new StyledText((Composite)editorSash, 768);
        this.kenyaText.addVerifyKeyListener((VerifyKeyListener)new KenyaKeyListener(this));
        this.kenyaText.addPaintListener((PaintListener)new KenyaPaintListener(this));
        this.kenyaText.addLineStyleListener((LineStyleListener)this.kenyaLineStyler);
        this.kenyaText.getContent().addTextChangeListener((TextChangeListener)new KenyaTextChangedListener(this));
        FileLoaderSaver fls = this.getKenyaFile();
        if (fls == null) {
            this.kenyaText.setText("");
            this.getShell().setText("Kenya IDE");
            this.setModified(false);
        } else {
            this.loadFromKenyaFile();
        }
        this.rebuildKenyaNumbers();
        editorSash.setWeights(new int[]{1, 18});
        if (this.highlights != null) {
            this.kenyaText.addMouseListener(this.highlights.createKenyaMouseListener(this));
            this.kenyaNumbers.addLineBackgroundListener(this.highlights.createKenyaLineBackgroundListener(this));
        }
        TabFolder kenyaTabs = new TabFolder((Composite)kenyaTopControl, 0);
        TabItem humanErrorsTab = new TabItem(kenyaTabs, 0);
        humanErrorsTab.setText("Kenya errors");
        TabItem javacErrorsTab = new TabItem(kenyaTabs, 0);
        javacErrorsTab.setText("Java errors");
        this.kenyaHumanErrorTable = new TableViewer((Composite)kenyaTabs, 68356);
        this.kenyaHumanErrorTable.setUseHashlookup(true);
        this.kenyaHumanErrorTable.setContentProvider((IContentProvider)this.kenyaTableContents);
        this.kenyaHumanErrorTable.setLabelProvider((IBaseLabelProvider)new HumanErrorLabelContentProvider(this.buttonManager, this.kenyaText.getLineDelimiter()));
        KenyaTableSelectionChangedListener tableSelectionChanged = new KenyaTableSelectionChangedListener(this);
        this.kenyaHumanErrorTable.addSelectionChangedListener((ISelectionChangedListener)tableSelectionChanged);
        this.kenyaHumanErrorTable.getTable().setLinesVisible(false);
        this.kenyaHumanErrorTable.getTable().setHeaderVisible(false);
        humanErrorsTab.setControl(this.kenyaHumanErrorTable.getControl());
        this.kenyaJavacErrorTable = new TableViewer((Composite)kenyaTabs, 68356);
        this.kenyaJavacErrorTable.setUseHashlookup(true);
        this.kenyaJavacErrorTable.setContentProvider((IContentProvider)this.kenyaTableContents);
        this.kenyaJavacErrorTable.setLabelProvider((IBaseLabelProvider)new JavacErrorLabelContentProvider(this.buttonManager, this.kenyaText.getLineDelimiter()));
        this.kenyaJavacErrorTable.addSelectionChangedListener((ISelectionChangedListener)tableSelectionChanged);
        this.kenyaJavacErrorTable.getTable().setLinesVisible(false);
        this.kenyaJavacErrorTable.getTable().setHeaderVisible(false);
        javacErrorsTab.setControl(this.kenyaJavacErrorTable.getControl());
        try {
            ICheckedCode checker = Mediator.check(new StringReader(this.kenyaText.getText()));
            this.setKenyaCheckedCode(checker);
        }
        catch (IOException e) {
            // empty catch block
        }
        kenyaTopControl.setWeights(new int[]{3, 1});
        this.kenyaText.setFocus();
        editorSash.addControlListener((ControlListener)new EditorControlListener(editorSash, this.kenyaNumbers, this.kenyaText));
    }

    private void buildJava(SashForm javaTopControl) {
        javaTopControl.setLayout((Layout)new FillLayout());
        SashForm editorSash = new SashForm((Composite)javaTopControl, 256);
        this.javaNumbers = new StyledText((Composite)editorSash, 524296);
        this.javaNumbers.setEditable(false);
        this.javaNumbers.setDoubleClickEnabled(false);
        this.javaNumbers.setEnabled(false);
        this.javaNumbers.addSelectionListener((SelectionListener)new NumbersSelectionListener(this.javaNumbers));
        this.javaNumbers.setBackground(DefaultHighlightingManager.WHITE);
        this.javaText = new StyledText((Composite)editorSash, 776);
        this.javaText.setEditable(false);
        this.javaText.addPaintListener((PaintListener)new JavaPaintListener(this));
        this.javaLineStyler = new JavaLineStyler();
        this.javaText.addLineStyleListener((LineStyleListener)this.javaLineStyler);
        this.javaText.addKeyListener(new KeyListener(){
            private static final String statusText = "Switch to the Kenya tab to edit the code.";

            public void keyPressed(KeyEvent e) {
                EditingWindow.this.safeSetStatus(statusText);
            }

            public void keyReleased(KeyEvent e) {
                EditingWindow.this.safeSetStatus(statusText);
            }
        });
        this.rebuildJavaNumbers();
        editorSash.setWeights(new int[]{1, 18});
        Composite ioComposite = new Composite((Composite)javaTopControl, 2048);
        FormLayout fl = new FormLayout();
        ioComposite.setLayout((Layout)fl);
        this.javaExecuteButton = new Button(ioComposite, 8);
        this.javaExecuteButton.setText("E&xecute Java");
        this.javaTerminateButton = new Button(ioComposite, 8);
        this.javaTerminateButton.setText("Terminate");
        this.javaTerminateButton.setEnabled(false);
        this.javaTerminateButton.addSelectionListener((SelectionListener)new JavaTerminateButtonSelectionListener(this));
        this.javaStdOutText = new StyledText(ioComposite, 2626);
        this.javaStdOutText.setEditable(false);
        this.javaStdOutText.setTabs(8);
        this.javaStdInText = new Text(ioComposite, 2052);
        this.javaStdInText.setEditable(true);
        this.javaStdInText.setEnabled(false);
        this.javaStdInText.setTabs(8);
        this.javaEOFButton = new Button(ioComposite, 8);
        this.javaEOFButton.setText("Input EOF");
        this.javaEOFButton.setEnabled(false);
        this.javaArgsLabel = new Label(ioComposite, 16384);
        this.javaArgsLabel.setText("Arguments");
        this.javaArgsText = new Text(ioComposite, 2052);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment((Control)this.javaTerminateButton, -5);
        this.javaExecuteButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, -1);
        fd.width = 100;
        fd.bottom = new FormAttachment((Control)this.javaExecuteButton, 0, 1024);
        this.javaTerminateButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.javaExecuteButton, 5);
        fd.bottom = new FormAttachment((Control)this.javaStdInText, -5);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        this.javaStdOutText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment((Control)this.javaArgsText, -5);
        fd.right = new FormAttachment((Control)this.javaEOFButton, -5);
        this.javaStdInText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -1);
        fd.bottom = new FormAttachment((Control)this.javaArgsText, -5);
        fd.width = 100;
        fd.top = new FormAttachment((Control)this.javaStdInText, 0, 128);
        this.javaEOFButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, -5);
        fd.top = new FormAttachment((Control)this.javaArgsText, 5, 128);
        this.javaArgsLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -1);
        fd.left = new FormAttachment((Control)this.javaArgsLabel, 5);
        fd.bottom = new FormAttachment(100, -5);
        this.javaArgsText.setLayoutData((Object)fd);
        JavaExecuteButtonSelectionListener executeJavaButtonSelection = new JavaExecuteButtonSelectionListener(this);
        this.javaExecuteButton.addSelectionListener((SelectionListener)executeJavaButtonSelection);
        javaTopControl.setWeights(new int[]{2, 1});
        javaTopControl.addControlListener((ControlListener)new EditorControlListener(editorSash, this.javaNumbers, this.javaText));
    }

    private void buildInterpreter(SashForm interpreterTopControl) {
        SashForm editorSash = new SashForm((Composite)interpreterTopControl, 256);
        this.interpreterNumbers = new StyledText((Composite)editorSash, 524296);
        this.interpreterNumbers.setEditable(false);
        this.interpreterNumbers.setDoubleClickEnabled(false);
        this.interpreterNumbers.setEnabled(false);
        this.interpreterNumbers.addSelectionListener((SelectionListener)new NumbersSelectionListener(this.interpreterNumbers));
        this.interpreterNumbers.setBackground(DefaultHighlightingManager.WHITE);
        this.interpreterText = new StyledText((Composite)editorSash, 776);
        this.interpreterText.setEditable(false);
        this.interpreterText.addPaintListener((PaintListener)new InterpreterPaintListener(this));
        this.interpreterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character >= ' ') {
                    int caretOffset = EditingWindow.this.interpreterText.getCaretOffset();
                    EditingWindow.this.topTabs.setSelection(0);
                    EditingWindow.this.kenyaText.setSelection(caretOffset);
                    EditingWindow.this.kenyaText.showSelection();
                    EditingWindow.this.kenyaText.insert("" + e.character);
                    EditingWindow.this.kenyaText.setCaretOffset(caretOffset + 1);
                    EditingWindow.this.kenyaText.setFocus();
                }
            }
        });
        this.carrotPainter = new CarrotPainter(this);
        this.interpreterText.addPaintListener((PaintListener)this.carrotPainter);
        InterpreterMouseListener iml = new InterpreterMouseListener(this);
        this.interpreterText.addMouseListener((MouseListener)iml);
        this.rebuildInterpreterNumbers();
        editorSash.setWeights(new int[]{1, 18});
        SashForm inspectorSash = new SashForm((Composite)interpreterTopControl, 2304);
        this.interpreterList = new ListViewer((Composite)inspectorSash, 772);
        this.interpreterList.setContentProvider((IContentProvider)new InterpreterInspectorListContentProvider());
        this.interpreterList.setLabelProvider((IBaseLabelProvider)new InterpreterInspectorListLabelProvider(this));
        this.interpreterList.addSelectionChangedListener(new ISelectionChangedListener(){
            private Object firstElement = null;

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() != this.firstElement) {
                    EditingWindow.this.getInterpreterInspector().setInput(selection.getFirstElement());
                    this.firstElement = selection.getFirstElement();
                }
                if (selection.getFirstElement() instanceof IMethodScope) {
                    IFunction function = EditingWindow.this.getBaseStackMachine().lookupFunction(((IMethodScope)selection.getFirstElement()).getCurrentMethod().getName());
                    StyledText text = EditingWindow.this.getInterpreterTextWidget();
                    int offset = text.getOffsetAtLine(function.getPosition().getLineNumber() - 1);
                    text.setCaretOffset(offset += function.getPosition().getColumnNumber() - 1);
                    text.setSelection(offset, offset + function.getPosition().getTokenLength());
                }
            }
        });
        this.interpreterInspector = new TreeViewer((Composite)inspectorSash, 772);
        this.interpreterInspector.setContentProvider((IContentProvider)new InterpreterInspectorContentProvider());
        this.interpreterInspector.setLabelProvider((IBaseLabelProvider)new InterpreterInspectorLabelProvider(this));
        this.interpreterInspector.setUseHashlookup(true);
        Composite ioComposite = new Composite((Composite)interpreterTopControl, 2048);
        FormLayout fl = new FormLayout();
        ioComposite.setLayout((Layout)fl);
        this.interpreterInterpretButton = new Button(ioComposite, 8);
        this.interpreterInterpretButton.setText("&Run");
        this.interpreterInterpretButton.setEnabled(false);
        this.interpreterStdOutText = new StyledText(ioComposite, 2626);
        this.interpreterStdOutText.setText("");
        this.interpreterStdOutText.setEditable(false);
        this.interpreterStdOutText.setTabs(8);
        this.interpreterStdInText = new Text(ioComposite, 2052);
        this.interpreterStdInText.setText("");
        this.interpreterStdInText.setEditable(true);
        this.interpreterStdInText.setEnabled(false);
        this.interpreterStdInText.setTabs(8);
        this.interpreterEOFButton = new Button(ioComposite, 8);
        this.interpreterEOFButton.setText("Input EOF");
        this.interpreterEOFButton.setEnabled(false);
        this.interpreterTerminateButton = new Button(ioComposite, 8);
        this.interpreterTerminateButton.setText("Terminate");
        this.interpreterTerminateButton.setEnabled(false);
        this.interpreterStepModeButton = new Button(ioComposite, 2);
        this.interpreterStepModeButton.setText("Step Mode");
        this.interpreterStepModeButton.setEnabled(false);
        this.interpreterStepModeButton.addSelectionListener((SelectionListener)new InterpreterStepModeButtonSelectionListener(this));
        this.setInterpreterStepMode(this.interpreterStepModeButton.getSelection());
        this.interpreterContinueButton = new Button(ioComposite, 8);
        this.interpreterContinueButton.setText("Continue");
        this.interpreterContinueButton.setEnabled(false);
        this.interpreterContinueButton.addSelectionListener((SelectionListener)new InterpreterContinueButtonSelectionListener(this));
        this.interpreterTrackButton = new Button(ioComposite, 2);
        this.interpreterTrackButton.setText("Track");
        this.interpreterTrackButton.setEnabled(true);
        this.interpreterTrackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pri = Thread.currentThread().getPriority();
                Thread.currentThread().setPriority(10);
                EditingWindow.this.setInterpreterTrackMode(EditingWindow.this.interpreterTrackButton.getSelection());
                Thread.currentThread().setPriority(pri);
            }
        });
        this.interpreterTrackButton.setSelection(true);
        this.setInterpreterTrackMode(this.interpreterTrackButton.getSelection());
        this.interpreterArgsLabel = new Label(ioComposite, 16384);
        this.interpreterArgsLabel.setText("Arguments");
        this.interpreterArgsText = new Text(ioComposite, 2052);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment((Control)this.interpreterTrackButton, -5);
        this.interpreterInterpretButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.interpreterContinueButton, -5);
        fd.width = 100;
        fd.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterTrackButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.interpreterStepModeButton, -5);
        fd.width = 100;
        fd.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterContinueButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.interpreterTerminateButton, -5);
        fd.width = 100;
        fd.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterStepModeButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, -1);
        fd.width = 100;
        fd.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterTerminateButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.interpreterInterpretButton, 5);
        fd.bottom = new FormAttachment((Control)this.interpreterStdInText, -5);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        this.interpreterStdOutText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment((Control)this.interpreterArgsText, -5);
        fd.right = new FormAttachment((Control)this.interpreterEOFButton, -5);
        this.interpreterStdInText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -1);
        fd.bottom = new FormAttachment((Control)this.interpreterArgsText, -5);
        fd.width = 100;
        fd.top = new FormAttachment((Control)this.interpreterStdInText, 0, 128);
        this.interpreterEOFButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, -5);
        fd.top = new FormAttachment((Control)this.interpreterArgsText, 5, 128);
        this.interpreterArgsLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -1);
        fd.left = new FormAttachment((Control)this.interpreterArgsLabel, 5);
        fd.bottom = new FormAttachment(100, -5);
        this.interpreterArgsText.setLayoutData((Object)fd);
        InterpreterInterpretSelectionListener interpretButtonListener = new InterpreterInterpretSelectionListener(this);
        this.interpreterInterpretButton.addSelectionListener((SelectionListener)interpretButtonListener);
        interpreterTopControl.setWeights(new int[]{1, 1, 1});
        interpreterTopControl.addControlListener((ControlListener)new EditorControlListener(editorSash, this.interpreterNumbers, this.interpreterText));
    }

    protected synchronized MenuManager createMenuManager() {
        MenuManager bar_menu = new MenuManager("");
        MenuManager file_menu = new MenuManager("&File");
        bar_menu.add((IContributionItem)file_menu);
        file_menu.add((IAction)new NewAction(this));
        file_menu.add((IAction)new OpenAction(this));
        file_menu.add((IAction)new OpenInNewAction(this));
        file_menu.add((IAction)new KenyaSaveAction(this));
        file_menu.add((IAction)new KenyaSaveAsAction(this));
        this.javaSaveAction = new JavaSaveAction(this);
        this.javaSaveAsAction = new JavaSaveAsAction(this);
        this.javaSaveAction.setEnabled(false);
        this.javaSaveAsAction.setEnabled(false);
        file_menu.add(this.javaSaveAction);
        file_menu.add(this.javaSaveAsAction);
        file_menu.add((IAction)new CloseAction(this));
        file_menu.add((IAction)new ExitAction(this));
        MenuManager edit_menu = new MenuManager("&Edit");
        bar_menu.add((IContributionItem)edit_menu);
        edit_menu.add((IAction)new FormatAction(this));
        MenuManager view_menu = new MenuManager("&View");
        bar_menu.add((IContributionItem)view_menu);
        MenuManager editing_fonts_menu = new MenuManager("&Editor Fonts");
        view_menu.add((IContributionItem)editing_fonts_menu);
        MenuManager editing_fonts_size_menu = new MenuManager("Size");
        editing_fonts_menu.add((IContributionItem)editing_fonts_size_menu);
        UniqueCheckedManager ucm = new UniqueCheckedManager();
        Action fontAction = new EditorSmallFontAction(this);
        ucm.addAction((IAction)fontAction);
        editing_fonts_size_menu.add((IAction)fontAction);
        fontAction = new EditorMediumFontAction(this);
        ucm.addAction((IAction)fontAction);
        editing_fonts_size_menu.add((IAction)fontAction);
        fontAction = new EditorBigFontAction(this);
        ucm.addAction((IAction)fontAction);
        editing_fonts_size_menu.add((IAction)fontAction);
        fontAction = new EditorHugeFontAction(this);
        ucm.addAction((IAction)fontAction);
        editing_fonts_size_menu.add((IAction)fontAction);
        MenuManager editing_fonts_type_menu = new MenuManager("Type");
        editing_fonts_menu.add((IContributionItem)editing_fonts_type_menu);
        ucm = new UniqueCheckedManager();
        fontAction = new EditorProportionalFontAction(this);
        ucm.addAction((IAction)fontAction);
        editing_fonts_type_menu.add((IAction)fontAction);
        fontAction = new EditorFixedFontAction(this);
        ucm.addAction((IAction)fontAction);
        editing_fonts_type_menu.add((IAction)fontAction);
        MenuManager java_io_fonts_menu = new MenuManager("&I/O Fonts");
        view_menu.add((IContributionItem)java_io_fonts_menu);
        MenuManager java_io_fonts_size_menu = new MenuManager("Size");
        java_io_fonts_menu.add((IContributionItem)java_io_fonts_size_menu);
        ucm = new UniqueCheckedManager();
        fontAction = new IOSmallFontAction(this);
        ucm.addAction((IAction)fontAction);
        java_io_fonts_size_menu.add((IAction)fontAction);
        fontAction = new IOMediumFontAction(this);
        ucm.addAction((IAction)fontAction);
        java_io_fonts_size_menu.add((IAction)fontAction);
        fontAction = new IOBigFontAction(this);
        ucm.addAction((IAction)fontAction);
        java_io_fonts_size_menu.add((IAction)fontAction);
        fontAction = new IOHugeFontAction(this);
        ucm.addAction((IAction)fontAction);
        java_io_fonts_size_menu.add((IAction)fontAction);
        MenuManager java_io_fonts_type_menu = new MenuManager("Type");
        java_io_fonts_menu.add((IContributionItem)java_io_fonts_type_menu);
        ucm = new UniqueCheckedManager();
        fontAction = new IOProportionalFontAction(this);
        ucm.addAction((IAction)fontAction);
        java_io_fonts_type_menu.add((IAction)fontAction);
        fontAction = new IOFixedFontAction(this);
        ucm.addAction((IAction)fontAction);
        java_io_fonts_type_menu.add((IAction)fontAction);
        view_menu.add((IAction)new SwitchToKenya(this));
        view_menu.add((IAction)new SwitchToJava(this));
        view_menu.add((IAction)new SwitchToInterpreter(this));
        MenuManager help_menu = new MenuManager("&Help");
        bar_menu.add((IContributionItem)help_menu);
        help_menu.add((IAction)new AboutAction(this));
        return bar_menu;
    }

    public synchronized boolean isJavaRunning() {
        return this.javaRunning;
    }

    public synchronized void setJavaRunning(boolean value) {
        this.javaRunning = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeSetStatus(final String message) {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.setStatus(message);
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.safeSetStatus(message);
                }
            });
        }
    }

    public synchronized void positionKenyaNumbers() {
        if (this.kenyaNumbers.getTopPixel() != this.kenyaText.getTopPixel()) {
            this.kenyaNumbers.setTopPixel(this.kenyaText.getTopPixel());
            this.kenyaNumbers.redraw();
        }
    }

    public synchronized void positionJavaNumbers() {
        if (this.javaNumbers.getTopPixel() != this.javaText.getTopPixel()) {
            this.javaNumbers.setTopPixel(this.javaText.getTopPixel());
            this.javaNumbers.redraw();
        }
    }

    public synchronized void positionInterpreterNumbers() {
        if (this.interpreterNumbers.getTopPixel() != this.interpreterText.getTopPixel()) {
            this.interpreterNumbers.setTopPixel(this.interpreterText.getTopPixel());
            this.interpreterNumbers.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildKenyaNumbers() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                if (this.kenyaNumbersLineCount != this.kenyaText.getLineCount()) {
                    int topPixel = this.kenyaNumbers.getTopPixel();
                    this.kenyaNumbersBuffer.setLength(0);
                    for (int idx = 1; idx <= this.kenyaText.getLineCount(); ++idx) {
                        this.kenyaNumbersBuffer.append(idx);
                        this.kenyaNumbersBuffer.append('\r');
                    }
                    this.kenyaNumbers.setText(this.kenyaNumbersBuffer.toString());
                    this.kenyaNumbers.setTopPixel(topPixel);
                    this.kenyaNumbersLineCount = this.kenyaText.getLineCount();
                }
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(this.runRebuildKenyaNumbers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildJavaNumbers() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                if (this.javaNumbersLineCount != this.javaText.getLineCount()) {
                    int topPixel = this.javaNumbers.getTopPixel();
                    this.javaNumbersBuffer.setLength(0);
                    for (int idx = 1; idx <= this.javaText.getLineCount(); ++idx) {
                        this.javaNumbersBuffer.append(idx);
                        this.javaNumbersBuffer.append('\r');
                    }
                    this.javaNumbers.setText(this.javaNumbersBuffer.toString());
                    this.javaNumbers.setTopPixel(topPixel);
                    this.javaNumbersLineCount = this.javaText.getLineCount();
                }
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(this.runRebuildJavaNumbers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildInterpreterNumbers() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                if (this.interpreterNumbersLineCount != this.interpreterText.getLineCount()) {
                    int topPixel = this.interpreterNumbers.getTopPixel();
                    this.interpreterNumbersBuffer.setLength(0);
                    for (int idx = 1; idx <= this.interpreterText.getLineCount(); ++idx) {
                        this.interpreterNumbersBuffer.append(idx);
                        this.interpreterNumbersBuffer.append('\r');
                    }
                    this.interpreterNumbers.setText(this.interpreterNumbersBuffer.toString());
                    this.interpreterNumbers.setTopPixel(topPixel);
                    this.interpreterNumbersLineCount = this.interpreterText.getLineCount();
                }
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(this.runRebuildInterpreterNumbers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKenyaCheckedCode(final ICheckedCode checker) {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.kenyaHumanErrorTable.setInput((Object)checker);
                this.kenyaJavacErrorTable.setInput((Object)checker);
                if (checker.isErroredCode()) {
                    this.javaSaveAction.setEnabled(false);
                    this.javaSaveAsAction.setEnabled(false);
                    if (this.getTopTabs().getSelectionIndex() != 0) {
                        this.switchToTab(0);
                    }
                } else {
                    this.javaSaveAction.setEnabled(true);
                    this.javaSaveAsAction.setEnabled(true);
                }
                List warnings = checker.getInfos();
                if (checker.isErroredCode()) {
                    List errors = checker.getErrors();
                    for (int idx = 0; idx < errors.size(); ++idx) {
                        ISourceCodeError error = (ISourceCodeError)errors.get(idx);
                        this.getHighlightingManager().addSourceCodeError(error);
                    }
                    if (errors.size() == 1) {
                        this.safeSetStatus("1 error found.");
                    } else {
                        this.safeSetStatus("" + errors.size() + " errors found.");
                    }
                } else if (warnings.size() == 0) {
                    this.safeSetStatus("No errors or warnings found.");
                } else if (warnings.size() == 1) {
                    this.safeSetStatus("1 warning found; no errors found.");
                } else {
                    this.safeSetStatus("" + warnings.size() + " warnings found; no errors found.");
                }
                for (int idx = 0; idx < warnings.size(); ++idx) {
                    ISourceCodeInformation warning = (ISourceCodeInformation)warnings.get(idx);
                    this.getHighlightingManager().addSourceCodeWarning(warning);
                }
                this.getKenyaTextWidget().redraw();
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.setKenyaCheckedCode(checker);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectInKenyaErrorTable(final ISourceCodeInformation error) {
        if (!this.isVisible()) {
            return;
        }
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                if (this.kenyaJavacErrorTable == null || this.kenyaHumanErrorTable == null) {
                    return;
                }
                if (error == null && !this.getTopTabs().isDisposed()) {
                    this.kenyaJavacErrorTable.getTable().deselectAll();
                    this.kenyaHumanErrorTable.getTable().deselectAll();
                } else {
                    int index = this.kenyaTableContents.getIndex(error);
                    if (index == -1) {
                        this.kenyaJavacErrorTable.getTable().deselectAll();
                        this.kenyaHumanErrorTable.getTable().deselectAll();
                    } else {
                        this.kenyaJavacErrorTable.getTable().setSelection(index);
                        this.kenyaJavacErrorTable.getTable().showSelection();
                        this.kenyaHumanErrorTable.getTable().setSelection(index);
                        this.kenyaHumanErrorTable.getTable().showSelection();
                    }
                }
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.selectInKenyaErrorTable(error);
                }
            });
        }
    }

    public synchronized StyledText getKenyaTextWidget() {
        return this.kenyaText;
    }

    public synchronized StyledText getJavaTextWidget() {
        return this.javaText;
    }

    public synchronized StyledText getInterpreterTextWidget() {
        return this.interpreterText;
    }

    public synchronized StyledText getInterpreterLineNumberWidget() {
        return this.interpreterNumbers;
    }

    public synchronized StyledText getKenyaLineNumberWidget() {
        return this.kenyaNumbers;
    }

    public synchronized StyledText getJavaLineNumberWidget() {
        return this.javaNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKenyaText() {
        if (!this.isVisible()) {
            return "";
        }
        if (Thread.currentThread().equals(this.kenyaText.getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.setKenyaWidgetText(this.kenyaText.getText());
            }
        } else {
            this.kenyaText.getDisplay().syncExec(this.runGetKenyaText);
        }
        return this.getKenyaWidgetText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterpreterStepMode(boolean result) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.interpreterStepMode = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInterpreterStepMode() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.interpreterStepMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWindowVisible(boolean isVisible) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.isVisible = isVisible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getWindowVisible() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.isVisible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        TabFolder topTabs = this.getTopTabs();
        if (topTabs == null || topTabs.isDisposed() || Kenya.isExiting()) {
            return false;
        }
        if (Thread.currentThread().equals(topTabs.getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.setWindowVisible(topTabs.isVisible());
            }
        } else {
            topTabs.getDisplay().syncExec(this.runIsVisible);
        }
        return this.getWindowVisible();
    }

    public synchronized void resetTimer() {
        this.lastKeyEvent.setTime(System.currentTimeMillis());
    }

    public synchronized Date getLastKeyEvent() {
        return this.lastKeyEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeRedraw() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.getTopTabs().redraw();
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(this.runSafeRedraw);
        }
    }

    public synchronized void reparse(boolean value) {
        this.reparse = value;
    }

    public synchronized boolean reparse() {
        return this.reparse;
    }

    public synchronized void setKenyaFile(FileLoaderSaver fls) {
        this.kenyaFileLoaderSaver = fls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromKenyaFile() {
        if (this.getKenyaTextWidget() != null && this.getKenyaFile() != null) {
            if (Thread.currentThread().equals(this.kenyaText.getDisplay().getThread())) {
                EditingWindow editingWindow = this;
                synchronized (editingWindow) {
                    FileLoaderSaver fls = this.getKenyaFile();
                    String contents = fls.loadFile(fls.getPath());
                    this.getShell().setText("Kenya IDE: " + fls.getPath());
                    this.kenyaText.setText(contents);
                    this.switchToTab(0);
                    this.getIndentationStrategy().parseText(this.kenyaText);
                    this.kenyaText.setCaretOffset(0);
                    this.kenyaText.setSelection(0);
                    this.kenyaText.setFocus();
                    this.reparse(true);
                    this.setModified(false);
                }
            } else {
                this.kenyaText.getDisplay().syncExec(this.runLoadFromKenyaFile);
            }
        }
    }

    public synchronized FileLoaderSaver getKenyaFile() {
        return this.kenyaFileLoaderSaver;
    }

    public synchronized KenyaLineStyler getKenyaLineStyler() {
        return this.kenyaLineStyler;
    }

    public synchronized JavaLineStyler getJavaLineStyler() {
        return this.javaLineStyler;
    }

    synchronized void setKenyaLineStyler(KenyaLineStyler lineStyler) {
        this.kenyaLineStyler = lineStyler;
    }

    public synchronized IHighlightingManager getHighlightingManager() {
        return this.highlights;
    }

    public synchronized void setHighlightingManager(IHighlightingManager highlights) {
        this.highlights = highlights;
    }

    public synchronized TabFolder getTopTabs() {
        return this.topTabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKCaretOffset(int offset) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.caretOffset = offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKCaretOffset() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.caretOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKenyaCaretOffset() {
        if (!this.isVisible()) {
            return 0;
        }
        if (Thread.currentThread().equals(this.kenyaText.getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                if (this.kenyaText.isDisposed()) {
                    this.setKCaretOffset(0);
                } else {
                    this.setKCaretOffset(this.kenyaText.getCaretOffset());
                }
            }
        } else {
            this.kenyaText.getDisplay().syncExec(this.runGetKenyaCaretOffset);
        }
        return this.getKCaretOffset();
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public synchronized void setModified(boolean modified) {
        if (!this.modified && modified) {
            if (this.kenyaFileLoaderSaver != null && this.kenyaFileLoaderSaver.getPath() != null && !this.kenyaFileLoaderSaver.getPath().equals("")) {
                this.getShell().setText("Kenya IDE: " + this.kenyaFileLoaderSaver.getPath() + " (modified)");
            } else {
                this.getShell().setText("Kenya IDE (modified)");
            }
        } else if (this.modified && !modified) {
            if (this.kenyaFileLoaderSaver != null && this.kenyaFileLoaderSaver.getPath() != null && !this.kenyaFileLoaderSaver.getPath().equals("")) {
                this.getShell().setText("Kenya IDE: " + this.kenyaFileLoaderSaver.getPath());
            } else {
                this.getShell().setText("Kenya IDE");
            }
        }
        this.modified = modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWindow() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                if (this.unloadKenyaFile()) {
                    this.close();
                }
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(this.runCloseWindow);
        }
    }

    public boolean unloadKenyaFile() {
        if (this.isModified()) {
            SavePromptAction spa = new SavePromptAction(this);
            spa.run();
            if (spa.isCancelled()) {
                return false;
            }
        }
        return true;
    }

    public IndentationStrategy getIndentationStrategy() {
        return this.is;
    }

    public synchronized String getJavaClassName() {
        return this.javaClassName;
    }

    public synchronized void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public synchronized IJavaCode getJavaCode() {
        return this.javaCode;
    }

    public synchronized void setJavaCode(IJavaCode javaCode) {
        this.javaCode = javaCode;
    }

    public synchronized String getJavaDefaultClassName() {
        return this.javaDefaultClassName;
    }

    public synchronized void setBaseStackMachine(IStackMachineInformationProvider smip) {
        this.baseStackMachine = smip;
    }

    public synchronized IStackMachineInformationProvider getBaseStackMachine() {
        return this.baseStackMachine;
    }

    public synchronized Text getJavaStdInText() {
        return this.javaStdInText;
    }

    public synchronized StyledText getJavaStdOutText() {
        return this.javaStdOutText;
    }

    public synchronized CarrotPainter getCarrotPainter() {
        return this.carrotPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionBlueCarrot(final ISourceCodeLocation loc) {
        if (Thread.currentThread().equals(this.getInterpreterTextWidget().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                int row = loc.getLineNumber() - 1;
                int col = loc.getColumnNumber() - 1;
                int offset = this.getInterpreterTextWidget().getOffsetAtLine(row) + col;
                this.getCarrotPainter().setBlueCarrotOffset(offset);
                this.getInterpreterInspector().refresh();
            }
        } else {
            this.getInterpreterTextWidget().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.positionBlueCarrot(loc);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionBlueCarrot(final int offset) {
        if (Thread.currentThread().equals(this.getInterpreterTextWidget().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.getCarrotPainter().setBlueCarrotOffset(offset);
                this.getInterpreterInspector().refresh();
            }
        } else {
            this.getInterpreterTextWidget().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.positionBlueCarrot(offset);
                }
            });
        }
    }

    public synchronized Button getInterpreterInterpretButton() {
        return this.interpreterInterpretButton;
    }

    public synchronized StyledText getInterpreterStdOutText() {
        return this.interpreterStdOutText;
    }

    public synchronized Text getInterpreterStdInText() {
        return this.interpreterStdInText;
    }

    public synchronized Button getInterpreterEOFButton() {
        return this.interpreterEOFButton;
    }

    public synchronized Button getInterpreterTerminateButton() {
        return this.interpreterTerminateButton;
    }

    public synchronized SelectionListener getTabSelectionListener() {
        return this.tabSelectionListener;
    }

    public synchronized Button getInterpreterStepModeButton() {
        return this.interpreterStepModeButton;
    }

    public synchronized Button getInterpreterContinueButton() {
        return this.interpreterContinueButton;
    }

    public synchronized StackMachine getStackMachine() {
        return this.stackMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStackMachine(final StackMachine stackMachine) {
        if (Thread.currentThread().equals(this.getInterpreterInspector().getControl().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.stackMachine = stackMachine;
                this.interpreterInspector.setInput((Object)stackMachine);
                this.interpreterList.setInput((Object)stackMachine);
            }
        } else {
            this.getInterpreterInspector().getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.setStackMachine(stackMachine);
                }
            });
        }
    }

    public synchronized IButtonManager getButtonManager() {
        return this.buttonManager;
    }

    public synchronized Button getJavaExecuteButton() {
        return this.javaExecuteButton;
    }

    public synchronized Button getJavaEOFButton() {
        return this.javaEOFButton;
    }

    public synchronized Button getJavaTerminateButton() {
        return this.javaTerminateButton;
    }

    public synchronized void setEditorFonts(Font font) {
        if (this.kenyaText != null) {
            this.kenyaText.setFont(font);
            this.kenyaNumbers.setFont(font);
        }
        if (this.kenyaHumanErrorTable != null) {
            this.kenyaHumanErrorTable.getControl().setFont(font);
            this.kenyaJavacErrorTable.getControl().setFont(font);
        }
        if (this.javaText != null) {
            this.javaText.setFont(font);
            this.javaNumbers.setFont(font);
        }
        if (this.interpreterText != null) {
            this.interpreterText.setFont(font);
            this.interpreterNumbers.setFont(font);
        }
        if (this.interpreterInspector != null) {
            this.interpreterInspector.getControl().setFont(font);
            this.interpreterList.getControl().setFont(font);
        }
    }

    public synchronized void setIOFonts(Font font) {
        if (this.javaText != null) {
            this.javaStdOutText.setFont(font);
            this.javaStdInText.setFont(font);
        }
        if (this.interpreterText != null) {
            this.interpreterStdOutText.setFont(font);
            this.interpreterStdInText.setFont(font);
        }
    }

    public synchronized void switchToTab(int tab) {
        if ((tab == 0 || tab == 1 || tab == 2) && this.topTabs != null && this.getTopTabs().getSelectionIndex() != tab) {
            this.getTopTabs().setSelection(tab);
            this.tabSelectionListener.widgetSelected(null);
        }
    }

    public synchronized FileLoaderSaver getJavaFileLoaderSaver() {
        return this.javaFileLoaderSaver;
    }

    public synchronized void setJavaFileLoaderSaver(FileLoaderSaver javaFileLoaderSaver) {
        this.javaFileLoaderSaver = javaFileLoaderSaver;
    }

    public synchronized Button getInterpreterTrackButton() {
        return this.interpreterTrackButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInterpreterTrackMode() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.interpreterTrackMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterpreterTrackMode(boolean interpreterTrackMode) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.interpreterTrackMode = interpreterTrackMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKenyaWidgetText() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.kenyaWidgetText;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKenyaWidgetText(String kenyaWidgetText) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.kenyaWidgetText = kenyaWidgetText;
        }
    }

    public synchronized TreeViewer getInterpreterInspector() {
        return this.interpreterInspector;
    }

    public synchronized ListViewer getInterpreterList() {
        return this.interpreterList;
    }

    public synchronized Text getInterpreterArgsText() {
        return this.interpreterArgsText;
    }

    public synchronized Text getJavaArgsText() {
        return this.javaArgsText;
    }

    private String[] getArgs(String input) {
        Pattern p = Pattern.compile("[ ]*([^ ]+)[ ]*");
        Matcher m = p.matcher(input);
        m.reset();
        ArrayList<String> args = new ArrayList<String>();
        while (m.find()) {
            args.add(m.group(1));
        }
        return args.toArray(new String[args.size()]);
    }

    public String[] getJavaArgs() {
        if (Thread.currentThread().equals(this.getJavaArgsText().getDisplay().getThread())) {
            this.setJavaArgsResult(this.getArgs(this.getJavaArgsText().getText()));
        } else {
            this.getJavaArgsText().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.getJavaArgs();
                }
            });
        }
        return this.getJavaArgsResult();
    }

    public String[] getInterpreterArgs() {
        if (Thread.currentThread().equals(this.getInterpreterArgsText().getDisplay().getThread())) {
            this.setInterpreterArgsResult(this.getArgs(this.getInterpreterArgsText().getText()));
        } else {
            this.getInterpreterArgsText().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.getInterpreterArgs();
                }
            });
        }
        return this.getInterpreterArgsResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJavaArgsResult(String[] javaArgs) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.javaArgsResult = javaArgs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getJavaArgsResult() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.javaArgsResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterpreterArgsResult(String[] interpreterArgs) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.interpreterArgsResult = interpreterArgs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getInterpreterArgsResult() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.interpreterArgsResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKenyaAs(final boolean saveJava) {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                Shell shell = new Shell();
                FileDialog dialog = new FileDialog(shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.k"});
                dialog.setText("Save Kenya file");
                if (this.lastDir == null && this.getKenyaFile() != null) {
                    this.lastDir = this.getKenyaFile().getDir();
                    if (this.lastDir.length() == 0) {
                        this.lastDir = null;
                    }
                }
                if (this.lastDir != null) {
                    dialog.setFilterPath(this.lastDir);
                }
                if (dialog.open() != null) {
                    this.lastDir = dialog.getFilterPath();
                    File file = new File(dialog.getFilterPath(), dialog.getFileName());
                    if (this.getKenyaFile() == null) {
                        FileLoaderSaver fls = new FileLoaderSaver();
                        fls.setPath(file.getAbsolutePath());
                        this.setKenyaFile(fls);
                    } else {
                        FileLoaderSaver fls = this.getKenyaFile();
                        fls.setPath(file.getAbsolutePath());
                    }
                    this.saveKenya(saveJava);
                }
            }
        } else {
            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.saveKenyaAs(saveJava);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKenya(final boolean saveJava) {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                FileLoaderSaver fls = this.getKenyaFile();
                if (fls == null || fls.getPath() == null) {
                    this.saveKenyaAs(saveJava);
                    return;
                }
                fls.saveFile(this.getKenyaTextWidget().getText());
                this.setModified(false);
                this.safeSetStatus("Kenya code saved to " + fls.getPath());
                if (saveJava) {
                    Shell shell = new Shell();
                    try {
                        ICheckedCode checkedCode = Mediator.check(new StringReader(this.getKenyaTextWidget().getText()));
                        this.getHighlightingManager().clear();
                        this.setKenyaCheckedCode(checkedCode);
                        if (!checkedCode.isErroredCode()) {
                            this.setJavaCode(checkedCode.translate());
                            MessageBox box = new MessageBox(shell, 192);
                            box.setMessage("Would you like to save the Java translation of your Kenya?");
                            box.setText("Save Java Translation");
                            if (box.open() == 64) {
                                this.saveJava();
                            } else {
                                this.safeSetStatus("Java Translation not saved.");
                            }
                        } else {
                            this.setJavaCode(null);
                            MessageBox box = new MessageBox(shell, 32);
                            box.setMessage("Kenya code contains errors, unable to save Java translation.");
                            box.setText("Save Java Translation");
                            box.open();
                        }
                    }
                    catch (IOException e1) {
                        System.err.println("Error whilst parsing code.");
                    }
                }
            }
        }
        this.getTopTabs().getDisplay().syncExec(new Runnable(){

            public void run() {
                EditingWindow.this.saveKenya(saveJava);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJavaAs() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                Shell shell = new Shell();
                FileDialog dialog = new FileDialog(shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.java"});
                dialog.setText("Save Java translation file");
                if (this.lastDir == null && this.getJavaFileLoaderSaver() != null) {
                    this.lastDir = this.getJavaFileLoaderSaver().getDir();
                    if (this.lastDir.length() == 0) {
                        this.lastDir = null;
                    }
                }
                if (this.lastDir != null) {
                    dialog.setFilterPath(this.lastDir);
                }
                if (dialog.open() != null) {
                    this.lastDir = dialog.getFilterPath();
                    File file = new File(dialog.getFilterPath(), dialog.getFileName());
                    if (this.getJavaFileLoaderSaver() == null) {
                        FileLoaderSaver fls = new FileLoaderSaver();
                        fls.setPath(file.getAbsolutePath());
                        this.setJavaFileLoaderSaver(fls);
                    } else {
                        FileLoaderSaver fls = this.getJavaFileLoaderSaver();
                        fls.setPath(file.getAbsolutePath());
                    }
                    this.saveJava();
                }
            }
        } else {
            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.saveJavaAs();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJava() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                Shell shell = new Shell();
                FileLoaderSaver fls = this.getJavaFileLoaderSaver();
                if (fls == null || fls.getPath() == null) {
                    this.saveJavaAs();
                    return;
                }
                try {
                    String name = fls.getName();
                    if (name.indexOf(46) != -1) {
                        name = name.substring(0, name.indexOf(46));
                    }
                    if (this.getJavaCode() != null) {
                        BufferedReader javaReader = new BufferedReader(this.getJavaCode().getCode(name));
                        StringBuffer javaBuffer = new StringBuffer();
                        int c = javaReader.read();
                        while (c != -1) {
                            javaBuffer.append((char)c);
                            c = javaReader.read();
                        }
                        javaReader.close();
                        fls.saveFile(javaBuffer.toString());
                        this.safeSetStatus("Java translation saved to " + fls.getPath());
                    } else {
                        MessageBox message = new MessageBox(shell, 32);
                        message.setText("Unable to save file.");
                        message.setMessage("Can't save translation of faulty code.");
                        message.open();
                        this.safeSetStatus("Can't save translation of faulty code.");
                    }
                }
                catch (IOException e) {
                    this.safeSetStatus("IOException occured when translating Kenya.");
                }
                catch (IllegalArgumentException e) {
                    MessageBox message = new MessageBox(shell, 32);
                    message.setText("Unable to save file.");
                    message.setMessage("Can not save Java into invalid file name '" + fls.getName() + "'");
                    message.open();
                    this.safeSetStatus("Can not save Java into invalid file name '" + fls.getName() + "'");
                }
            }
        }
        this.getTopTabs().getDisplay().syncExec(new Runnable(){

            public void run() {
                EditingWindow.this.saveJava();
            }
        });
    }
}

