/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor;

import java.io.BufferedReader;
import java.io.IOException;
import kenya.gui.editor.icons.IButtonManager;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class HumanErrorLabelContentProvider
implements ITableLabelProvider {
    private final IButtonManager ibm;
    private final String delimiter;

    public HumanErrorLabelContentProvider(IButtonManager ibm, String delimiter) {
        this.ibm = ibm;
        this.delimiter = delimiter;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ISourceCodeError) {
            return this.ibm.getImage("redButton");
        }
        return this.ibm.getImage("yellowButton");
    }

    public String getColumnText(Object element, int columnIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Line ");
        buffer.append(((ISourceCodeInformation)element).getLocation().getLineNumber());
        buffer.append(": ");
        BufferedReader reader = new BufferedReader(((ISourceCodeInformation)element).getHumanStyleMessage());
        try {
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append(this.delimiter);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        buffer.delete(buffer.length() - this.delimiter.length(), buffer.length());
        return buffer.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

