/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class KenyaErrorContentProvider
implements IStructuredContentProvider {
    private static final Comparator itemComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof ISourceCodeError) {
                ISourceCodeError a0 = (ISourceCodeError)arg0;
                ISourceCodeLocation a0l = a0.getLocation();
                if (arg1 instanceof ISourceCodeError) {
                    ISourceCodeError a1 = (ISourceCodeError)arg1;
                    ISourceCodeLocation a1l = a1.getLocation();
                    if (a0l.getLineNumber() < a1l.getLineNumber()) {
                        return -1;
                    }
                    if (a0l.getLineNumber() > a1l.getLineNumber()) {
                        return 1;
                    }
                    if (a0l.getColumnNumber() < a1l.getColumnNumber()) {
                        return -1;
                    }
                    if (a0l.getColumnNumber() > a1l.getColumnNumber()) {
                        return 1;
                    }
                    if (a0l.getTokenLength() > a1l.getTokenLength()) {
                        return -1;
                    }
                    if (a0l.getTokenLength() < a1l.getTokenLength()) {
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            ISourceCodeInformation a0 = (ISourceCodeInformation)arg0;
            ISourceCodeLocation a0l = a0.getLocation();
            if (arg1 instanceof ISourceCodeError) {
                return 1;
            }
            ISourceCodeInformation a1 = (ISourceCodeInformation)arg1;
            ISourceCodeLocation a1l = a1.getLocation();
            if (a0l.getLineNumber() < a1l.getLineNumber()) {
                return -1;
            }
            if (a0l.getLineNumber() > a1l.getLineNumber()) {
                return 1;
            }
            if (a0l.getColumnNumber() < a1l.getColumnNumber()) {
                return -1;
            }
            if (a0l.getColumnNumber() > a1l.getColumnNumber()) {
                return 1;
            }
            if (a0l.getTokenLength() > a1l.getTokenLength()) {
                return -1;
            }
            if (a0l.getTokenLength() < a1l.getTokenLength()) {
                return 1;
            }
            return 0;
        }
    };
    private final SortedSet errors = new TreeSet(itemComparator);

    public synchronized Object[] getElements(Object inputElement) {
        this.errors.clear();
        ICheckedCode checker = (ICheckedCode)inputElement;
        if (checker.isErroredCode()) {
            this.errors.addAll(checker.getErrors());
        }
        this.errors.addAll(checker.getInfos());
        return this.errors.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public synchronized int getIndex(ISourceCodeInformation error) {
        if (this.errors.contains(error)) {
            int count = 0;
            Iterator it = this.errors.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (error.equals(item)) {
                    return count;
                }
                ++count;
            }
            return -1;
        }
        return -1;
    }
}

