/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.indenter;

import java.util.regex.Matcher;
import kenya.gui.editor.indenter.ILineIndentation;
import kenya.gui.editor.indenter.LineIndentation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;

public class IndentationStrategy {
    private ILineIndentation root = new LineIndentation();

    public void insertCarriageReturn(StyledText text, int offset) {
        text.setRedraw(false);
        int lineNumber = text.getLineAtOffset(offset);
        StyledTextContent content = text.getContent();
        content.replaceTextRange(offset, 0, content.getLineDelimiter());
        String lineText = content.getLine(lineNumber);
        Matcher trailing = ILineIndentation.TRAILINGSPACE.matcher(lineText);
        if (trailing.matches()) {
            String trailingSpaces = trailing.group(1);
            content.replaceTextRange(offset - trailingSpaces.length(), trailingSpaces.length(), "");
            offset -= trailingSpaces.length();
        }
        lineText = content.getLine(lineNumber);
        int caretDelta = this.formatLine(text, offset += content.getLineDelimiter().length());
        text.setCaretOffset(offset + caretDelta);
        text.setSelection(offset + caretDelta);
        text.showSelection();
        text.setRedraw(true);
    }

    public void insertCloseBrace(StyledText text, int offset) {
        text.setRedraw(false);
        StyledTextContent content = text.getContent();
        content.replaceTextRange(offset, 0, "}");
        int lineLengthDelta = this.formatLine(text, ++offset);
        text.setCaretOffset(offset + lineLengthDelta);
        text.setRedraw(true);
    }

    public void insertOpenBrace(StyledText text, int offset) {
        text.setRedraw(false);
        StyledTextContent content = text.getContent();
        content.replaceTextRange(offset, 0, "{");
        int lineLengthDelta = this.formatLine(text, ++offset);
        text.setCaretOffset(offset + lineLengthDelta);
        text.setRedraw(true);
    }

    public void tab(StyledText text, int offset) {
        text.setRedraw(false);
        int lineNumber = text.getLineAtOffset(offset);
        int lineOffset = text.getOffsetAtLine(lineNumber);
        StyledTextContent content = text.getContent();
        String textLine = content.getLine(lineNumber);
        Matcher indent = ILineIndentation.INDENT.matcher(textLine);
        if (indent.matches()) {
            int caretOffsetInLine = offset - lineOffset;
            String indentText = indent.group(1);
            if (caretOffsetInLine < indentText.length() || caretOffsetInLine == indentText.length() && caretOffsetInLine == 0) {
                int lineLengthDelta = this.formatLine(text, offset);
                text.setCaretOffset(lineOffset + indentText.length() + lineLengthDelta);
            } else {
                content.replaceTextRange(offset, 0, "    ");
                text.setCaretOffset(offset + "    ".length());
            }
        } else {
            content.replaceTextRange(offset, 0, "    ");
            text.setCaretOffset(offset + "    ".length());
        }
        text.setRedraw(true);
    }

    public void formatText(StyledText text) {
        text.setRedraw(false);
        StyledTextContent content = text.getContent();
        int caretOffset = text.getCaretOffset();
        for (int idx = 0; idx < content.getLineCount(); ++idx) {
            int lineOffset = content.getOffsetAtLine(idx);
            this.formatLine(text, lineOffset);
        }
        if (caretOffset > content.getCharCount()) {
            caretOffset = content.getCharCount();
        }
        boolean inc = true;
        while (caretOffset != content.getCharCount() && content.getLineDelimiter().indexOf(content.getTextRange(caretOffset, 1).charAt(0)) != -1) {
            if (inc && caretOffset + 1 < content.getCharCount()) {
                ++caretOffset;
            } else if (inc && caretOffset + 1 >= content.getCharCount()) {
                inc = false;
            }
            if (!inc && caretOffset > 0) {
                --caretOffset;
                continue;
            }
            if (inc || caretOffset > 0) continue;
            text.setRedraw(true);
            return;
        }
        text.setCaretOffset(caretOffset);
        text.setRedraw(true);
    }

    public void parseText(StyledText text) {
        StyledTextContent content = text.getContent();
        for (int idx = 0; idx < content.getLineCount(); ++idx) {
            int lineOffset = content.getOffsetAtLine(idx);
            this.parseLine(text, lineOffset);
        }
    }

    private int formatLine(StyledText text, int offset) {
        int lineNumber = text.getLineAtOffset(offset);
        int lineOffset = text.getOffsetAtLine(lineNumber);
        StyledTextContent content = text.getContent();
        String prevLineText = "";
        if (lineNumber > 0) {
            prevLineText = content.getLine(lineNumber - 1);
        }
        String lineText = content.getLine(lineNumber);
        String existingIndent = "";
        Matcher existingIndentM = ILineIndentation.INDENT.matcher(lineText);
        if (existingIndentM.matches()) {
            existingIndent = existingIndentM.group(1);
            content.replaceTextRange(lineOffset, existingIndent.length(), "");
            offset -= existingIndent.length();
        }
        String indent = this.getAppropriateIndent(lineNumber, prevLineText, lineText);
        content.replaceTextRange(lineOffset, 0, indent);
        return indent.length() - existingIndent.length();
    }

    private void parseLine(StyledText text, int offset) {
        int lineNumber = text.getLineAtOffset(offset);
        StyledTextContent content = text.getContent();
        String prevLineText = "";
        if (lineNumber > 0) {
            prevLineText = content.getLine(lineNumber - 1);
        }
        String lineText = content.getLine(lineNumber);
        this.getAppropriateIndent(lineNumber, prevLineText, lineText);
    }

    private String getAppropriateIndent(int lineNumber, String lineText, String nextLineText) {
        if (--lineNumber < 0) {
            return "";
        }
        ILineIndentation lineIndenter = this.root.getLine(lineNumber);
        if (lineIndenter == null) {
            lineIndenter = this.createNewLineIndenter(lineNumber);
        }
        lineIndenter.parselineText(lineText, nextLineText);
        return lineIndenter.getNextLineIndentation();
    }

    private ILineIndentation createNewLineIndenter(int lineNumber) {
        if (lineNumber < 1) {
            return this.root;
        }
        ILineIndentation previous = this.root.getLine(lineNumber - 1);
        if (previous == null && lineNumber - 1 > 0) {
            previous = this.createNewLineIndenter(lineNumber - 1);
        }
        LineIndentation middle = new LineIndentation();
        if (previous == null) {
            this.root = middle;
            System.err.println("Hmm, possible issue - root has been reset when creating line " + lineNumber + " - report to ms02");
        } else {
            ILineIndentation next = previous.getNextLine();
            if (next != null) {
                middle.setNextLine(next);
                next.setPreviousLine(middle);
            }
            previous.setNextLine(middle);
            middle.setPreviousLine(previous);
        }
        return middle;
    }
}

