/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.menuActions;

import java.io.File;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.FileLoaderSaver;
import kenya.gui.editor.menuActions.SavePromptAction;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenAction
extends Action {
    private final EditingWindow window;
    private String lastDir = null;

    public OpenAction(EditingWindow w) {
        this.window = w;
        this.setText("&Open in this window...@Ctrl+O");
        this.setToolTipText("Open a new file in this window");
    }

    public void run() {
        if (this.window.isModified()) {
            SavePromptAction spa = new SavePromptAction(this.window);
            spa.run();
            if (spa.isCancelled()) {
                return;
            }
        }
        Shell shell = new Shell();
        FileDialog dialog = new FileDialog(shell, 4096);
        if (this.lastDir == null && this.window.getKenyaFile() != null) {
            this.lastDir = this.window.getKenyaFile().getDir();
            if (this.lastDir.length() == 0) {
                this.lastDir = null;
            }
        }
        if (this.lastDir != null) {
            dialog.setFilterPath(this.lastDir);
        }
        dialog.setFilterExtensions(new String[]{"*.k"});
        dialog.setText("Open Kenya file");
        if (dialog.open() != null) {
            this.lastDir = dialog.getFilterPath();
            File file = new File(dialog.getFilterPath(), dialog.getFileName());
            FileLoaderSaver fls = new FileLoaderSaver();
            fls.setPath(file.getAbsolutePath());
            this.window.setKenyaFile(fls);
            this.window.loadFromKenyaFile();
        }
    }
}

