/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.menuActions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class UniqueCheckedManager
implements IPropertyChangeListener {
    private final Set actions = new HashSet();
    private volatile IAction lastChecked = null;

    public synchronized void addAction(IAction action) {
        this.actions.add(action);
        action.addPropertyChangeListener((IPropertyChangeListener)this);
        if (action.isChecked()) {
            if (this.lastChecked == null) {
                this.lastChecked = action;
            } else {
                System.err.println("Can't cope with two checked actions: " + this.lastChecked + ", " + action);
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        if (event.getNewValue() == Boolean.FALSE && event.getOldValue() == Boolean.TRUE && event.getSource() == this.lastChecked) {
            this.lastChecked.removePropertyChangeListener((IPropertyChangeListener)this);
            this.lastChecked.setChecked(true);
            this.lastChecked.addPropertyChangeListener((IPropertyChangeListener)this);
            return;
        }
        IAction fired = (IAction)event.getSource();
        if (this.actions.contains(fired)) {
            if (this.lastChecked != null && this.lastChecked != fired) {
                this.lastChecked.removePropertyChangeListener((IPropertyChangeListener)this);
                this.lastChecked.setChecked(false);
                this.lastChecked.addPropertyChangeListener((IPropertyChangeListener)this);
            } else if (this.lastChecked == null) {
                Iterator actionIt = this.actions.iterator();
                while (actionIt.hasNext()) {
                    IAction action = (IAction)actionIt.next();
                    action.removePropertyChangeListener((IPropertyChangeListener)this);
                    action.setChecked(false);
                    action.addPropertyChangeListener((IPropertyChangeListener)this);
                }
                fired.removePropertyChangeListener((IPropertyChangeListener)this);
                fired.setChecked(true);
                fired.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.lastChecked = fired;
        }
    }
}

