/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.utils.CarrotPainter;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;

public class BlueCarrotMover
implements IPointListener {
    private final CarrotPainter ipl;
    private final StyledText text;
    private final EditingWindow window;
    private volatile int row = 0;
    private volatile int col = 0;
    private volatile int offset = 0;
    private volatile boolean paint = false;
    private volatile ISourceCodeLocation loc = null;
    private volatile IMethodScope lastMethod = null;

    public BlueCarrotMover(EditingWindow w) {
        this.ipl = w.getCarrotPainter();
        this.text = w.getInterpreterTextWidget();
        this.window = w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointReached(final Object data) {
        if (this.text.isDisposed()) {
            return;
        }
        if (!(this.window.getInterpreterStepMode() || this.window.getInterpreterTrackMode() || this.ipl.carrotsSet() && this.ipl.isCarrotAtOffset((ISourceCodeLocation)data))) {
            return;
        }
        if (Thread.currentThread().equals(this.text.getDisplay().getThread())) {
            BlueCarrotMover blueCarrotMover = this;
            synchronized (blueCarrotMover) {
                this.loc = (ISourceCodeLocation)data;
                this.paint = false;
                if (this.ipl.isCarrotAtOffset(this.loc)) {
                    this.window.getStackMachine().setStepMode(true);
                    this.window.getInterpreterContinueButton().setEnabled(true);
                    this.paint = true;
                }
                if (this.window.getInterpreterStepMode()) {
                    this.window.getInterpreterContinueButton().setEnabled(true);
                    this.paint = true;
                }
                if (this.window.getInterpreterTrackMode()) {
                    this.paint = true;
                }
                if (this.paint) {
                    this.row = this.loc.getLineNumber() - 1;
                    this.col = this.loc.getColumnNumber() - 1;
                    this.offset = this.text.getOffsetAtLine(this.row) + this.col;
                    this.ipl.setBlueCarrotOffset(this.offset);
                    if (this.window.getStackMachine().getMethodScope() != this.lastMethod) {
                        this.window.getInterpreterList().refresh();
                        this.window.getInterpreterList().setSelection((ISelection)new StructuredSelection(this.window.getInterpreterList().getElementAt(0)), true);
                        this.lastMethod = this.window.getStackMachine().getMethodScope();
                    }
                    this.window.getInterpreterInspector().refresh();
                }
            }
        } else {
            this.text.getDisplay().syncExec(new Runnable(){

                public void run() {
                    BlueCarrotMover.this.pointReached(data);
                }
            });
        }
    }
}

