/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kenya.Kenya;
import kenya.gui.editor.DefaultHighlightingManager;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.FileLoaderSaver;
import kenya.gui.editor.HighlightingFactory;
import kenya.gui.editor.utils.ExitListener;
import kenya.gui.editor.utils.KenyaHelperThread;
import org.eclipse.swt.widgets.Display;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class EditingWindowUtilsFactory {
    private static int counter = 0;
    private static final Set editingWindows = new HashSet();

    private EditingWindowUtilsFactory() {
    }

    public static EditingWindow createAndOpenEditorWindow() {
        EditingWindow window = new EditingWindow(EditingWindowUtilsFactory.getNextClassName());
        EditingWindowUtilsFactory.openEditorWindow(window);
        return window;
    }

    public static EditingWindow createAndOpenEditorWindow(FileLoaderSaver fls) {
        EditingWindow window = new EditingWindow(EditingWindowUtilsFactory.getNextClassName());
        window.setKenyaFile(fls);
        window.loadFromKenyaFile();
        EditingWindowUtilsFactory.openEditorWindow(window);
        return window;
    }

    private static void openEditorWindow(final EditingWindow window) {
        final Runnable editorThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ExitListener exitListener = new ExitListener(window);
                Kenya.addExitListener(exitListener);
                EditingWindow editingWindow = window;
                synchronized (editingWindow) {
                    window.setHighlightingManager(new DefaultHighlightingManager(window, HighlightingFactory.createErrorHighlighter(window), HighlightingFactory.createWarningHighlighter(window), HighlightingFactory.createLinkedLocationHighlighter(window)));
                }
                window.setBlockOnOpen(true);
                EditingWindowUtilsFactory.windowOpened(window);
                window.open();
                EditingWindowUtilsFactory.windowClosed(window);
                Kenya.removeExitListener(exitListener);
            }
        };
        AbstractJob start = new AbstractJob(){

            public void execute() {
                if (Display.getDefault().equals(Thread.currentThread())) {
                    editorThread.run();
                } else {
                    Display.getDefault().syncExec(editorThread);
                }
            }
        };
        JobDispatch.enqueueJob(start);
        JobDispatch.enqueueJob(new KenyaHelperThread(window));
    }

    private static synchronized void windowOpened(EditingWindow window) {
        editingWindows.add(window);
    }

    private static synchronized void windowClosed(EditingWindow window) {
        editingWindows.remove((Object)window);
        if (editingWindows.size() == 0) {
            if (Display.getCurrent().isDisposed()) {
                Display.getCurrent().dispose();
            }
            Kenya.exit();
        }
    }

    public static synchronized void closeEditingWindows() {
        Iterator it = editingWindows.iterator();
        while (it.hasNext()) {
            EditingWindow window = (EditingWindow)((Object)it.next());
            window.closeWindow();
        }
    }

    private static synchronized String getNextClassName() {
        return "Class" + ++counter;
    }
}

