/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.util.Map;
import kenya.gui.editor.EditingWindow;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IGenericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;
import org.wellquite.kenya.stackMachine.types.interfaces.INonPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class InterpreterInspectorLabelProvider
implements ILabelProvider {
    private static final String SINGLE_QUOTE = "'";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String STATIC_CLASS_ = "static class ";
    private static final String INSTANCE_OF_CLASS_ = "instance of class ";
    private static final String _EQUALS_ = " = ";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String _ARRAY_OF_LENGTH_ = " array of length ";
    private final EditingWindow window;

    public InterpreterInspectorLabelProvider(EditingWindow w) {
        this.window = w;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Map.Entry) {
            Map.Entry entry;
            String name;
            IStackMachineInformationProvider ismip = this.window.getBaseStackMachine();
            IVariable variable = ismip.lookupVariable(name = (entry = (Map.Entry)element).getKey().toString());
            if (variable != null) {
                name = variable.getType().getName() + SPACE + variable.getName();
            }
            String result = EMPTY_STRING;
            IType value = (IType)entry.getValue();
            if (value instanceof IPrimitiveType) {
                result = value instanceof IArrayType ? result + _ARRAY_OF_LENGTH_ + ((IArrayType)value).getLength() : (value instanceof ICharType ? result + SINGLE_QUOTE + ((ICharType)value).getValue().charValue() + SINGLE_QUOTE : result + ((IPrimitiveType)value).valueToString());
            } else if (value instanceof INullType) {
                result = result + ((INullType)value).valueToString();
            } else if (value instanceof IGenericType) {
                result = result + ((IGenericType)value).valueToString();
            } else if (value instanceof INonPrimitiveType) {
                if (value instanceof IStringType) {
                    result = result + DOUBLE_QUOTE + ((IStringType)value).valueToString() + DOUBLE_QUOTE;
                } else if (value instanceof IEnumType) {
                    result = result + ((IEnumType)value).valueToString() + " (enum ";
                    IInterpretedEnumeration enumeration = ((IEnumType)value).getEnumeration();
                    String enumName = enumeration.getName();
                    IClass enumDetails = ismip.lookupEnum(enumName);
                    if (enumDetails != null) {
                        enumName = enumDetails.getName();
                    }
                    result = result + enumName + " {";
                    Object[] enumValues = enumeration.getValues();
                    for (int idx = 0; idx < enumValues.length; ++idx) {
                        result = result + enumValues[idx].toString() + ", ";
                    }
                    result = result.substring(0, result.length() - 2);
                    result = result + "})";
                } else if (value instanceof IClassStaticType) {
                    result = result + STATIC_CLASS_;
                    String className = ((IClassStaticType)value).getValue().getName();
                    IClass classDetails = ismip.lookupClass(className);
                    result = classDetails == null ? result + className : result + classDetails.getName();
                } else if (value instanceof IClassInstanceType) {
                    result = result + INSTANCE_OF_CLASS_;
                    String className = ((IClassInstanceType)value).getValue().getInterpretedClass().getName();
                    IClass classDetails = ismip.lookupClass(className);
                    result = classDetails == null ? result + className : result + classDetails.getName();
                }
            }
            return name + _EQUALS_ + result;
        }
        return EMPTY_STRING;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

