/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import kenya.gui.editor.EditingWindow;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

public class InterpreterInspectorListLabelProvider
implements ILabelProvider {
    private static final String CLOSEBRACKET = ")";
    private static final String COMMASPACE = ", ";
    private static final String SPACE = " ";
    private static final String OPENBRACKET = " (";
    private final EditingWindow window;

    public InterpreterInspectorListLabelProvider(EditingWindow w) {
        this.window = w;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        StringBuffer buf = new StringBuffer();
        if (element instanceof IMethodScope) {
            IStackMachineInformationProvider ismip = this.window.getBaseStackMachine();
            IInterpretedMethod method = ((IMethodScope)element).getCurrentMethod();
            IFunction function = ismip.lookupFunction(method.getName());
            buf.append(function.getName());
            buf.append(OPENBRACKET);
            IVariable[] vars = function.getArguments();
            for (int idx = 0; idx < vars.length; ++idx) {
                buf.append(vars[idx].getType());
                buf.append(SPACE);
                buf.append(vars[idx].getName());
                buf.append(COMMASPACE);
            }
            if (buf.toString().endsWith(COMMASPACE)) {
                buf.delete(buf.length() - COMMASPACE.length(), buf.length());
            }
            buf.append(CLOSEBRACKET);
            return buf.toString();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

