/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.utils.BlueCarrotMover;
import kenya.gui.editor.utils.InterpreterLastPointReachedCatcher;
import kenya.gui.editor.utils.InterpreterTerminateButtonSelectionListener;
import kenya.gui.editor.utils.StdOutWriter;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;
import org.wellquite.kenya.stackMachine.types.ArrayTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class InterpreterInterpretSelectionListener
extends SelectionAdapter {
    private final Button interpret;
    private final EditingWindow window;
    private final StyledText stdOut;
    private final Text stdIn;
    private final Button eof;
    private final Button terminate;
    private final Runnable enableStuff;
    private final Runnable disableStuff;
    private SelectionListener eofListener = null;
    private KeyListener keyListener = null;
    private SelectionListener terminateListener = null;

    public InterpreterInterpretSelectionListener(EditingWindow w) {
        this.window = w;
        this.stdOut = w.getInterpreterStdOutText();
        this.stdIn = w.getInterpreterStdInText();
        this.interpret = w.getInterpreterInterpretButton();
        this.eof = w.getInterpreterEOFButton();
        this.terminate = w.getInterpreterTerminateButton();
        this.enableStuff = new Runnable(){

            public void run() {
                InterpreterInterpretSelectionListener.this.interpret.setEnabled(false);
                InterpreterInterpretSelectionListener.this.stdIn.setEnabled(true);
                InterpreterInterpretSelectionListener.this.stdIn.setFocus();
                InterpreterInterpretSelectionListener.this.stdIn.setText("");
                InterpreterInterpretSelectionListener.this.terminate.setEnabled(true);
                InterpreterInterpretSelectionListener.this.terminate.setText("Terminate");
                InterpreterInterpretSelectionListener.this.eof.setEnabled(true);
                InterpreterInterpretSelectionListener.this.stdOut.setText("");
            }
        };
        this.disableStuff = new Runnable(){

            public void run() {
                InterpreterInterpretSelectionListener.this.interpret.setEnabled(true);
                InterpreterInterpretSelectionListener.this.stdIn.setEnabled(false);
                InterpreterInterpretSelectionListener.this.terminate.setText("Terminate");
                InterpreterInterpretSelectionListener.this.terminate.setEnabled(false);
                InterpreterInterpretSelectionListener.this.eof.setEnabled(false);
                InterpreterInterpretSelectionListener.this.window.getInterpreterContinueButton().setEnabled(false);
                StackMachine sm = InterpreterInterpretSelectionListener.this.window.getStackMachine();
                if (sm != null) {
                    sm.resume();
                    InterpreterInterpretSelectionListener.this.window.setStackMachine(null);
                }
            }
        };
    }

    public synchronized void widgetSelected(SelectionEvent e) {
        this.interpret.setEnabled(false);
        final StackMachine sm = new StackMachine();
        final IStackMachineInformationProvider ismip = this.window.getBaseStackMachine();
        if (ismip == null) {
            return;
        }
        try {
            PipedInputStream pis = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream(pis);
            final PrintStream outStream = new PrintStream(pos, true);
            sm.setOut(outStream);
            BufferedReader outReader = new BufferedReader(new InputStreamReader(pis), 16);
            StdOutWriter stdOutReader = new StdOutWriter(outReader, this.stdOut, 9);
            PipedInputStream pisErr = new PipedInputStream();
            PipedOutputStream posErr = new PipedOutputStream(pisErr);
            final PrintStream outStreamErr = new PrintStream(posErr, true);
            sm.setErr(outStreamErr);
            BufferedReader outErrReader = new BufferedReader(new InputStreamReader(pisErr), 16);
            StdOutWriter stdErrReader = new StdOutWriter(outErrReader, this.stdOut, 3);
            PipedOutputStream qout = new PipedOutputStream();
            PipedInputStream qin = new PipedInputStream(qout);
            BufferedInputStream inStream = new BufferedInputStream(qin);
            sm.setIn(inStream);
            final PrintWriter inWriter = new PrintWriter((Writer)new OutputStreamWriter(qout), true);
            if (this.keyListener != null) {
                this.stdIn.removeKeyListener(this.keyListener);
            }
            this.keyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\r') {
                        e.doit = false;
                        String text = InterpreterInterpretSelectionListener.this.stdIn.getText() + "\n";
                        InterpreterInterpretSelectionListener.this.stdIn.setText("");
                        InterpreterInterpretSelectionListener.this.stdOut.append(text);
                        StyleRange sr = new StyleRange();
                        sr.start = InterpreterInterpretSelectionListener.this.stdOut.getCharCount() - text.length();
                        sr.length = text.length();
                        sr.foreground = InterpreterInterpretSelectionListener.this.stdOut.getDisplay().getSystemColor(6);
                        InterpreterInterpretSelectionListener.this.stdOut.setStyleRange(sr);
                        InterpreterInterpretSelectionListener.this.stdOut.setCaretOffset(InterpreterInterpretSelectionListener.this.stdOut.getCharCount());
                        InterpreterInterpretSelectionListener.this.stdOut.setSelection(InterpreterInterpretSelectionListener.this.stdOut.getCharCount());
                        InterpreterInterpretSelectionListener.this.stdOut.showSelection();
                        inWriter.write(text);
                        inWriter.flush();
                    }
                }
            };
            this.stdIn.addKeyListener(this.keyListener);
            if (this.eofListener != null) {
                this.eof.removeSelectionListener(this.eofListener);
            }
            this.eofListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    inWriter.close();
                    InterpreterInterpretSelectionListener.this.stdIn.setEnabled(false);
                    InterpreterInterpretSelectionListener.this.eof.setEnabled(false);
                }
            };
            this.eof.addSelectionListener(this.eofListener);
            if (this.terminateListener != null) {
                this.terminate.removeSelectionListener(this.terminateListener);
            }
            this.terminateListener = new InterpreterTerminateButtonSelectionListener(this.window, inWriter);
            this.terminate.addSelectionListener(this.terminateListener);
            AbstractJob launch = new AbstractJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute() {
                    try {
                        InterpreterInterpretSelectionListener.this.window.getTopTabs().getDisplay().syncExec(InterpreterInterpretSelectionListener.this.enableStuff);
                        IInterpretedClass launchClass = ismip.getEntryPointClass();
                        String launchMethod = ismip.getEntryPoint();
                        BlueCarrotMover bcm = new BlueCarrotMover(InterpreterInterpretSelectionListener.this.window);
                        sm.addPositionReachedListener(bcm);
                        InterpreterLastPointReachedCatcher ilprc = new InterpreterLastPointReachedCatcher(sm);
                        sm.addPositionReachedListener(ilprc);
                        if (InterpreterInterpretSelectionListener.this.window.getInterpreterStepMode()) {
                            sm.setStepMode(true);
                        } else {
                            sm.setStepMode(false);
                        }
                        InterpreterInterpretSelectionListener.this.window.setStackMachine(sm);
                        try {
                            try {
                                if (ismip.entryPointTakesArguments()) {
                                    String[] argsString = InterpreterInterpretSelectionListener.this.window.getInterpreterArgs();
                                    IType[] argsIType = new IType[argsString.length];
                                    for (int idx = 0; idx < argsString.length; ++idx) {
                                        argsIType[idx] = StringTypeFactory.createStringType(argsString[idx]);
                                    }
                                    sm.push(ArrayTypeFactory.createArrayType(argsIType));
                                }
                                InterpreterInterpretSelectionListener.this.window.safeSetStatus("Debugger starting.");
                                sm.invokeMethod(launchClass, launchMethod);
                                InterpreterInterpretSelectionListener.this.window.positionBlueCarrot(0);
                                InterpreterInterpretSelectionListener.this.window.safeSetStatus("Debugger completed.");
                            }
                            catch (Throwable t) {
                                sm.shutdown();
                                IAtomicClosure lastClosure = ilprc.getLastClosure();
                                ISourceCodeLocation loc = (ISourceCodeLocation)ilprc.getLastPointData();
                                if (loc == null || lastClosure == null) {
                                    outStreamErr.println(t);
                                } else {
                                    outStreamErr.println(t + " at " + lastClosure + ", line " + loc.getLineNumber() + ", column " + loc.getColumnNumber());
                                    InterpreterInterpretSelectionListener.this.window.positionBlueCarrot(loc);
                                }
                                Object var9_13 = null;
                                outStream.close();
                                outStreamErr.close();
                                inWriter.close();
                                sm.removePositionReachedListener(bcm);
                                sm.shutdown();
                                InterpreterInterpretSelectionListener.this.window.setStackMachine(null);
                                InterpreterInterpretSelectionListener.this.window.getTopTabs().getDisplay().syncExec(InterpreterInterpretSelectionListener.this.disableStuff);
                                return;
                            }
                            Object var9_12 = null;
                            outStream.close();
                            outStreamErr.close();
                            inWriter.close();
                            sm.removePositionReachedListener(bcm);
                            sm.shutdown();
                            InterpreterInterpretSelectionListener.this.window.setStackMachine(null);
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            outStream.close();
                            outStreamErr.close();
                            inWriter.close();
                            sm.removePositionReachedListener(bcm);
                            sm.shutdown();
                            InterpreterInterpretSelectionListener.this.window.setStackMachine(null);
                            InterpreterInterpretSelectionListener.this.window.getTopTabs().getDisplay().syncExec(InterpreterInterpretSelectionListener.this.disableStuff);
                            throw throwable;
                        }
                        InterpreterInterpretSelectionListener.this.window.getTopTabs().getDisplay().syncExec(InterpreterInterpretSelectionListener.this.disableStuff);
                        return;
                    }
                    catch (RuntimeException e) {
                        System.err.println("SM encountered an error:\n");
                        e.printStackTrace(System.err);
                    }
                }
            };
            JobDispatch.enqueueJob(stdOutReader);
            JobDispatch.enqueueJob(stdErrReader);
            JobDispatch.enqueueJob(launch);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }
}

