/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.util.List;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.utils.CarrotPainter;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class InterpreterMouseListener
extends MouseAdapter {
    private final CarrotPainter ipl;
    private final StyledText interpreterText;
    private final EditingWindow window;

    public InterpreterMouseListener(EditingWindow w) {
        this.ipl = w.getCarrotPainter();
        this.interpreterText = w.getInterpreterTextWidget();
        this.window = w;
    }

    public void mouseDoubleClick(MouseEvent e) {
        Point location = new Point(e.x, e.y);
        try {
            int offset = this.interpreterText.getOffsetAtLocation(location);
            int line = this.interpreterText.getLineAtOffset(offset);
            int column = offset - this.interpreterText.getOffsetAtLine(line);
            ++line;
            ++column;
            IStackMachineInformationProvider smip = this.window.getBaseStackMachine();
            if (smip != null) {
                List positions = smip.getDiscreteExecutionPointMarkersFromTheAST();
                int realOffset = 0;
                ISourceCodeLocation realLoc = null;
                int delta = Integer.MAX_VALUE;
                for (int idx = 0; idx < positions.size(); ++idx) {
                    ISourceCodeLocation scl = (ISourceCodeLocation)positions.get(idx);
                    int thisOffset = this.interpreterText.getOffsetAtLine(scl.getLineNumber() - 1) + scl.getColumnNumber() - 1;
                    if (Math.abs(offset - thisOffset) >= delta) continue;
                    realOffset = thisOffset;
                    realLoc = scl;
                    delta = Math.abs(offset - thisOffset);
                }
                if (this.ipl.isCarrotAtOffset(realOffset)) {
                    this.ipl.removeCarrot(realOffset, realLoc);
                } else {
                    this.ipl.addCarrot(realOffset, realLoc);
                }
                this.interpreterText.setSelection(offset);
                this.interpreterText.redraw();
            }
        }
        catch (IllegalArgumentException error) {
            this.interpreterText.setSelection(this.interpreterText.getCaretOffset());
            this.interpreterText.redraw();
        }
    }
}

