/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.io.PrintWriter;
import kenya.gui.editor.EditingWindow;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;

public class InterpreterTerminateButtonSelectionListener
extends SelectionAdapter {
    private final Button terminate;
    private final EditingWindow window;
    private final PrintWriter writer;

    public InterpreterTerminateButtonSelectionListener(EditingWindow w, PrintWriter write) {
        this.window = w;
        this.terminate = w.getInterpreterTerminateButton();
        this.writer = write;
    }

    public void widgetSelected(SelectionEvent e) {
        this.terminate.setText("Terminating...");
        this.terminate.setEnabled(false);
        JobDispatch.enqueueJob(new AbstractJob(){

            public void execute() {
                IStackMachineInformationProvider ismip = InterpreterTerminateButtonSelectionListener.this.window.getBaseStackMachine();
                StackMachine sm = InterpreterTerminateButtonSelectionListener.this.window.getStackMachine();
                String methodName = ismip.getEntryPoint();
                IInterpretedClass methodClass = ismip.getEntryPointClass();
                IAtomicClosure methodBody = methodClass.getMethod(methodName).getMethodBody();
                methodBody.getClosureScope().setReturn(true);
                InterpreterTerminateButtonSelectionListener.this.writer.close();
                sm.shutdown();
                InterpreterTerminateButtonSelectionListener.this.window.safeSetStatus("Debugger terminated.");
            }
        });
    }
}

