/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import kenya.Kenya;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.utils.StdOutWriter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.IJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class JavaExecuteButtonSelectionListener
extends SelectionAdapter {
    private static final String outputDir = System.getProperty("user.home") + File.separatorChar + ".kenyaTmp";
    private static final IJob deleteOnExitJob = new AbstractJob(){

        private void delDir(File dir) {
            if (dir.isFile()) {
                dir.delete();
            } else {
                File[] children = dir.listFiles();
                for (int idx = 0; idx < children.length; ++idx) {
                    this.delDir(children[idx]);
                }
                dir.delete();
            }
        }

        public void execute() {
            File output = new File(outputDir);
            File[] children = output.listFiles();
            for (int idx = 0; idx < children.length; ++idx) {
                this.delDir(children[idx]);
            }
        }
    };
    private static final int STDOUTCOLOR = 9;
    private static final int STDERRCOLOR = 3;
    private final EditingWindow window;
    private final StyledText stdOutText;
    private final Text stdInText;
    private final Button executeJavaButton;
    private final Button eofButton;
    private final Button terminateButton;
    private final String delimiter;
    private KeyListener keyListener = null;
    private SelectionListener eofListener = null;
    private final Runnable enableStuff;
    private final Runnable disableStuff;

    public JavaExecuteButtonSelectionListener(EditingWindow w) {
        this.window = w;
        this.stdOutText = w.getJavaStdOutText();
        this.stdInText = w.getJavaStdInText();
        this.executeJavaButton = w.getJavaExecuteButton();
        this.eofButton = w.getJavaEOFButton();
        this.terminateButton = w.getJavaTerminateButton();
        this.delimiter = this.stdOutText.getLineDelimiter();
        this.enableStuff = new Runnable(){

            public void run() {
                JavaExecuteButtonSelectionListener.this.eofButton.setEnabled(true);
                JavaExecuteButtonSelectionListener.this.terminateButton.setEnabled(true);
                JavaExecuteButtonSelectionListener.this.terminateButton.setText("Terminate");
                JavaExecuteButtonSelectionListener.this.stdInText.setEnabled(true);
                JavaExecuteButtonSelectionListener.this.stdInText.setFocus();
            }
        };
        this.disableStuff = new Runnable(){

            public void run() {
                JavaExecuteButtonSelectionListener.this.terminateButton.setEnabled(false);
                JavaExecuteButtonSelectionListener.this.terminateButton.setText("Terminate");
                JavaExecuteButtonSelectionListener.this.eofButton.setEnabled(false);
                JavaExecuteButtonSelectionListener.this.stdInText.setText("");
                JavaExecuteButtonSelectionListener.this.stdInText.setEnabled(false);
                JavaExecuteButtonSelectionListener.this.executeJavaButton.setText("E&xecute Java");
                JavaExecuteButtonSelectionListener.this.executeJavaButton.setSelection(false);
                JavaExecuteButtonSelectionListener.this.executeJavaButton.setEnabled(true);
            }
        };
    }

    public void widgetSelected(SelectionEvent e) {
        this.executeJavaButton.setEnabled(false);
        this.terminateButton.setEnabled(false);
        if (this.window.getJavaCode() == null) {
            this.executeJavaButton.setText("E&xecute Java");
        } else {
            this.executeJavaButton.setText("Executing...");
            try {
                PipedOutputStream stdInPOS = new PipedOutputStream();
                final BufferedReader stdInReader = new BufferedReader(new InputStreamReader(new PipedInputStream(stdInPOS)));
                final PrintWriter stdInWriter = new PrintWriter(stdInPOS);
                PipedInputStream stdOutPIS = new PipedInputStream();
                final BufferedWriter stdOutWriter = new BufferedWriter(new OutputStreamWriter(new PipedOutputStream(stdOutPIS)));
                PipedInputStream stdErrPIS = new PipedInputStream();
                final BufferedWriter stdErrWriter = new BufferedWriter(new OutputStreamWriter(new PipedOutputStream(stdErrPIS)));
                if (this.keyListener != null) {
                    this.stdInText.removeKeyListener(this.keyListener);
                }
                this.keyListener = new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.character == '\r') {
                            e.doit = false;
                            String text = JavaExecuteButtonSelectionListener.this.stdInText.getText() + JavaExecuteButtonSelectionListener.this.delimiter;
                            JavaExecuteButtonSelectionListener.this.stdInText.setText("");
                            JavaExecuteButtonSelectionListener.this.stdOutText.append(text);
                            StyleRange sr = new StyleRange();
                            sr.start = JavaExecuteButtonSelectionListener.this.stdOutText.getCharCount() - text.length();
                            sr.length = text.length();
                            sr.foreground = JavaExecuteButtonSelectionListener.this.stdOutText.getDisplay().getSystemColor(6);
                            JavaExecuteButtonSelectionListener.this.stdOutText.setStyleRange(sr);
                            JavaExecuteButtonSelectionListener.this.stdOutText.setCaretOffset(JavaExecuteButtonSelectionListener.this.stdOutText.getCharCount());
                            JavaExecuteButtonSelectionListener.this.stdOutText.setSelection(JavaExecuteButtonSelectionListener.this.stdOutText.getCharCount());
                            JavaExecuteButtonSelectionListener.this.stdOutText.showSelection();
                            stdInWriter.write(text);
                            stdInWriter.flush();
                        }
                    }
                };
                this.stdInText.addKeyListener(this.keyListener);
                if (this.eofListener != null) {
                    this.eofButton.removeSelectionListener(this.eofListener);
                }
                this.eofListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        stdInWriter.close();
                        JavaExecuteButtonSelectionListener.this.stdInText.setEnabled(false);
                        JavaExecuteButtonSelectionListener.this.eofButton.setEnabled(false);
                    }
                };
                this.eofButton.addSelectionListener(this.eofListener);
                StdOutWriter stdOutRunner = new StdOutWriter(new InputStreamReader(stdOutPIS), this.stdOutText, 9);
                StdOutWriter stdErrRunner = new StdOutWriter(new InputStreamReader(stdErrPIS), this.stdOutText, 3);
                AbstractJob launchJava = new AbstractJob(){

                    public void execute() {
                        try {
                            JavaExecuteButtonSelectionListener.this.executeJavaButton.getDisplay().syncExec(JavaExecuteButtonSelectionListener.this.enableStuff);
                            JavaExecuteButtonSelectionListener.this.window.safeSetStatus("Java execution starting.");
                            JavaExecuteButtonSelectionListener.this.window.getJavaCode().execute(outputDir, JavaExecuteButtonSelectionListener.this.window.getJavaClassName(), stdInReader, new BufferedWriter(stdInWriter), stdOutWriter, stdErrWriter, JavaExecuteButtonSelectionListener.this.window.getJavaArgs());
                            stdOutWriter.close();
                            stdErrWriter.close();
                            stdInWriter.close();
                            JavaExecuteButtonSelectionListener.this.window.setJavaRunning(false);
                            JavaExecuteButtonSelectionListener.this.executeJavaButton.getDisplay().syncExec(JavaExecuteButtonSelectionListener.this.disableStuff);
                            File javaFile = new File(outputDir, JavaExecuteButtonSelectionListener.this.window.getJavaClassName() + ".java");
                            if (javaFile.isFile()) {
                                javaFile.delete();
                            }
                            JavaExecuteButtonSelectionListener.this.window.safeSetStatus("Execution of Java complete.");
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                };
                this.stdOutText.setText("");
                this.stdOutText.setStyleRanges(new StyleRange[0]);
                this.window.setJavaRunning(true);
                JobDispatch.enqueueJob(stdOutRunner);
                JobDispatch.enqueueJob(stdErrRunner);
                JobDispatch.enqueueJob(launchJava);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    static {
        File output = new File(outputDir);
        if (!output.exists()) {
            if (!output.mkdir()) {
                System.err.println("Unable to create dir " + outputDir);
                Kenya.exit();
            }
        } else if (!output.isDirectory()) {
            System.err.println(outputDir + " should be a dir. Please remove " + outputDir + " and restart Kenya.");
        }
        Kenya.addExitListener(deleteOnExitJob);
    }
}

