/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import kenya.Kenya;
import kenya.gui.editor.EditingWindow;
import mediator.ICheckedCode;
import mediator.Mediator;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;

public class KenyaHelperThread
extends AbstractJob {
    private final EditingWindow window;
    private final long sleepPeriod = 500L;

    public KenyaHelperThread(EditingWindow w) {
        this.window = w;
    }

    public void execute() {
        block18: {
            try {
                while (!this.window.isVisible()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                }
                if (Kenya.isExiting()) {
                    return;
                }
                final StyledText text = this.window.getKenyaTextWidget();
                Runnable reparseComments = new Runnable(){

                    public void run() {
                        KenyaHelperThread.this.window.getKenyaLineStyler().parseBlockComments(text.getContent());
                        KenyaHelperThread.this.window.getTopTabs().redraw();
                    }
                };
                String oldText = "";
                String lastParseText = "";
                int oldCaretOffset = -1;
                boolean redraw = false;
                while (!Kenya.isExiting() && this.window.isVisible()) {
                    String newText = this.window.getKenyaText();
                    if (new Date().getTime() > this.window.getLastKeyEvent().getTime() + 1000L) {
                        int offset;
                        if (!lastParseText.equals(newText) || this.window.reparse()) {
                            try {
                                ICheckedCode checkedCode = Mediator.check(new StringReader(newText));
                                this.window.getHighlightingManager().clear();
                                this.window.setKenyaCheckedCode(checkedCode);
                                if (!checkedCode.isErroredCode()) {
                                    this.window.setJavaCode(checkedCode.translate());
                                } else {
                                    this.window.setJavaCode(null);
                                }
                            }
                            catch (IOException e1) {
                                System.err.println("Error whilst parsing code.");
                            }
                            lastParseText = newText;
                            this.window.reparse(false);
                            redraw = true;
                        }
                        if (oldCaretOffset != (offset = this.window.getKenyaCaretOffset())) {
                            this.window.getHighlightingManager().showLinkedHighlights(offset);
                            oldCaretOffset = offset;
                            redraw = true;
                        }
                        if (redraw) {
                            this.window.safeRedraw();
                            redraw = false;
                        }
                    }
                    if (!oldText.equals(newText)) {
                        oldText = newText;
                        text.getDisplay().syncExec(reparseComments);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (SWTException e) {
                if (Kenya.isExiting()) break block18;
                throw e;
            }
        }
    }
}

