/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import kenya.gui.editor.EditingWindow;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;

public class KenyaKeyListener
implements VerifyKeyListener {
    private final EditingWindow window;

    public KenyaKeyListener(EditingWindow w) {
        this.window = w;
    }

    public void verifyKey(VerifyEvent event) {
        if (event.keyCode == 9) {
            StyledText text = this.window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            this.window.getIndentationStrategy().tab(text, offset);
        } else if (event.keyCode == 13) {
            StyledText text = this.window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            this.window.getIndentationStrategy().insertCarriageReturn(text, offset);
        } else if (event.character == '}') {
            StyledText text = this.window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            this.window.getIndentationStrategy().insertCloseBrace(text, offset);
        } else if (event.character == '{') {
            StyledText text = this.window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            this.window.getIndentationStrategy().insertOpenBrace(text, offset);
        }
        this.window.resetTimer();
    }
}

