/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import kenya.gui.editor.indenter.ILineIndentation;
import kenya.io.VariablePushbackReader;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class KenyaLineStyler
implements LineStyleListener {
    private KenyaScanner scanner = new KenyaScanner();
    private int[] tokenColors;
    private Color[] colors;
    private List blockComments = new ArrayList();
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int OPERATOR = 8;
    public static final int GENERIC = 9;
    public static final int MAXIMUM_TOKEN = 10;

    public KenyaLineStyler() {
        this.initializeColors();
        this.scanner = new KenyaScanner();
    }

    Color getColor(int type) {
        if (type < 0 || type >= this.tokenColors.length) {
            return null;
        }
        return this.colors[this.tokenColors[type]];
    }

    boolean inBlockComment(int start, int end) {
        for (int idx = 0; idx < this.blockComments.size(); ++idx) {
            Point p = (Point)this.blockComments.get(idx);
            if (start < p.x || start > p.y || end < p.x || end > p.y) continue;
            return true;
        }
        return false;
    }

    void initializeColors() {
        Display display = Display.getDefault();
        this.colors = new Color[]{new Color((Device)display, new RGB(0, 0, 0)), new Color((Device)display, new RGB(255, 0, 0)), new Color((Device)display, new RGB(0, 165, 40)), new Color((Device)display, new RGB(0, 0, 255)), new Color((Device)display, new RGB(150, 0, 255)), new Color((Device)display, new RGB(0, 200, 200))};
        this.tokenColors = new int[10];
        this.tokenColors[0] = 0;
        this.tokenColors[1] = 0;
        this.tokenColors[2] = 3;
        this.tokenColors[3] = 1;
        this.tokenColors[5] = 2;
        this.tokenColors[6] = 0;
        this.tokenColors[7] = 0;
        this.tokenColors[8] = 4;
        this.tokenColors[9] = 5;
    }

    void disposeColors() {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i].dispose();
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        if (this.inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
            styles.addElement(new StyleRange(event.lineOffset, event.lineText.length(), this.getColor(3), null));
            event.styles = new StyleRange[styles.size()];
            styles.copyInto(event.styles);
            return;
        }
        Color defaultFgColor = ((Control)event.widget).getForeground();
        this.scanner.setRange(event.lineText);
        int token = this.scanner.nextToken(event.lineOffset);
        while (token != -1) {
            if (token != 6) {
                StyleRange lastStyle;
                if (token != 1) {
                    Color color = this.getColor(token);
                    if (!color.equals((Object)defaultFgColor) || token == 2) {
                        StyleRange style = new StyleRange(this.scanner.getStartOffset() + event.lineOffset, this.scanner.getLength(), color, null);
                        if (token == 2) {
                            style.fontStyle = 1;
                        }
                        if (styles.isEmpty()) {
                            styles.addElement(style);
                        } else {
                            lastStyle = (StyleRange)styles.lastElement();
                            if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                                lastStyle.length += style.length;
                            } else {
                                styles.addElement(style);
                            }
                        }
                    }
                } else if (!styles.isEmpty()) {
                    lastStyle = (StyleRange)styles.lastElement();
                    if (lastStyle.fontStyle == 1) {
                        int start = this.scanner.getStartOffset() + event.lineOffset;
                        lastStyle = (StyleRange)styles.lastElement();
                        if (lastStyle.start + lastStyle.length == start) {
                            lastStyle.length += this.scanner.getLength();
                        }
                    }
                }
            }
            token = this.scanner.nextToken(event.lineOffset);
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }

    public void parseBlockComments(StyledTextContent content) {
        this.blockComments.clear();
        Point currentPoint = null;
        for (int lineNumber = 0; lineNumber < content.getLineCount(); ++lineNumber) {
            String line = content.getLine(lineNumber);
            int offset = content.getOffsetAtLine(lineNumber);
            currentPoint = this.extractCommentsFromLine(line, currentPoint, offset, content);
        }
        if (currentPoint != null) {
            currentPoint.y = content.getCharCount() - 1;
            this.blockComments.add(currentPoint);
        }
    }

    private Point extractCommentsFromLine(String line, Point currentPoint, int offset, StyledTextContent content) {
        Matcher blockEnd = ILineIndentation.BLOCKEND.matcher(line);
        Matcher blockStart = ILineIndentation.BLOCKSTART.matcher(line);
        if (blockEnd.matches()) {
            String suffix;
            String prefix = blockEnd.group(1);
            if (currentPoint == null) {
                blockStart = ILineIndentation.BLOCKSTART.matcher(prefix);
                if (blockStart.matches()) {
                    String prePrefix = blockStart.group(1);
                    currentPoint = new Point(offset + prePrefix.length(), offset + prefix.length() + 2);
                    this.blockComments.add(currentPoint);
                    currentPoint = null;
                }
            } else {
                currentPoint.y = offset + prefix.length() + 2;
                this.blockComments.add(currentPoint);
                currentPoint = null;
            }
            if ((suffix = blockEnd.group(2)).length() > 0) {
                currentPoint = this.extractCommentsFromLine(suffix, currentPoint, offset + prefix.length() + 2, content);
            }
        } else if (blockStart.matches() && currentPoint == null) {
            int prefixLength = blockStart.group(1).length();
            currentPoint = new Point(offset + prefixLength, 0);
        }
        return currentPoint;
    }

    public class KenyaScanner {
        protected Map fgKeys = null;
        protected final StringBuffer fBuffer = new StringBuffer();
        protected VariablePushbackReader reader;
        protected int charsRead;
        protected int length;
        protected int currentTokenStartPosition;
        protected boolean fEofSeen = false;
        private final String[] fgKeywords = new String[]{"boolean", "char", "int", "double", "String", "void", "class", "const", "null"};
        private final String[] fgOperators = new String[]{"if", "else", "while", "return", "switch", "case", "break", "default", "for", "assert", "new", "enum", "true", "false"};

        public KenyaScanner() {
            this.initialize();
        }

        public final int getLength() {
            return this.charsRead - this.currentTokenStartPosition;
        }

        void initialize() {
            this.fgKeys = new Hashtable();
            Integer k = new Integer(2);
            for (int i = 0; i < this.fgKeywords.length; ++i) {
                this.fgKeys.put(this.fgKeywords[i], k);
            }
            Integer o = new Integer(8);
            for (int i = 0; i < this.fgOperators.length; ++i) {
                this.fgKeys.put(this.fgOperators[i], o);
            }
        }

        public final int getStartOffset() {
            return this.currentTokenStartPosition;
        }

        public int nextToken(int lineOffset) {
            int preReadCount = 0;
            this.currentTokenStartPosition = this.charsRead;
            if (this.currentTokenStartPosition == 0 && KenyaLineStyler.this.inBlockComment(lineOffset, lineOffset)) {
                int d = this.read();
                if (d == -1) {
                    return -1;
                }
                while (d != 47 && d != 42 && d != 10 && d != -1) {
                    d = this.read();
                    ++preReadCount;
                }
                this.unread(d);
                if (d == 10 || d == -1) {
                    return 3;
                }
            }
            int c = this.read();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 60: {
                    int depth = 1;
                    ArrayList<Integer> reads = new ArrayList<Integer>();
                    while (true) {
                        c = this.read();
                        reads.add(new Integer(c));
                        if (c == 62) {
                            if (--depth != 0) continue;
                            return 9;
                        }
                        if (c == 10 || c == -1) {
                            this.unreadBuffer(reads);
                            return 6;
                        }
                        if (!(c == 32 || c == 44 || c == 95 || c == 60 || c == 62 || c == 91 || c == 93 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122)) {
                            this.unreadBuffer(reads);
                            return 6;
                        }
                        if (c != 60) continue;
                        ++depth;
                    }
                }
                case 47: {
                    c = this.read();
                    if (c == 47) {
                        while ((c = this.read()) != -1 && c != 10) {
                        }
                        this.unread(c);
                        return 3;
                    }
                    if (c == 42) {
                        for (int idx = 0; idx < KenyaLineStyler.this.blockComments.size(); ++idx) {
                            Point p = (Point)KenyaLineStyler.this.blockComments.get(idx);
                            if (p.x != this.currentTokenStartPosition + lineOffset) continue;
                            int target = p.y;
                            int count = 2;
                            while (this.currentTokenStartPosition + lineOffset + count <= target && c != 10 && c != -1) {
                                c = this.read();
                                ++count;
                            }
                            return 3;
                        }
                        this.unread(c);
                    } else {
                        this.unread(c);
                    }
                    return 6;
                }
                case 42: {
                    c = this.read();
                    if (c == 47) {
                        for (int idx = 0; idx < KenyaLineStyler.this.blockComments.size(); ++idx) {
                            Point p = (Point)KenyaLineStyler.this.blockComments.get(idx);
                            if (p.y != this.currentTokenStartPosition + lineOffset + preReadCount + 2) continue;
                            return 3;
                        }
                        this.unread(c);
                    } else {
                        this.unread(c);
                    }
                    return 6;
                }
                case 39: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 39: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                            }
                        }
                    }
                }
                case 34: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 34: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                            }
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(c = this.read()))) {
                    }
                    this.unread(c);
                    return 7;
                }
            }
            if (Character.isWhitespace((char)c)) {
                while (Character.isWhitespace((char)(c = this.read()))) {
                }
                this.unread(c);
                return 1;
            }
            if (this.isKenyaIdentifierStart((char)c)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while (this.isKenyaIdentifierPart((char)(c = this.read())));
                this.unread(c);
                if (c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95) {
                    return 6;
                }
                Integer i = (Integer)this.fgKeys.get(this.fBuffer.toString());
                if (i != null) {
                    return i;
                }
                return 0;
            }
            return 6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isKenyaIdentifierStart(char c) {
            Map map = this.fgKeys;
            synchronized (map) {
                Iterator it = this.fgKeys.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!key.startsWith("" + c)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isKenyaIdentifierPart(char c) {
            Map map = this.fgKeys;
            synchronized (map) {
                Iterator it = this.fgKeys.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (key.indexOf(c) == -1) continue;
                    return true;
                }
            }
            return false;
        }

        protected int read() {
            try {
                if (this.reader.ready()) {
                    ++this.charsRead;
                    return this.reader.read();
                }
            }
            catch (IOException e) {
                return -1;
            }
            return -1;
        }

        public void setRange(String text) {
            this.reader = new VariablePushbackReader(new StringReader(text));
            this.charsRead = 0;
            this.currentTokenStartPosition = 0;
            this.length = text.length();
        }

        protected void unread(int c) {
            if (c != -1) {
                this.reader.unread(c);
            }
            --this.charsRead;
            if (this.charsRead < 0) {
                System.err.println("CharsRead goes -ve (" + this.charsRead + ") when unreading " + c);
            }
        }

        protected void unreadBuffer(List buff) {
            for (int idx = buff.size() - 1; idx >= 0; --idx) {
                this.unread((Integer)buff.get(idx));
            }
        }
    }
}

