/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import kenya.gui.editor.EditingWindow;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;

public class KenyaTableSelectionChangedListener
implements ISelectionChangedListener {
    private final EditingWindow window;

    public KenyaTableSelectionChangedListener(EditingWindow w) {
        this.window = w;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISourceCodeLocation location;
        StyledText text = this.window.getKenyaTextWidget();
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() != null && (location = ((ISourceCodeInformation)selection.getFirstElement()).getLocation()).getLineNumber() > 0) {
            int offset = text.getOffsetAtLine(location.getLineNumber() - 1);
            text.setCaretOffset(offset += location.getColumnNumber() - 1);
            int length = location.getTokenLength();
            if (offset + length < text.getCharCount()) {
                text.setSelectionRange(offset, length);
                text.showSelection();
            }
            this.window.getHighlightingManager().showLinkedHighlights(offset + 1);
        }
        text.setFocus();
    }
}

