/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;

public class StdOutWriter
extends AbstractJob {
    private static final int MAXBUFFERSIZE = 64;
    private final BufferedReader reader;
    private final StyledText text;
    private static final int EOF = -1;
    private final StringBuffer line = new StringBuffer();
    private final int color;
    private final Runnable runner;

    public StdOutWriter(Reader r, StyledText t, int c) {
        this.reader = new BufferedReader(r);
        this.text = t;
        this.color = c;
        this.runner = new Runnable(){

            public void run() {
                String appendString = StdOutWriter.this.line.toString();
                if (appendString != null) {
                    StdOutWriter.this.text.append(appendString);
                    StyleRange sr = new StyleRange();
                    sr.start = StdOutWriter.this.text.getCharCount() - appendString.length();
                    sr.length = appendString.length();
                    sr.foreground = StdOutWriter.this.text.getDisplay().getSystemColor(StdOutWriter.this.color);
                    StdOutWriter.this.text.setStyleRange(sr);
                    StdOutWriter.this.text.setCaretOffset(StdOutWriter.this.text.getCharCount());
                    StdOutWriter.this.text.setSelection(StdOutWriter.this.text.getCharCount());
                    StdOutWriter.this.text.showSelection();
                }
            }
        };
    }

    public synchronized void execute() {
        try {
            this.line.setLength(0);
            int c = this.reader.read();
            while (c != -1) {
                this.line.append((char)c);
                if (!this.reader.ready() || this.line.length() >= 64) {
                    this.text.getDisplay().syncExec(this.runner);
                    this.line.setLength(0);
                }
                c = this.reader.read();
            }
        }
        catch (IOException e) {
            System.err.println("IO error when reading");
            e.printStackTrace();
        }
    }
}

