/*
 * Decompiled with CFR 0.152.
 */
package kenya.gui.editor.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import kenya.errors.KenyaInternalError;
import kenya.gui.editor.EditingWindow;
import kenya.gui.editor.FileLoaderSaver;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.TabFolder;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;

public class TabSelectionAdapter
extends SelectionAdapter {
    private static final String noTranslation = "Kenya code contains errors, can not translate to Java.";
    private static final String noInterpretation = "Kenya code contains errors, can not debug.";
    private final EditingWindow window;
    private String oldJavaText = null;
    private String oldInterpreterText = null;
    private String lineDelimiter = null;
    private StringBuffer javaBuffer = new StringBuffer();

    public TabSelectionAdapter(EditingWindow w) {
        this.window = w;
    }

    public void widgetSelected(SelectionEvent e) {
        block38: {
            TabFolder topTabs = this.window.getTopTabs();
            int index = topTabs.getSelectionIndex();
            if (index == 0) {
                if (this.window.getStackMachine() != null) {
                    this.window.getInterpreterTerminateButton().notifyListeners(13, null);
                }
                if (this.window.getJavaCode() != null) {
                    this.window.getJavaTerminateButton().notifyListeners(13, null);
                }
                return;
            }
            if (index == 1) {
                if (this.window.getStackMachine() != null) {
                    this.window.getInterpreterTerminateButton().notifyListeners(13, null);
                }
            } else if (index == 2 && this.window.getJavaCode() != null) {
                this.window.getJavaTerminateButton().notifyListeners(13, null);
            }
            StyledText kenyaText = this.window.getKenyaTextWidget();
            StyledText javaText = this.window.getJavaTextWidget();
            StyledText interpreterText = this.window.getInterpreterTextWidget();
            if (javaText == null || kenyaText == null) {
                return;
            }
            if (this.lineDelimiter == null) {
                this.lineDelimiter = javaText.getLineDelimiter();
            }
            String text = kenyaText.getText();
            if (this.oldInterpreterText == null || !text.equals(this.oldInterpreterText) || this.oldJavaText == null || !text.equals(this.oldJavaText)) {
                try {
                    ICheckedCode checkedCode = Mediator.check(new StringReader(text));
                    this.window.setKenyaCheckedCode(checkedCode);
                    if (index == 1) {
                        if (this.oldJavaText != null && text.equals(this.oldJavaText)) break block38;
                        if (this.window.isJavaRunning()) {
                            return;
                        }
                        try {
                            Button javaExecuteButton = this.window.getJavaExecuteButton();
                            javaExecuteButton.setText("E&xecute Java");
                            if (checkedCode.isErroredCode()) {
                                javaText.setText(noTranslation);
                                this.window.getJavaLineStyler().parseBlockComments(noTranslation);
                                this.window.rebuildJavaNumbers();
                                this.window.setJavaCode(null);
                                this.window.setJavaClassName(null);
                                javaExecuteButton.setEnabled(false);
                            } else {
                                this.window.setJavaCode(checkedCode.translate());
                                javaText.setRedraw(false);
                                StyledTextContent content = javaText.getContent();
                                content.setText("");
                                BufferedReader javaReader = null;
                                FileLoaderSaver fls = this.window.getKenyaFile();
                                boolean getPlaceHeld = false;
                                String name = null;
                                IJavaCode code = this.window.getJavaCode();
                                if (fls == null || fls.getName() == null || fls.getName().length() == 0) {
                                    if (code.isValidClassName(this.window.getJavaDefaultClassName())) {
                                        name = this.window.getJavaDefaultClassName();
                                    } else {
                                        getPlaceHeld = true;
                                    }
                                } else {
                                    String fileName = fls.getName();
                                    if (fileName.endsWith(".k")) {
                                        fileName = fileName.substring(0, fileName.length() - 2);
                                    }
                                    if (fileName.length() > 1) {
                                        char prefix = fileName.charAt(0);
                                        fileName = new String("" + prefix).toUpperCase() + fileName.substring(1);
                                    }
                                    if (code.isValidClassName(fileName)) {
                                        name = fileName;
                                    } else if (code.isValidClassName(this.window.getJavaDefaultClassName())) {
                                        name = this.window.getJavaDefaultClassName();
                                    } else {
                                        getPlaceHeld = true;
                                    }
                                }
                                if (getPlaceHeld) {
                                    this.window.setJavaClassName(null);
                                    javaReader = new BufferedReader(code.getPlaceHeldCode());
                                    javaExecuteButton.setEnabled(false);
                                } else {
                                    this.window.setJavaClassName(name);
                                    javaReader = new BufferedReader(code.getCode(name));
                                    javaExecuteButton.setEnabled(true);
                                }
                                this.javaBuffer.setLength(0);
                                String line = javaReader.readLine();
                                while (line != null) {
                                    this.javaBuffer.append(line);
                                    this.javaBuffer.append(this.lineDelimiter);
                                    line = javaReader.readLine();
                                }
                                javaReader.close();
                                content.setText(this.javaBuffer.toString());
                                this.window.getJavaLineStyler().parseBlockComments(this.javaBuffer.toString());
                                this.window.rebuildJavaNumbers();
                                javaText.setRedraw(true);
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        this.oldJavaText = text;
                        break block38;
                    }
                    if (index != 2) break block38;
                    if (this.window.getStackMachine() != null) {
                        return;
                    }
                    if (this.oldInterpreterText != null && text.equals(this.oldInterpreterText)) break block38;
                    this.window.getInterpreterContinueButton().setEnabled(false);
                    if (checkedCode.isErroredCode()) {
                        interpreterText.setText(noInterpretation);
                        this.window.rebuildInterpreterNumbers();
                        this.window.getInterpreterInterpretButton().setEnabled(false);
                        this.window.getInterpreterStepModeButton().setEnabled(false);
                    } else {
                        interpreterText.setRedraw(false);
                        interpreterText.setText(kenyaText.getText());
                        this.window.rebuildInterpreterNumbers();
                        IStackMachineInformationProvider ismip = checkedCode.getBaseStackMachine();
                        this.window.setBaseStackMachine(ismip);
                        this.window.getCarrotPainter().clear();
                        interpreterText.setRedraw(true);
                        this.window.getInterpreterInterpretButton().setEnabled(true);
                        this.window.getInterpreterStepModeButton().setEnabled(true);
                        StackMachine sm = this.window.getStackMachine();
                        if (sm != null) {
                            sm.shutdown();
                            this.window.setStackMachine(null);
                        }
                        sm = new StackMachine();
                        this.window.getInterpreterStdOutText().setText("");
                        try {
                            ClosureScope scope = new ClosureScope();
                            ClosureMiscHelper.executeClosureInScope(scope, ismip.getPreInitClosure(), sm);
                        }
                        catch (Throwable t) {
                            this.window.getInterpreterStdOutText().append("" + t);
                            this.window.getInterpreterInterpretButton().setEnabled(false);
                            this.window.getInterpreterStepModeButton().setEnabled(false);
                        }
                    }
                    this.oldInterpreterText = text;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (KenyaInternalError e2) {
                    System.err.println("SM compilation failed: ");
                    e2.printStackTrace(System.err);
                }
            }
        }
    }
}

