/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import kenya.builtIns.SMLibraryContainer;
import kenya.errors.KenyaBadLocationError;
import kenya.errors.KenyaInternalError;
import kenya.errors.KenyaPreconditionError;
import kenya.passes.RestrictedStackMachineBuilder;
import kenya.passes.SwitchHelper;
import kenya.passes.Util;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import kenya.types.KBasicType;
import kenya.types.KFunction;
import kenya.types.tables.VariableLookupTable;
import mediator.stackMachine.IStackMachineInformationManager;
import mediator.util.AVariableInstance;
import mediator.util.InformationHolder;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.AArrayAccess;
import minijava.node.AArrayAllocate;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AArrayFieldAccess;
import minijava.node.AArrayInit;
import minijava.node.AArrayInitList;
import minijava.node.AAssertStatement;
import minijava.node.AAssignment;
import minijava.node.AAssignmentStatement;
import minijava.node.ABlock;
import minijava.node.ABooleanBasicType;
import minijava.node.ABreakStatement;
import minijava.node.ACasePossibleCase;
import minijava.node.ACharBasicType;
import minijava.node.ACharliteralFactor;
import minijava.node.AClassDecDeclaration;
import minijava.node.AClassTypeReferenceType;
import minijava.node.AColonString;
import minijava.node.ACommaArrayInit;
import minijava.node.ACommaEnumList;
import minijava.node.ACommaExp;
import minijava.node.ACommaType;
import minijava.node.ACommaTypeName;
import minijava.node.AConstDecDeclaration;
import minijava.node.ADNumber;
import minijava.node.ADefaultPossibleCase;
import minijava.node.ADivTerm;
import minijava.node.ADoubleBasicType;
import minijava.node.ADynamicArrayInitialiser;
import minijava.node.AElsePart;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AEqEquality;
import minijava.node.AExpressionFactor;
import minijava.node.AFalseBooleanliteral;
import minijava.node.AForStatement;
import minijava.node.AFormalParamList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AFunctionApplication;
import minijava.node.AFunctioncallForRightStat;
import minijava.node.AFunctioncallStatement;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.AINumber;
import minijava.node.AIfStat;
import minijava.node.AInitialiser;
import minijava.node.AIntBasicType;
import minijava.node.AJavaForControl;
import minijava.node.AListActualParamList;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMinusMathExpression;
import minijava.node.AMinusUnaryExp;
import minijava.node.AModTerm;
import minijava.node.AMultTerm;
import minijava.node.ANegateUnaryExp;
import minijava.node.ANeqEquality;
import minijava.node.ANullFactor;
import minijava.node.AOrBoolExpression;
import minijava.node.APlusMathExpression;
import minijava.node.APlusUnaryExp;
import minijava.node.APostdecr;
import minijava.node.APostincr;
import minijava.node.APredecr;
import minijava.node.APreincr;
import minijava.node.AQualifiedName;
import minijava.node.AReturnStatement;
import minijava.node.AScalarFieldAccess;
import minijava.node.AScalarInitList;
import minijava.node.ASimpleName;
import minijava.node.ASimpleNameName;
import minijava.node.AStaticArrayInitialiser;
import minijava.node.AStringBasicType;
import minijava.node.AStringliteralFactor;
import minijava.node.ASwitchBlock;
import minijava.node.ASwitchStatement;
import minijava.node.ATrueBooleanliteral;
import minijava.node.ATypeName;
import minijava.node.ATypeParam;
import minijava.node.ATypeParamList;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.AVoidBasicType;
import minijava.node.AWhileStatement;
import minijava.node.AXorBoolExpression;
import minijava.node.Node;
import minijava.node.PArrayAccess;
import minijava.node.PClassInnerDeclaration;
import minijava.node.PCommaArrayInit;
import minijava.node.PCommaExp;
import minijava.node.PPossibleCase;
import minijava.node.TAnd;
import minijava.node.TAssert;
import minijava.node.TAssign;
import minijava.node.TBlank;
import minijava.node.TBoolean;
import minijava.node.TBracketPair;
import minijava.node.TBreak;
import minijava.node.TCase;
import minijava.node.TChar;
import minijava.node.TCharliteral;
import minijava.node.TColon;
import minijava.node.TComma;
import minijava.node.TComment;
import minijava.node.TConst;
import minijava.node.TDefault;
import minijava.node.TDivide;
import minijava.node.TDot;
import minijava.node.TDouble;
import minijava.node.TDpnumber;
import minijava.node.TElse;
import minijava.node.TEnum;
import minijava.node.TEqual;
import minijava.node.TFalse;
import minijava.node.TFor;
import minijava.node.TGreater;
import minijava.node.TGreaterequal;
import minijava.node.TIdentifier;
import minijava.node.TIf;
import minijava.node.TInt;
import minijava.node.TIntnumber;
import minijava.node.TKlass;
import minijava.node.TLBrace;
import minijava.node.TLBracket;
import minijava.node.TLParenthese;
import minijava.node.TLess;
import minijava.node.TLessequal;
import minijava.node.TMinus;
import minijava.node.TMinusminus;
import minijava.node.TMod;
import minijava.node.TNew;
import minijava.node.TNewLine;
import minijava.node.TNot;
import minijava.node.TNotequal;
import minijava.node.TNull;
import minijava.node.TOr;
import minijava.node.TPlus;
import minijava.node.TPlusplus;
import minijava.node.TRBrace;
import minijava.node.TRBracket;
import minijava.node.TRParenthese;
import minijava.node.TReservedWord;
import minijava.node.TReturn;
import minijava.node.TSemicolon;
import minijava.node.TString;
import minijava.node.TStringliteral;
import minijava.node.TSwitch;
import minijava.node.TTimes;
import minijava.node.TTraditionalComment;
import minijava.node.TTrue;
import minijava.node.TVoid;
import minijava.node.TWhile;
import minijava.node.TXor;
import minijava.node.Token;
import org.wellquite.kenya.stackMachine.InterpretedBuildableClosure;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.ops.ArrayOpsFactory;
import org.wellquite.kenya.stackMachine.ops.ControlFlowOpsFactory;
import org.wellquite.kenya.stackMachine.ops.LogicalOpsFactory;
import org.wellquite.kenya.stackMachine.ops.NumericOpsFactory;
import org.wellquite.kenya.stackMachine.ops.PrimitiveTypeConversionOpsFactory;
import org.wellquite.kenya.stackMachine.ops.StackOpsFactory;
import org.wellquite.kenya.stackMachine.ops.StringOpsFactory;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.ClassTypeFactory;
import org.wellquite.kenya.stackMachine.types.EnumTypeFactory;
import org.wellquite.kenya.stackMachine.types.NullTypeFactory;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IBuildableClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class StackMachineBuilder
extends DepthFirstAdapter {
    private IBuildableClosure _cClosure;
    private IBuildableClosure _methodClosure;
    private IFunction _cFunction;
    private IInterpretedClass _cClass;
    private IClass _cIClass;
    private IBuildableClosure _breakClosure;
    private VariableLookupTable _variableTable;
    private VariableLookupTable _stackVariableTable;
    private final IInterpretedClass _gloClass;
    private final IStackMachineInformationManager _stackInfoManager;
    private final InformationHolder _informationHolder;
    private boolean _doAssig;
    private boolean _doMarkers;
    private SwitchHelper _switchHelper;

    public StackMachineBuilder(IStackMachineInformationManager isim, InformationHolder ih, boolean doMarkers) {
        this._stackInfoManager = isim;
        this._informationHolder = ih;
        this._gloClass = isim.getGlobalClassBody();
        this._doAssig = false;
        this._doMarkers = doMarkers;
        this._stackVariableTable = null;
        this._variableTable = null;
    }

    StackMachineBuilder(IStackMachineInformationManager isim, InformationHolder ih, boolean doMarkers, IBuildableClosure cClosure, IClass cIClass) {
        this(isim, ih, doMarkers);
        this._cClosure = cClosure;
        this._cIClass = cIClass;
    }

    void setVariableLookupTable(VariableLookupTable vlt) {
        this._variableTable = vlt;
    }

    private IClass getNodeType(Node node) {
        IClass nameType = this._cFunction != null ? this._informationHolder.getTypeFromNode(node, this._cFunction.getTypeParams()) : (this._cIClass != null ? this._informationHolder.getTypeFromNode(node, this._cIClass.getTemplateParams()) : this._informationHolder.getTypeFromNode(node, new IClass[0]));
        return nameType;
    }

    private void checkCast(Node node) {
        IClass type = this.getNodeType(node);
        if (type.getName().equals("char")) {
            this._cClosure.addClosure(PrimitiveTypeConversionOpsFactory.toChar());
        } else if (type.getName().equals("int")) {
            this._cClosure.addClosure(PrimitiveTypeConversionOpsFactory.toInt());
        } else if (type.getName().equals("double")) {
            this._cClosure.addClosure(PrimitiveTypeConversionOpsFactory.toDouble());
        }
    }

    private void doMarker(Token t) {
        if (this._cClosure == null || !this._doMarkers) {
            return;
        }
        this._cClosure.addClosure(StackOpsFactory.positionReached(new SourceCodeLocation(t.getLine(), t.getPos(), t.getText().trim().length())));
        this._stackInfoManager.addCodePoint(new SourceCodeLocation(t.getLine(), t.getPos(), t.getText().trim().length()));
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        this.inAClassDecDeclaration(node);
        String ident = node.getIdentifier().getText().trim();
        this._cClosure = null;
        IClass thisClass = this._informationHolder.getTypeFromName(ident);
        this._cClass = this._stackInfoManager.getClassBody(thisClass);
        this._variableTable = new VariableLookupTable(thisClass.getDeclarations());
        this._variableTable.push();
        this._cIClass = thisClass;
        Object[] temp = node.getClassInnerDeclaration().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PClassInnerDeclaration)temp[i]).apply(this);
        }
        this._cClass = null;
        this._cIClass = null;
        this.outAClassDecDeclaration(node);
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
    }

    public void caseAEnumList(AEnumList node) {
        throw KenyaBadLocationError.get();
    }

    public void caseACommaEnumList(ACommaEnumList node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        this.inAFuncDecDeclaration(node);
        this._methodClosure = this._cClosure = new InterpretedBuildableClosure();
        this._cClosure.addClosure(StackOpsFactory.startNewVariableScope());
        IFunction theFunc = this._stackInfoManager.getFunctionFromNode(node);
        this._variableTable = new VariableLookupTable(this._informationHolder.getConstants());
        this._cFunction = theFunc;
        IInterpretedMethod method = this._stackInfoManager.getMethodBody(theFunc);
        this._variableTable.push();
        for (int i = 0; i < theFunc.getArguments().length; ++i) {
            this._variableTable.add(theFunc.getArguments()[i]);
            String smName = this._stackInfoManager.addNewVariable(theFunc.getArguments()[i]);
            this._cClosure.addClosure(StackOpsFactory.storeNewVariable(smName, true));
        }
        node.getBlock().apply(this);
        this._variableTable = null;
        this._cClosure.addClosure(StackOpsFactory.endNewVariableScope());
        method.setMethodBody(this._methodClosure);
        this._cClosure = null;
        this._cFunction = null;
        this._methodClosure = null;
        this.outAFuncDecDeclaration(node);
    }

    public void caseAFormalParamList(AFormalParamList node) {
        throw new KenyaInternalError("Shouldn't be in here");
    }

    public void caseATypeName(ATypeName node) {
        throw new KenyaInternalError("Shouldn't be in here");
    }

    public void caseACommaTypeName(ACommaTypeName node) {
        throw new KenyaInternalError("Shouldn't be in here");
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        this.inAConstDecDeclaration(node);
        this._variableTable = new VariableLookupTable(this._informationHolder.getConstants());
        this._cClosure = new InterpretedBuildableClosure();
        RestrictedStackMachineBuilder.doClassVariable(this._gloClass, this._stackInfoManager.getPreInitClosure(), node, this._stackInfoManager, this._informationHolder, this._cIClass);
        this._variableTable = null;
        this.outAConstDecDeclaration(node);
    }

    public void caseAFunctioncallStatement(AFunctioncallStatement node) {
        KFunction kf;
        this.inAFunctioncallStatement(node);
        if (node.getFunctionApplication() != null) {
            node.getFunctionApplication().apply(this);
        }
        if ((kf = this._informationHolder.getFunction((AFunctionApplication)node.getFunctionApplication())).getReturnType() != KBasicType.getVoid()) {
            this._cClosure.addClosure(StackOpsFactory.pop());
        }
        this.outAFunctioncallStatement(node);
    }

    public void caseAFunctioncallForRightStat(AFunctioncallForRightStat node) {
        this.inAFunctioncallForRightStat(node);
        node.getFunctionApplication().apply(this);
        KFunction kf = this._informationHolder.getFunction((AFunctionApplication)node.getFunctionApplication());
        if (kf.getReturnType() != KBasicType.getVoid()) {
            this._cClosure.addClosure(StackOpsFactory.pop());
        }
        this.outAFunctioncallForRightStat(node);
    }

    public void caseAAssignmentStatement(AAssignmentStatement node) {
        this.inAAssignmentStatement(node);
        node.getAssignment().apply(this);
        this.outAAssignmentStatement(node);
    }

    public void caseAAssignment(AAssignment node) {
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.checkCast(node);
        if (node.getAssign() != null) {
            node.getAssign().apply(this);
        }
        boolean tmpDoAssig = this._doAssig;
        this._doAssig = true;
        if (node.getFieldAccess() != null) {
            node.getFieldAccess().apply(this);
        }
        this._doAssig = tmpDoAssig;
    }

    public void caseAWhileStatement(AWhileStatement node) {
        this.inAWhileStatement(node);
        IBuildableClosure tmpBreak = this._breakClosure;
        node.getWhile().apply(this);
        IBuildableClosure globalClosure = this._cClosure;
        InterpretedBuildableClosure whileCond = new InterpretedBuildableClosure();
        this._cClosure = whileCond;
        node.getBoolExpression().apply(this);
        InterpretedBuildableClosure body = new InterpretedBuildableClosure();
        this._cClosure = body;
        this._breakClosure = new InterpretedBuildableClosure();
        node.getBlock().apply(this);
        this._breakClosure.addClosure(ControlFlowOpsFactory.whileClosure(whileCond, body));
        globalClosure.addClosure(this._breakClosure);
        this._breakClosure = tmpBreak;
        this._cClosure = globalClosure;
        this.outAWhileStatement(node);
    }

    public void caseAReturnStatement(AReturnStatement node) {
        this.inAReturnStatement(node);
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        node.getReturn().apply(this);
        this.checkCast(node);
        this._cClosure.addClosure(this._methodClosure.returnFromThisClosure());
        this.outAReturnStatement(node);
    }

    public void caseASwitchStatement(ASwitchStatement node) {
        this.inASwitchStatement(node);
        SwitchHelper tmpSwitchHelper = this._switchHelper;
        this._switchHelper = new SwitchHelper();
        IBuildableClosure tmpBreak = this._breakClosure;
        if (node.getSwitch() != null) {
            node.getSwitch().apply(this);
        }
        IBuildableClosure globalClosure = this._cClosure;
        this._breakClosure = new InterpretedBuildableClosure();
        this._cClosure = new InterpretedBuildableClosure();
        node.getBoolExpression().apply(this);
        this._switchHelper.setCond(this._cClosure);
        this._cClosure = null;
        if (node.getSwitchBlock() != null) {
            node.getSwitchBlock().apply(this);
        }
        this._breakClosure.addClosure(this._switchHelper.getSwitchClosure());
        globalClosure.addClosure(this._breakClosure);
        this._breakClosure = tmpBreak;
        this._switchHelper = tmpSwitchHelper;
        this._cClosure = globalClosure;
        this.outASwitchStatement(node);
    }

    public void caseASwitchBlock(ASwitchBlock node) {
        this.inASwitchBlock(node);
        Object[] temp = node.getPossibleCase().toArray();
        this._switchHelper.initArrays(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            ((PPossibleCase)temp[i]).apply(this);
        }
        this.outASwitchBlock(node);
    }

    public void caseACasePossibleCase(ACasePossibleCase node) {
        this.inACasePossibleCase(node);
        if (this._cClosure != null) {
            throw KenyaPreconditionError.get();
        }
        boolean tmpMarkers = this._doMarkers;
        this._doMarkers = false;
        InterpretedBuildableClosure cond = new InterpretedBuildableClosure();
        InterpretedBuildableClosure code = new InterpretedBuildableClosure();
        this._cClosure = cond;
        node.getBoolExpression().apply(this);
        this._doMarkers = tmpMarkers;
        this._cClosure = code;
        node.getCase().apply(this);
        node.getBlock().apply(this);
        this._switchHelper.setNextCase(cond, code);
        this._cClosure = null;
        this.outACasePossibleCase(node);
    }

    public void caseADefaultPossibleCase(ADefaultPossibleCase node) {
        this.inADefaultPossibleCase(node);
        if (this._cClosure != null) {
            throw KenyaPreconditionError.get();
        }
        InterpretedBuildableClosure code = new InterpretedBuildableClosure();
        this._cClosure = code;
        node.getDefault().apply(this);
        node.getBlock().apply(this);
        this._switchHelper.setNextCase(null, code);
        this._cClosure = null;
        this.outADefaultPossibleCase(node);
    }

    public void caseAForStatement(AForStatement node) {
        this.inAForStatement(node);
        node.getFor().apply(this);
        this._cClosure.addClosure(StackOpsFactory.startNewVariableScope());
        this._variableTable.push();
        IBuildableClosure stackedClosure = this._cClosure;
        this._cClosure = new InterpretedBuildableClosure();
        node.getForControl().apply(this);
        this._cClosure.addClosure(StackOpsFactory.endNewVariableScope());
        stackedClosure.addClosure(this._cClosure);
        this._cClosure = stackedClosure;
        this._variableTable.pop();
        this.outAForStatement(node);
    }

    public void caseAJavaForControl(AJavaForControl node) {
        this.inAJavaForControl(node);
        node.getForLeftStat().apply(this);
        IBuildableClosure tmpBreak = this._breakClosure;
        this._breakClosure = new InterpretedBuildableClosure();
        IBuildableClosure globalClosure = this._cClosure;
        InterpretedBuildableClosure cond = new InterpretedBuildableClosure();
        this._cClosure = cond;
        node.getBoolExpression().apply(this);
        InterpretedBuildableClosure blockPart = new InterpretedBuildableClosure();
        this._cClosure = blockPart;
        ((AForStatement)node.parent()).getBlock().apply(this);
        if (node.getForRightStat() != null) {
            node.getForRightStat().apply(this);
        }
        this._breakClosure.addClosure(ControlFlowOpsFactory.whileClosure(cond, blockPart));
        globalClosure.addClosure(this._breakClosure);
        this._cClosure = globalClosure;
        this._breakClosure = tmpBreak;
        this.outAJavaForControl(node);
    }

    public void caseABreakStatement(ABreakStatement node) {
        this.inABreakStatement(node);
        node.getBreak().apply(this);
        this._cClosure.addClosure(this._breakClosure.returnFromThisClosure());
        this.outABreakStatement(node);
    }

    public void caseAAssertStatement(AAssertStatement node) {
        this.inAAssertStatement(node);
        node.getAssert().apply(this);
        IBuildableClosure globalClosure = this._cClosure;
        InterpretedBuildableClosure cond = new InterpretedBuildableClosure();
        this._cClosure = cond;
        node.getBoolExpression().apply(this);
        InterpretedBuildableClosure failure = new InterpretedBuildableClosure();
        this._cClosure = failure;
        if (node.getColonString() != null) {
            node.getColonString().apply(this);
        }
        AbstractAtomicClosure assertionFail = node.getColonString() != null ? new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                throw new AssertionError(sm.pop());
            }
        } : new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                throw new AssertionError();
            }
        };
        failure.addClosure(assertionFail);
        globalClosure.addClosure(ControlFlowOpsFactory.ifClosure(cond, null, failure));
        this._cClosure = globalClosure;
        this.outAAssertStatement(node);
    }

    public void caseAColonString(AColonString node) {
        this.inAColonString(node);
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.outAColonString(node);
    }

    public void caseAIfStat(AIfStat node) {
        this.inAIfStat(node);
        node.getIf().apply(this);
        IBuildableClosure globalClosure = this._cClosure;
        InterpretedBuildableClosure ifPart = new InterpretedBuildableClosure();
        this._cClosure = ifPart;
        node.getBoolExpression().apply(this);
        InterpretedBuildableClosure lhs = new InterpretedBuildableClosure();
        this._cClosure = lhs;
        node.getBlock1().apply(this);
        InterpretedBuildableClosure rhs = null;
        if (node.getElsePart() != null) {
            rhs = new InterpretedBuildableClosure();
            this._cClosure = rhs;
            node.getElsePart().apply(this);
        }
        globalClosure.addClosure(ControlFlowOpsFactory.ifClosure(ifPart, lhs, rhs));
        this._cClosure = globalClosure;
        this.outAIfStat(node);
    }

    public void caseAElsePart(AElsePart node) {
        this.inAElsePart(node);
        node.getElseFollow().apply(this);
        this.outAElsePart(node);
    }

    public void caseABlock(ABlock node) {
        this.inABlock(node);
        node.getLBrace().apply(this);
        this._variableTable.push();
        IBuildableClosure stackedClosure = this._cClosure;
        this._cClosure = new InterpretedBuildableClosure();
        this._cClosure.addClosure(StackOpsFactory.startNewVariableScope());
        node.getStatements().apply(this);
        node.getRBrace().apply(this);
        this._cClosure.addClosure(StackOpsFactory.endNewVariableScope());
        stackedClosure.addClosure(this._cClosure);
        this._cClosure = stackedClosure;
        this._variableTable.pop();
        this.outABlock(node);
    }

    public void caseAFunctionApplication(AFunctionApplication node) {
        this.inAFunctionApplication(node);
        if (node.getActualParamList() != null) {
            node.getActualParamList().apply(this);
        }
        ((ASimpleName)((ASimpleNameName)node.getName()).getSimpleName()).getIdentifier().apply(this);
        KFunction thisFunc = this._informationHolder.getFunction(node);
        int numArgs = thisFunc.getArgs().size();
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(numArgs));
        if (thisFunc.isBuiltin()) {
            this._cClosure.addClosure(SMLibraryContainer.getLibrary().invokeBuiltInMethod(thisFunc.getBuiltinMethod().getInterpretedMethod()));
        } else {
            IFunction invokeF = this._stackInfoManager.getFunctionFromNode(thisFunc.getNode());
            String smFN = this._stackInfoManager.lookupFunction(invokeF);
            this._cClosure.addClosure(StackOpsFactory.invokeLocalMethod(smFN));
        }
        final boolean hasRet = thisFunc.getReturnType() != KBasicType.getVoid();
        final int size = thisFunc.getArgs().size();
        this._cClosure.addClosure(new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IType temp = null;
                if (hasRet) {
                    temp = sm.pop();
                }
                for (int i = 0; i < size; ++i) {
                    sm.pop();
                }
                if (hasRet) {
                    sm.push(temp);
                }
            }
        });
        this.checkCast(node);
        this.outAFunctionApplication(node);
    }

    public void caseAListActualParamList(AListActualParamList node) {
        this.inAListActualParamList(node);
        if (node.getActualParamList() != null) {
            node.getActualParamList().apply(this);
        }
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.outAListActualParamList(node);
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        this.inAVarDecInnerDeclaration(node);
        if (this._cIClass != null) {
            RestrictedStackMachineBuilder.doClassVariable(this._cClass, this._stackInfoManager.getPreInitClosure(), node, this._stackInfoManager, this._informationHolder, this._cIClass);
            this.outAVarDecInnerDeclaration(node);
            return;
        }
        node.getIdentifier().apply(this);
        String origName = node.getIdentifier().getText().trim();
        if (this._cFunction == null) {
            throw KenyaPreconditionError.get();
        }
        int[] pos = Util.getFirstIdent(node.getIdentifier());
        IClass[] tyParams = this._cFunction.getTypeParams();
        IClass type = this._informationHolder.getTypeFromNode(node, tyParams);
        AVariableInstance var = new AVariableInstance(origName, new SourceCodeLocation(pos[0], pos[1], pos[2]), type);
        if (node.getInitialiser() != null) {
            node.getInitialiser().apply(this);
        } else {
            final IClass type2 = var.getType();
            if (type2.getName().equals("boolean")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
            } else if (type2.getName().equals("char")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('\u0000')));
            } else if (type2.getName().equals("int")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0)));
            } else if (type2.getName().equals("double")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0.0)));
            } else if (type2.getName().equals("Boolean")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
            } else if (type2.getName().equals("Character")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('\u0000')));
            } else if (type2.getName().equals("Integer")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0)));
            } else if (type2.getName().equals("Double")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0.0)));
            } else if (type2.isClass()) {
                final IStackMachineInformationManager isim = this._stackInfoManager;
                this._cClosure.addClosure(new AbstractAtomicClosure(){

                    public void execute(StackMachine sm) {
                        sm.push(ClassTypeFactory.createClassInstanceType(isim.getClassBody(type2).createInstance()));
                    }
                });
            } else if (type2.isEnum() || type2.isArray() || type2.isParam() || type2.getName().equals("String")) {
                this._cClosure.addClosure(StackOpsFactory.push(NullTypeFactory.createNullType()));
            } else {
                throw KenyaPreconditionError.get();
            }
        }
        String smName = this._stackInfoManager.addNewVariable(var);
        this._variableTable.add(var);
        this.checkCast(node);
        this._cClosure.addClosure(StackOpsFactory.storeNewVariable(smName, true));
        this.outAVarDecInnerDeclaration(node);
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        this.inAArrayDecInnerDeclaration(node);
        if (this._cIClass != null) {
            RestrictedStackMachineBuilder.doClassVariable(this._cClass, this._stackInfoManager.getPreInitClosure(), node, this._stackInfoManager, this._informationHolder, this._cIClass);
            this.outAArrayDecInnerDeclaration(node);
            return;
        }
        node.getIdentifier().apply(this);
        String origName = node.getIdentifier().getText().trim();
        if (this._cFunction == null) {
            throw KenyaPreconditionError.get();
        }
        int[] pos = Util.getFirstIdent(node.getIdentifier());
        IClass[] tyParams = this._cFunction.getTypeParams();
        IClass type = this._informationHolder.getTypeFromNode(node, tyParams);
        tyParams = this._cFunction.getTypeParams();
        AVariableInstance var = new AVariableInstance(origName, new SourceCodeLocation(pos[0], pos[1], pos[2]), type);
        if (node.getArrayInitialiser() != null) {
            node.getArrayInitialiser().apply(this);
        } else {
            this._cClosure.addClosure(StackOpsFactory.push(NullTypeFactory.createNullType()));
        }
        String smName = this._stackInfoManager.addNewVariable(var);
        this._variableTable.add(var);
        this._cClosure.addClosure(StackOpsFactory.storeNewVariable(smName, true));
        this.outAArrayDecInnerDeclaration(node);
    }

    public void caseAInitialiser(AInitialiser node) {
        this.inAInitialiser(node);
        if (node.getBoolExpression() != null) {
            node.getBoolExpression().apply(this);
        }
        if (node.getAssign() != null) {
            node.getAssign().apply(this);
        }
        this.outAInitialiser(node);
    }

    public void caseAStaticArrayInitialiser(AStaticArrayInitialiser node) {
        this.inAStaticArrayInitialiser(node);
        if (node.getArrayInit() != null) {
            node.getArrayInit().apply(this);
        }
        if (node.getAssign() != null) {
            node.getAssign().apply(this);
        }
        this.outAStaticArrayInitialiser(node);
    }

    public void caseADynamicArrayInitialiser(ADynamicArrayInitialiser node) {
        this.inADynamicArrayInitialiser(node);
        if (node.getArrayAllocate() != null) {
            node.getArrayAllocate().apply(this);
        }
        if (node.getAssign() != null) {
            node.getAssign().apply(this);
        }
        this.outADynamicArrayInitialiser(node);
    }

    public void caseAArrayInit(AArrayInit node) {
        this.inAArrayInit(node);
        if (node.getInitList() != null) {
            node.getInitList().apply(this);
        }
        this.outAArrayInit(node);
    }

    public void caseAScalarInitList(AScalarInitList node) {
        this.inAScalarInitList(node);
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        Object[] temp = node.getCommaExp().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaExp)temp[i]).apply(this);
        }
        int length = 1 + temp.length;
        this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(length)));
        this._cClosure.addClosure(ArrayOpsFactory.buildArrayWithValues());
        this.outAScalarInitList(node);
    }

    public void caseAArrayInitList(AArrayInitList node) {
        this.inAArrayInitList(node);
        if (node.getArrayInit() != null) {
            node.getArrayInit().apply(this);
        }
        Object[] temp = node.getCommaArrayInit().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaArrayInit)temp[i]).apply(this);
        }
        int length = 1 + temp.length;
        this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(length)));
        this._cClosure.addClosure(ArrayOpsFactory.buildArrayWithValues());
        this.outAArrayInitList(node);
    }

    public void caseACommaExp(ACommaExp node) {
        this.inACommaExp(node);
        if (node.getComma() != null) {
            node.getComma().apply(this);
        }
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
        }
        this.outACommaExp(node);
    }

    public void caseACommaArrayInit(ACommaArrayInit node) {
        this.inACommaArrayInit(node);
        if (node.getComma() != null) {
            node.getComma().apply(this);
        }
        if (node.getArrayInit() != null) {
            node.getArrayInit().apply(this);
        }
        this.outACommaArrayInit(node);
    }

    public void caseATrueBooleanliteral(ATrueBooleanliteral node) {
        this.inATrueBooleanliteral(node);
        node.getTrue().apply(this);
        this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(true)));
        this.outATrueBooleanliteral(node);
    }

    public void caseAFalseBooleanliteral(AFalseBooleanliteral node) {
        this.inAFalseBooleanliteral(node);
        node.getFalse().apply(this);
        this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
        this.outAFalseBooleanliteral(node);
    }

    public void caseAStringliteralFactor(AStringliteralFactor node) {
        this.inAStringliteralFactor(node);
        node.getStringliteral().apply(this);
        String text = node.getStringliteral().getText();
        int start = text.indexOf("\"");
        int end = text.lastIndexOf("\"");
        text = text.substring(start + 1, end);
        this._cClosure.addClosure(StackOpsFactory.push(StringTypeFactory.createStringType(Util.escapeString(text))));
        this.outAStringliteralFactor(node);
    }

    public void caseACharliteralFactor(ACharliteralFactor node) {
        this.inACharliteralFactor(node);
        node.getCharliteral().apply(this);
        char c = Util.parseCharacter(node);
        this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(c)));
        this.outACharliteralFactor(node);
    }

    public void caseACharBasicType(ACharBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAIntBasicType(AIntBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseADoubleBasicType(ADoubleBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAStringBasicType(AStringBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseABooleanBasicType(ABooleanBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAVoidBasicType(AVoidBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAClassTypeReferenceType(AClassTypeReferenceType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseATypeParam(ATypeParam node) {
        throw KenyaBadLocationError.get();
    }

    public void caseATypeParamList(ATypeParamList node) {
        throw KenyaBadLocationError.get();
    }

    public void caseACommaType(ACommaType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAArrayAllocate(AArrayAllocate node) {
        this.inAArrayAllocate(node);
        if (node.getNew() != null) {
            node.getNew().apply(this);
        }
        Object[] temp = node.getArrayAccess().toArray();
        for (int i = 0; i < temp.length; ++i) {
            VariableLookupTable tmp = this._stackVariableTable;
            this._stackVariableTable = null;
            ((PArrayAccess)temp[i]).apply(this);
            this._stackVariableTable = tmp;
        }
        this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(temp.length)));
        if (node.getBracketPair().size() != 0) {
            this._cClosure.addClosure(StackOpsFactory.push(NullTypeFactory.createNullType()));
        } else {
            IClass type = this.getNodeType(node);
            String typeName = type.getName().substring(0, type.getName().indexOf(91));
            if (typeName.equals("boolean")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
            } else if (typeName.equals("char")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('\u0000')));
            } else if (typeName.equals("int")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0)));
            } else if (typeName.equals("double")) {
                this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0.0)));
            } else {
                this._cClosure.addClosure(StackOpsFactory.push(NullTypeFactory.createNullType()));
            }
        }
        this._cClosure.addClosure(ArrayOpsFactory.buildMultidimensionalArray());
        this.outAArrayAllocate(node);
    }

    public void caseAPlusMathExpression(APlusMathExpression node) {
        this.inAPlusMathExpression(node);
        node.getMathExpression().apply(this);
        node.getTerm().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getPlus().apply(this);
        IClass[] typeParams = this._cIClass != null ? this._cIClass.getTemplateParams() : (this._cFunction != null ? this._cFunction.getTypeParams() : new IClass[]{});
        IClass tc = this._informationHolder.getTypeFromNode(node, typeParams);
        if (tc == this._informationHolder.getTypeFromName("String")) {
            this._cClosure.addClosure(StringOpsFactory.concat());
        } else {
            this._cClosure.addClosure(NumericOpsFactory.add());
        }
        this.outAPlusMathExpression(node);
    }

    public void caseAMinusMathExpression(AMinusMathExpression node) {
        this.inAMinusMathExpression(node);
        node.getMathExpression().apply(this);
        node.getTerm().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getMinus().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.subtract());
        this.outAMinusMathExpression(node);
    }

    public void caseAMultTerm(AMultTerm node) {
        this.inAMultTerm(node);
        node.getTerm().apply(this);
        node.getUnaryExp().apply(this);
        node.getTimes().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.multiply());
        this.outAMultTerm(node);
    }

    public void caseADivTerm(ADivTerm node) {
        this.inADivTerm(node);
        node.getTerm().apply(this);
        node.getUnaryExp().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getDivide().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.divide());
        this.outADivTerm(node);
    }

    public void caseAModTerm(AModTerm node) {
        this.inAModTerm(node);
        node.getTerm().apply(this);
        node.getUnaryExp().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getMod().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.modulus());
        this.outAModTerm(node);
    }

    public void caseAMinusUnaryExp(AMinusUnaryExp node) {
        this.inAMinusUnaryExp(node);
        node.getUnaryExp().apply(this);
        node.getMinus().apply(this);
        this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(-1)));
        this._cClosure.addClosure(NumericOpsFactory.multiply());
        this.outAMinusUnaryExp(node);
    }

    public void caseAPlusUnaryExp(APlusUnaryExp node) {
        this.inAPlusUnaryExp(node);
        node.getUnaryExp().apply(this);
        node.getPlus().apply(this);
        this.outAPlusUnaryExp(node);
    }

    public void caseANegateUnaryExp(ANegateUnaryExp node) {
        this.inANegateUnaryExp(node);
        node.getUnaryExp().apply(this);
        node.getNot().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.not());
        this.outANegateUnaryExp(node);
    }

    public void caseAPostdecr(APostdecr node) {
        this.inAPostdecr(node);
        node.getFieldAccess().apply(this);
        node.getMinusminus().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.dec());
        boolean tmp = this._doAssig;
        this._doAssig = true;
        node.getFieldAccess().apply(this);
        this._doAssig = tmp;
        this.outAPostdecr(node);
    }

    public void caseAPostincr(APostincr node) {
        this.inAPostincr(node);
        boolean tmp = this._doAssig;
        this._doAssig = false;
        node.getFieldAccess().apply(this);
        node.getPlusplus().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.inc());
        this._doAssig = true;
        node.getFieldAccess().apply(this);
        this._doAssig = tmp;
        this.outAPostincr(node);
    }

    public void caseAPredecr(APredecr node) {
        this.inAPredecr(node);
        boolean tmp = this._doAssig;
        this._doAssig = false;
        node.getFieldAccess().apply(this);
        node.getMinusminus().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.dec());
        this._doAssig = true;
        node.getFieldAccess().apply(this);
        this._doAssig = tmp;
        this.outAPredecr(node);
    }

    public void caseAPreincr(APreincr node) {
        this.inAPreincr(node);
        boolean tmp = this._doAssig;
        this._doAssig = false;
        node.getFieldAccess().apply(this);
        node.getPlusplus().apply(this);
        this._cClosure.addClosure(NumericOpsFactory.inc());
        this._doAssig = true;
        node.getFieldAccess().apply(this);
        this._doAssig = tmp;
        this.outAPreincr(node);
    }

    public void caseANullFactor(ANullFactor node) {
        this.inANullFactor(node);
        node.getNull().apply(this);
        this._cClosure.addClosure(StackOpsFactory.push(NullTypeFactory.createNullType()));
        this.outANullFactor(node);
    }

    public void caseAExpressionFactor(AExpressionFactor node) {
        this.inAExpressionFactor(node);
        if (node.getBoolExpression() != null) {
            node.getBoolExpression().apply(this);
        }
        this.outAExpressionFactor(node);
    }

    public void caseAINumber(AINumber node) {
        block4: {
            this.inAINumber(node);
            node.getIntnumber().apply(this);
            try {
                int i = Integer.parseInt(node.getIntnumber().getText().trim());
                IClass type = this._informationHolder.getTypeFromNode(node, new IClass[0]);
                if (type.getName().equals("int")) {
                    this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(i)));
                    break block4;
                }
                if (type.getName().equals("char")) {
                    this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType((char)i)));
                    break block4;
                }
                throw KenyaPreconditionError.get();
            }
            catch (NumberFormatException e) {
                throw KenyaPreconditionError.get();
            }
        }
        this.outAINumber(node);
    }

    public void caseADNumber(ADNumber node) {
        this.inADNumber(node);
        node.getDpnumber().apply(this);
        try {
            double d = Double.parseDouble(node.getDpnumber().getText().trim());
            this._cClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(d)));
        }
        catch (NumberFormatException e) {
            throw KenyaPreconditionError.get();
        }
        this.outADNumber(node);
    }

    public void caseAOrBoolExpression(AOrBoolExpression node) {
        this.inAOrBoolExpression(node);
        IBuildableClosure globalClosure = this._cClosure;
        InterpretedBuildableClosure lhs = new InterpretedBuildableClosure();
        InterpretedBuildableClosure rhs = new InterpretedBuildableClosure();
        this._cClosure = lhs;
        node.getBoolExpression().apply(this);
        this._cClosure = rhs;
        node.getBoolTerm().apply(this);
        node.getOr().apply(this);
        this._cClosure = globalClosure;
        this._cClosure.addClosure(LogicalOpsFactory.or(lhs, rhs));
        this.outAOrBoolExpression(node);
    }

    public void caseAXorBoolExpression(AXorBoolExpression node) {
        this.inAXorBoolExpression(node);
        node.getBoolExpression().apply(this);
        node.getBoolTerm().apply(this);
        node.getXor().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.xor());
        this.outAXorBoolExpression(node);
    }

    public void caseAAndBoolTerm(AAndBoolTerm node) {
        this.inAAndBoolTerm(node);
        IBuildableClosure globalClosure = this._cClosure;
        InterpretedBuildableClosure lhs = new InterpretedBuildableClosure();
        InterpretedBuildableClosure rhs = new InterpretedBuildableClosure();
        this._cClosure = lhs;
        node.getBoolTerm().apply(this);
        this._cClosure = rhs;
        node.getEquality().apply(this);
        node.getAnd().apply(this);
        this._cClosure = globalClosure;
        this._cClosure.addClosure(LogicalOpsFactory.and(lhs, rhs));
        this.outAAndBoolTerm(node);
    }

    public void caseAEqEquality(AEqEquality node) {
        this.inAEqEquality(node);
        node.getEquality().apply(this);
        node.getRelational().apply(this);
        node.getEqual().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.equal());
        this.outAEqEquality(node);
    }

    public void caseANeqEquality(ANeqEquality node) {
        this.inANeqEquality(node);
        node.getEquality().apply(this);
        node.getRelational().apply(this);
        node.getNotequal().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.notEqual());
        this.outANeqEquality(node);
    }

    public void caseALtRelational(ALtRelational node) {
        this.inALtRelational(node);
        node.getRelational().apply(this);
        node.getMathExpression().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getLess().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.lessThan());
        this.outALtRelational(node);
    }

    public void caseAGtRelational(AGtRelational node) {
        this.inAGtRelational(node);
        node.getRelational().apply(this);
        node.getMathExpression().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getGreater().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.greaterThan());
        this.outAGtRelational(node);
    }

    public void caseALteqRelational(ALteqRelational node) {
        this.inALteqRelational(node);
        node.getRelational().apply(this);
        node.getMathExpression().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getLessequal().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.lessThanEqual());
        this.outALteqRelational(node);
    }

    public void caseAGteqRelational(AGteqRelational node) {
        this.inAGteqRelational(node);
        node.getRelational().apply(this);
        node.getMathExpression().apply(this);
        this._cClosure.addClosure(StackOpsFactory.reverseStackTop(2));
        node.getGreaterequal().apply(this);
        this._cClosure.addClosure(LogicalOpsFactory.greaterThanEqual());
        this.outAGteqRelational(node);
    }

    public void caseAArrayFieldAccess(AArrayFieldAccess node) {
        Object[] temp;
        this.inAArrayFieldAccess(node);
        boolean tmpDoAssig = this._doAssig;
        this._doAssig = false;
        if (node.getName() != null) {
            boolean wasNull;
            boolean bl = wasNull = this._stackVariableTable == null;
            if (wasNull) {
                this._stackVariableTable = this._variableTable;
            }
            node.getName().apply(this);
            if (wasNull) {
                this._stackVariableTable = null;
            }
        }
        if ((temp = node.getArrayAccess().toArray()).length == 0) {
            throw KenyaPreconditionError.get();
        }
        for (int i = 0; i < temp.length; ++i) {
            VariableLookupTable tmp = this._stackVariableTable;
            this._stackVariableTable = null;
            ((PArrayAccess)temp[i]).apply(this);
            this._stackVariableTable = tmp;
            if (i + 1 == temp.length) {
                if (tmpDoAssig) {
                    this._cClosure.addClosure(ArrayOpsFactory.set());
                    continue;
                }
                this._cClosure.addClosure(ArrayOpsFactory.get());
                this.checkCast(node);
                continue;
            }
            this._cClosure.addClosure(ArrayOpsFactory.get());
        }
        this._doAssig = tmpDoAssig;
        this.outAArrayFieldAccess(node);
    }

    public void caseAArrayAccess(AArrayAccess node) {
        this.inAArrayAccess(node);
        node.getMathExpression().apply(this);
        this.outAArrayAccess(node);
    }

    public void caseAScalarFieldAccess(AScalarFieldAccess node) {
        this.inAScalarFieldAccess(node);
        node.getName().apply(this);
        this.outAScalarFieldAccess(node);
    }

    public void caseASimpleName(ASimpleName node) {
        boolean wasNull;
        this.inASimpleName(node);
        node.getIdentifier().apply(this);
        boolean bl = wasNull = this._stackVariableTable == null;
        if (wasNull) {
            this._stackVariableTable = this._variableTable;
        }
        IClass nameType = this.getNodeType(node);
        if (this._informationHolder.isEnumChildNode(node)) {
            IInterpretedEnumeration ienum = this._stackInfoManager.getEnumBody(nameType);
            String chName = node.getIdentifier().getText().trim();
            IEnumType enumType = EnumTypeFactory.createEnumType(ienum, chName);
            this._cClosure.addClosure(StackOpsFactory.push(enumType));
        } else if (this._doAssig) {
            IVariable var = this._stackVariableTable.lookupByName(node.getIdentifier().getText().trim());
            String smName = this._stackInfoManager.lookupVariable(var);
            this._cClosure.addClosure(StackOpsFactory.store(smName));
        } else if (this._stackVariableTable.hasVariable(node.getIdentifier().getText().trim())) {
            IVariable var = this._stackVariableTable.lookupByName(node.getIdentifier().getText().trim());
            String smName = this._stackInfoManager.lookupVariable(var);
            this._cClosure.addClosure(StackOpsFactory.fetch(smName));
            this._stackVariableTable = new VariableLookupTable(nameType.getDeclarations());
        } else if (!this._informationHolder.hasEnum(node.getIdentifier().getText().trim())) {
            throw KenyaPreconditionError.get();
        }
        if (wasNull) {
            this._stackVariableTable = null;
        }
        this.outASimpleName(node);
    }

    /*
     * WARNING - void declaration
     */
    public void caseAQualifiedName(AQualifiedName node) {
        boolean wasNull;
        this.inAQualifiedName(node);
        boolean bl = wasNull = this._stackVariableTable == null;
        if (wasNull) {
            this._stackVariableTable = this._variableTable;
        }
        boolean tmpDoAssig = this._doAssig;
        this._doAssig = false;
        node.getFieldAccess().apply(this);
        this._doAssig = tmpDoAssig;
        node.getIdentifier().apply(this);
        if (this._doAssig) {
            IVariable var = this._stackVariableTable.lookupByName(node.getIdentifier().getText().trim());
            String smName = this._stackInfoManager.lookupVariable(var);
            this._cClosure.addClosure(new AbstractAtomicClosure(){

                public void execute(StackMachine sm) {
                    IType a = sm.pop();
                    IType b = sm.pop();
                    sm.push(a);
                    sm.push(b);
                }
            });
            this._cClosure.addClosure(StackOpsFactory.storeInClassInstance(smName));
        } else if (this._informationHolder.isArrayLengthReference(node)) {
            this._cClosure.addClosure(ArrayOpsFactory.getLength());
        } else {
            void var4_5;
            IClass type;
            if (this._cIClass != null) {
                type = this._informationHolder.getTypeFromNode(node, this._cIClass.getTemplateParams());
            } else if (this._cFunction != null) {
                type = this._informationHolder.getTypeFromNode(node, this._cFunction.getTypeParams());
            } else {
                throw KenyaPreconditionError.get();
            }
            if (this._informationHolder.isEnumChildNode(node)) {
                IInterpretedEnumeration ienum = this._stackInfoManager.getEnumBody((IClass)var4_5);
                String chName = node.getIdentifier().getText().trim();
                IEnumType enumType = EnumTypeFactory.createEnumType(ienum, chName);
                this._cClosure.addClosure(StackOpsFactory.push(enumType));
            } else {
                IVariable thisVar = this._stackVariableTable.lookupByName(node.getIdentifier().getText().trim());
                String smName = this._stackInfoManager.lookupVariable(thisVar);
                this._cClosure.addClosure(StackOpsFactory.fetchFromClassInstance(smName));
                this._stackVariableTable = new VariableLookupTable(var4_5.getDeclarations());
            }
        }
        if (wasNull) {
            this._stackVariableTable = null;
        }
        this.outAQualifiedName(node);
    }

    public void caseTReservedWord(TReservedWord node) {
        this.doMarker(node);
    }

    public void caseTNewLine(TNewLine node) {
        this.doMarker(node);
    }

    public void caseTBlank(TBlank node) {
        this.doMarker(node);
    }

    public void caseTComment(TComment node) {
        this.doMarker(node);
    }

    public void caseTTraditionalComment(TTraditionalComment node) {
        this.doMarker(node);
    }

    public void caseTBoolean(TBoolean node) {
        this.doMarker(node);
    }

    public void caseTChar(TChar node) {
        this.doMarker(node);
    }

    public void caseTInt(TInt node) {
        this.doMarker(node);
    }

    public void caseTDouble(TDouble node) {
        this.doMarker(node);
    }

    public void caseTString(TString node) {
        this.doMarker(node);
    }

    public void caseTVoid(TVoid node) {
        this.doMarker(node);
    }

    public void caseTKlass(TKlass node) {
        this.doMarker(node);
    }

    public void caseTConst(TConst node) {
        this.doMarker(node);
    }

    public void caseTIf(TIf node) {
        this.doMarker(node);
    }

    public void caseTElse(TElse node) {
        this.doMarker(node);
    }

    public void caseTWhile(TWhile node) {
        this.doMarker(node);
    }

    public void caseTReturn(TReturn node) {
        this.doMarker(node);
    }

    public void caseTSwitch(TSwitch node) {
        this.doMarker(node);
    }

    public void caseTCase(TCase node) {
        this.doMarker(node);
    }

    public void caseTBreak(TBreak node) {
        this.doMarker(node);
    }

    public void caseTDefault(TDefault node) {
        this.doMarker(node);
    }

    public void caseTFor(TFor node) {
        this.doMarker(node);
    }

    public void caseTAssert(TAssert node) {
        this.doMarker(node);
    }

    public void caseTNew(TNew node) {
        this.doMarker(node);
    }

    public void caseTEnum(TEnum node) {
        this.doMarker(node);
    }

    public void caseTTrue(TTrue node) {
        this.doMarker(node);
    }

    public void caseTFalse(TFalse node) {
        this.doMarker(node);
    }

    public void caseTNull(TNull node) {
        this.doMarker(node);
    }

    public void caseTAnd(TAnd node) {
        this.doMarker(node);
    }

    public void caseTOr(TOr node) {
        this.doMarker(node);
    }

    public void caseTXor(TXor node) {
        this.doMarker(node);
    }

    public void caseTNot(TNot node) {
        this.doMarker(node);
    }

    public void caseTIdentifier(TIdentifier node) {
        this.doMarker(node);
    }

    public void caseTStringliteral(TStringliteral node) {
        this.doMarker(node);
    }

    public void caseTCharliteral(TCharliteral node) {
        this.doMarker(node);
    }

    public void caseTLParenthese(TLParenthese node) {
        this.doMarker(node);
    }

    public void caseTRParenthese(TRParenthese node) {
        this.doMarker(node);
    }

    public void caseTLBrace(TLBrace node) {
        this.doMarker(node);
    }

    public void caseTRBrace(TRBrace node) {
        this.doMarker(node);
    }

    public void caseTLBracket(TLBracket node) {
        this.doMarker(node);
    }

    public void caseTRBracket(TRBracket node) {
        this.doMarker(node);
    }

    public void caseTBracketPair(TBracketPair node) {
        this.doMarker(node);
    }

    public void caseTSemicolon(TSemicolon node) {
        this.doMarker(node);
    }

    public void caseTColon(TColon node) {
        this.doMarker(node);
    }

    public void caseTComma(TComma node) {
        this.doMarker(node);
    }

    public void caseTDot(TDot node) {
        this.doMarker(node);
    }

    public void caseTPlus(TPlus node) {
        this.doMarker(node);
    }

    public void caseTPlusplus(TPlusplus node) {
        this.doMarker(node);
    }

    public void caseTMinus(TMinus node) {
        this.doMarker(node);
    }

    public void caseTMinusminus(TMinusminus node) {
        this.doMarker(node);
    }

    public void caseTTimes(TTimes node) {
        this.doMarker(node);
    }

    public void caseTDivide(TDivide node) {
        this.doMarker(node);
    }

    public void caseTMod(TMod node) {
        this.doMarker(node);
    }

    public void caseTLess(TLess node) {
        this.doMarker(node);
    }

    public void caseTLessequal(TLessequal node) {
        this.doMarker(node);
    }

    public void caseTGreater(TGreater node) {
        this.doMarker(node);
    }

    public void caseTGreaterequal(TGreaterequal node) {
        this.doMarker(node);
    }

    public void caseTEqual(TEqual node) {
        this.doMarker(node);
    }

    public void caseTNotequal(TNotequal node) {
        this.doMarker(node);
    }

    public void caseTAssign(TAssign node) {
        this.doMarker(node);
    }

    public void caseTIntnumber(TIntnumber node) {
        this.doMarker(node);
    }

    public void caseTDpnumber(TDpnumber node) {
        this.doMarker(node);
    }
}

