/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kenya.errors.SourceCodeException;
import kenya.passes.Util;
import kenya.types.KClassType;
import kenya.types.KEnumType;
import kenya.types.tables.ClassTable;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AClassDecDeclaration;
import minijava.node.ACommaEnumList;
import minijava.node.AConstDecDeclaration;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.ATypeParam;
import minijava.node.ATypeParamList;

public class TypeFinder
extends DepthFirstAdapter {
    private final ClassTable _ct;
    private List _errors = new LinkedList();
    private Set _errNodes;

    public TypeFinder(ClassTable ct) {
        this._ct = ct;
        this._errNodes = new HashSet();
    }

    public List getErrors() {
        return this._errors;
    }

    public Set getErrorNodes() {
        return this._errNodes;
    }

    public ClassTable getClassTable() {
        return this._ct;
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        try {
            if (node.getIdentifier() != null) {
                String className = node.getIdentifier().getText().trim();
                List params = null;
                if (node.getTypeParam() != null) {
                    params = Util.getParameterTemplates((ATypeParamList)((ATypeParam)node.getTypeParam()).getTypeParamList(), className);
                }
                this._ct.put(className, new KClassType(className, params), node);
            }
        }
        catch (SourceCodeException sce) {
            this._errors.add(sce);
            this._errNodes.add(node);
            return;
        }
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
        try {
            String enumName = node.getIdentifier().toString().trim();
            HashSet<String> enumChildren = new HashSet<String>();
            AEnumList ael = (AEnumList)node.getEnumList();
            String s = ael.getIdentifier().getText().trim();
            enumChildren.add(s);
            if (ael.getCommaEnumList() != null) {
                Iterator it = ael.getCommaEnumList().iterator();
                while (it.hasNext()) {
                    ACommaEnumList acel = (ACommaEnumList)it.next();
                    s = acel.getIdentifier().getText().trim();
                    if (enumChildren.add(s)) continue;
                    int ln = acel.getIdentifier().getLine();
                    int pos = acel.getIdentifier().getPos();
                    int len = acel.getIdentifier().getText().trim().length();
                    SourceCodeException.throwDuplicateEnumChild(ln, pos, len, s, enumName);
                }
            }
            this._ct.put(enumName, new KEnumType(enumName, enumChildren), node);
        }
        catch (SourceCodeException sce) {
            this._errNodes.add(node);
            this._errors.add(sce);
            return;
        }
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
    }
}

