/*
 * Decompiled with CFR 0.152.
 */
package kenya.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kenya.errors.KenyaPreconditionError;
import kenya.types.KBasicType;
import kenya.types.KClassType;
import kenya.types.KNullType;
import kenya.types.KParamType;
import kenya.types.KType;
import kenya.types.KVariable;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.TypeTable;

public class KBoundClassType
extends KType {
    private KClassType _base;
    private TypeTable _bindings;
    private SymbolTable _boundChildren;

    public KBoundClassType(KClassType base, TypeTable bindings) {
        this._base = base;
        this._bindings = bindings;
    }

    public String getName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._base.getName());
        if (this._base.getTypeParamList().size() != 0) {
            sb.append("<");
            Iterator it = this._base.getTypeParamList().iterator();
            while (it.hasNext()) {
                KParamType kpt = (KParamType)it.next();
                KType kt = this._bindings.lookup(kpt);
                if (kt instanceof KBasicType && kt != KBasicType.getString()) {
                    sb.append(((KBasicType)kt).getClassType());
                } else {
                    sb.append(kt);
                }
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public KClassType getBase() {
        return this._base;
    }

    public TypeTable getBindings() {
        return this._bindings;
    }

    public String toString() {
        return this.getName();
    }

    public KType bind(TypeTable tt) {
        HashMap<KParamType, KType> newBindings = new HashMap<KParamType, KType>();
        Iterator it = this._bindings.keyIterator();
        while (it.hasNext()) {
            KParamType lhs = (KParamType)it.next();
            KType rhs = this._bindings.lookup(lhs);
            newBindings.put(lhs, rhs.bind(tt));
        }
        TypeTable newTT = new TypeTable(newBindings);
        return new KBoundClassType(this._base, newTT);
    }

    public SymbolTable getBoundChildren() {
        if (this._boundChildren == null) {
            this.doBindChildren();
        }
        return this._boundChildren;
    }

    private final void doBindChildren() {
        Map baseChildren = this._base.getChildren().collapse();
        Iterator it = baseChildren.keySet().iterator();
        HashMap<String, KVariable> boundChildren = new HashMap<String, KVariable>();
        while (it.hasNext()) {
            String name = (String)it.next();
            KVariable unboundChild = (KVariable)baseChildren.get(name);
            KType unboundChildType = unboundChild.getType();
            KType boundChildType = unboundChildType.bind(this._bindings);
            boundChildren.put(name, new KVariable(name, boundChildType, false, unboundChild.getNode()));
        }
        this._boundChildren = new SymbolTable(boundChildren);
    }

    public int compareAndBind(KType target, TypeTable tt) {
        if (target instanceof KBoundClassType) {
            KClassType kt = ((KBoundClassType)target).getBase();
            if (this._base == KClassType.getDouble() && kt == KClassType.getDouble() || this._base == KClassType.getInteger() && kt == KClassType.getInteger() || this._base == KClassType.getCharacter() && kt == KClassType.getCharacter() || this._base == KClassType.getBoolean() && kt == KClassType.getBoolean()) {
                return 0;
            }
            KBoundClassType kbct = (KBoundClassType)target;
            if (!kbct.getBase().equals(this._base)) {
                return -1;
            }
            int count = 0;
            Iterator meIt = this._bindings.keyIterator();
            while (meIt.hasNext()) {
                KParamType myCurrentParam = (KParamType)meIt.next();
                KType myBind = this._bindings.lookup(myCurrentParam);
                KType hisBind = kbct._bindings.lookup(myCurrentParam);
                KType mb = myBind.bind(tt);
                KType hb = hisBind;
                if (hb instanceof KBoundClassType) {
                    KType mbc;
                    if (mb instanceof KBoundClassType) {
                        KBoundClassType hbc = (KBoundClassType)hb;
                        mbc = (KBoundClassType)mb;
                        if (hbc.getBase() != ((KBoundClassType)mbc).getBase()) {
                            return -1;
                        }
                    } else if (mb instanceof KBasicType) {
                        KBoundClassType hbc = (KBoundClassType)hb;
                        mbc = (KBasicType)mb;
                        if (hbc.getBase() != ((KBasicType)mbc).getClassType()) {
                            return -1;
                        }
                    }
                } else if (hb instanceof KBasicType) {
                    if (mb instanceof KBoundClassType) {
                        KBoundClassType mbc = (KBoundClassType)mb;
                        KBasicType hbc = (KBasicType)hb;
                        if (mbc.getBase() != hbc.getClassType()) {
                            return -1;
                        }
                    } else if (mb instanceof KBasicType && mb != hb) {
                        return -1;
                    }
                }
                if (mb instanceof KBasicType && hb instanceof KBasicType && mb != hb) {
                    return -1;
                }
                myBind.compareAndBind(hisBind, tt);
                int ret = myBind.compareAndBind(hisBind, tt);
                if (ret == -1) {
                    return -1;
                }
                count += ret;
            }
            return count;
        }
        if (target instanceof KClassType) {
            throw KenyaPreconditionError.get();
        }
        if (target instanceof KBasicType) {
            KBasicType kt = (KBasicType)target;
            if (this._base == KClassType.getDouble() && kt == KBasicType.getInt()) {
                return 1;
            }
            if (this._base == KClassType.getDouble() && kt == KBasicType.getDouble()) {
                return 2;
            }
            if (this._base == KClassType.getInteger() && kt == KBasicType.getChar()) {
                return 1;
            }
            if (this._base == KClassType.getDouble() && kt == KBasicType.getDouble() || this._base == KClassType.getInteger() && kt == KBasicType.getInt() || this._base == KClassType.getCharacter() && kt == KBasicType.getChar() || this._base == KClassType.getBoolean() && kt == KBasicType.getBoolean()) {
                return 0;
            }
        } else if (target == KNullType.get()) {
            return 0;
        }
        return -1;
    }

    public boolean isBound(Map paramMap) {
        Iterator it = this._bindings.keyIterator();
        while (it.hasNext()) {
            KParamType kpt = (KParamType)it.next();
            KType rhs = this._bindings.lookup(kpt);
            if (!(rhs instanceof KParamType) || paramMap.containsKey(kpt.toString())) continue;
            return false;
        }
        return true;
    }

    public void populateParamMap(Map paramMap) {
        Iterator it = this._bindings.keyIterator();
        while (it.hasNext()) {
            KParamType kpt = (KParamType)it.next();
            KType rhs = this._bindings.lookup(kpt);
            if (!(rhs instanceof KParamType)) continue;
            paramMap.put(rhs.toString(), rhs);
        }
    }
}

