/*
 * Decompiled with CFR 0.152.
 */
package kenya.types.tables;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kenya.types.KArrayType;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KClassType;
import kenya.types.KEnumType;
import kenya.types.KFunction;
import kenya.types.KParamType;
import kenya.types.KType;

final class FuncComp
implements Comparator {
    FuncComp() {
    }

    public int compare(Object o1, Object o2) {
        KFunction f1 = (KFunction)o1;
        KFunction f2 = (KFunction)o2;
        int res = f1.getName().compareTo(f2.getName());
        if (res != 0) {
            return res;
        }
        List f1A = f1.getArgs();
        List f2A = f2.getArgs();
        res = f1A.size() - f2A.size();
        if (res != 0) {
            return res;
        }
        Iterator i1 = f1A.iterator();
        Iterator i2 = f2A.iterator();
        while (i1.hasNext()) {
            KType kt2;
            KType kt1 = (KType)i1.next();
            res = FuncComp.compareTypes(kt1, kt2 = (KType)i2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    static int compareTypes(KType kt1, KType kt2) {
        if (kt1 == null || kt2 == null) {
            throw new NullPointerException("Cannot have null arguments!!!! kt1:" + kt1.toString() + " kt2:" + kt2.toString());
        }
        if (kt1 == kt2) {
            return 0;
        }
        if (kt1 instanceof KBasicType) {
            if (kt2 instanceof KBasicType) {
                KBasicType kb1 = (KBasicType)kt1;
                KBasicType kb2 = (KBasicType)kt2;
                if (kb1 == KBasicType.getVoid()) {
                    if (kb2 == KBasicType.getVoid()) {
                        return 0;
                    }
                    return -1;
                }
                if (kb1 == KBasicType.getBoolean()) {
                    if (kb2 == KBasicType.getVoid()) {
                        return 1;
                    }
                    if (kb2 == KBasicType.getBoolean()) {
                        return 0;
                    }
                    return -1;
                }
                if (kb1 == KBasicType.getChar()) {
                    if (kb2 == KBasicType.getVoid() || kb2 == KBasicType.getBoolean()) {
                        return 1;
                    }
                    if (kb2 == KBasicType.getChar()) {
                        return 0;
                    }
                    return -1;
                }
                if (kb1 == KBasicType.getInt()) {
                    if (kb2 == KBasicType.getDouble() || kb2 == KBasicType.getString()) {
                        return -1;
                    }
                    if (kb2 == KBasicType.getInt()) {
                        return 0;
                    }
                    return 1;
                }
                if (kb1 == KBasicType.getDouble()) {
                    if (kb2 == KBasicType.getString()) {
                        return -1;
                    }
                    if (kb2 == KBasicType.getDouble()) {
                        return 0;
                    }
                    return 1;
                }
                if (kb1 == KBasicType.getString()) {
                    if (kb2 == KBasicType.getString()) {
                        return 0;
                    }
                    return 1;
                }
                throw new IllegalArgumentException("Got an unknown basic type.");
            }
            return -1;
        }
        if (kt1 instanceof KEnumType) {
            if (kt2 instanceof KBasicType) {
                return 1;
            }
            if (kt2 instanceof KEnumType) {
                return kt1.getName().compareTo(kt2.getName());
            }
            return -1;
        }
        if (kt1 instanceof KClassType) {
            if (kt2 instanceof KBasicType || kt2 instanceof KEnumType) {
                return 1;
            }
            if (kt2 instanceof KClassType) {
                return kt1.getName().compareTo(kt2.getName());
            }
            return -1;
        }
        if (kt1 instanceof KBoundClassType) {
            if (kt2 instanceof KArrayType || kt2 instanceof KParamType) {
                return -1;
            }
            if (kt2 instanceof KBoundClassType) {
                String n2;
                KBoundClassType kbct1 = (KBoundClassType)kt1;
                KBoundClassType kbct2 = (KBoundClassType)kt2;
                String n1 = kbct1.getBase().getName();
                int res = n1.compareTo(n2 = kbct2.getBase().getName());
                if (res != 0) {
                    return res;
                }
                Iterator it = kbct1.getBase().getTypeParamList().iterator();
                while (it.hasNext()) {
                    KType type2;
                    KParamType kpt = (KParamType)it.next();
                    KType type1 = kbct1.getBindings().lookup(kpt);
                    res = FuncComp.compareTypes(type1, type2 = kbct2.getBindings().lookup(kpt));
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
            return 1;
        }
        if (kt1 instanceof KArrayType) {
            if (kt2 instanceof KParamType) {
                return -1;
            }
            if (kt2 instanceof KArrayType) {
                KArrayType kat1 = (KArrayType)kt1;
                KArrayType kat2 = (KArrayType)kt2;
                return FuncComp.compareTypes(kat1.getChildType(), kat2.getChildType());
            }
            return 1;
        }
        if (kt1 instanceof KParamType) {
            if (kt2 instanceof KParamType) {
                return 0;
            }
            return 1;
        }
        throw new IllegalArgumentException("Unknown type for kt1:" + kt1.toString() + " " + kt2.toString());
    }
}

