/*
 * Decompiled with CFR 0.152.
 */
package kenya.types.tables;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kenya.errors.KenyaInternalError;
import kenya.errors.SourceCodeException;
import kenya.sourceCodeInformation.interfaces.ISourceCodeWarning;
import kenya.sourceCodeInformation.util.SourceCodeWarningFactory;
import kenya.types.KArrayType;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KFunction;
import kenya.types.KParamType;
import kenya.types.KType;
import kenya.types.tables.FuncComp;
import kenya.types.tables.TypeTable;
import kenya.types.tables.util.PairKFunctionReturnType;
import mediator.IJavaCode;

public class FunctionTable {
    private Map _lvlOneLookup = new HashMap();
    private final FuncComp _comparator = new FuncComp();

    public void add(KFunction kf, boolean builtin) throws SourceCodeException {
        SortedSet<KFunction> s;
        if (this._lvlOneLookup.containsKey(kf.getName())) {
            s = (SortedSet)this._lvlOneLookup.get(kf.getName());
        } else {
            s = new TreeSet(this._comparator);
            this._lvlOneLookup.put(kf.getName(), s);
        }
        if (!s.add(kf)) {
            if (!kf.isBuiltin()) {
                int ln = kf.getNode().getIdentifier().getLine();
                int pos = kf.getNode().getIdentifier().getPos();
                int len = kf.getNode().getIdentifier().getText().trim().length();
                KFunction conf = s.tailSet(kf).first();
                if (!conf.isBuiltin()) {
                    int confLn = conf.getNode().getIdentifier().getLine();
                    int confPos = conf.getNode().getIdentifier().getPos();
                    int confLen = conf.getNode().getIdentifier().getText().trim().length();
                    int[][] lnkPos = new int[][]{{confLn, confPos, confLen}};
                    SourceCodeException.throwDuplicateFunction(ln, pos, len, lnkPos, conf.getName() + FunctionTable.paramsToString(kf.getArgs()), "<global>");
                } else {
                    SourceCodeException.throwDuplicateFunction_Builtin(ln, pos, len, conf.getName());
                }
            } else {
                KFunction conf = s.tailSet(kf).first();
                if (conf.isBuiltin()) {
                    throw new KenyaInternalError("Conflicting Builtin Functions detected. Please check Kenya installation.");
                }
                int ln = conf.getNode().getIdentifier().getLine();
                int pos = conf.getNode().getIdentifier().getPos();
                int len = conf.getNode().getIdentifier().getText().trim().length();
                SourceCodeException.throwDuplicateFunction_Builtin(ln, pos, len, conf.getName());
            }
        }
    }

    public PairKFunctionReturnType getFuncAndRetType(String name, List paramTypes, int ln, int pos, int len, List warnings, String scope) {
        if (!this._lvlOneLookup.containsKey(name)) {
            String args = FunctionTable.paramsToString(paramTypes);
            SourceCodeException.throwLost_Function(ln, pos, len, args, name, scope);
        }
        SortedSet fns = (SortedSet)this._lvlOneLookup.get(name);
        Iterator it = fns.iterator();
        boolean foundMatch = false;
        KFunction bestMatch = null;
        KType retType = null;
        int numCasts = -1;
        LinkedList<ISourceCodeWarning> localWarnings = new LinkedList<ISourceCodeWarning>();
        block0: while (it.hasNext()) {
            KType thisHim;
            KType thisMe;
            KFunction kf = (KFunction)it.next();
            if (kf.getArgs().size() != paramTypes.size()) continue;
            List theirArgs = kf.getArgs();
            TypeTable tt = new TypeTable();
            Iterator theirs = theirArgs.iterator();
            Iterator mine = paramTypes.iterator();
            int tmpNumCasts = 0;
            while (theirs.hasNext()) {
                thisMe = (KType)mine.next();
                thisHim = (KType)theirs.next();
                thisHim.compareAndBind(thisMe, tt);
            }
            theirs = theirArgs.iterator();
            mine = paramTypes.iterator();
            while (theirs.hasNext()) {
                thisMe = (KType)mine.next();
                thisHim = (KType)theirs.next();
                int res = thisHim.compareAndBind(thisMe, tt);
                if (res < 0) {
                    if (res != -2 || kf.isBuiltin()) continue block0;
                    int[][] lnkPos = new int[][]{{kf.getNode().getIdentifier().getLine(), kf.getNode().getIdentifier().getPos(), kf.getNode().getIdentifier().getText().length()}};
                    localWarnings.add(SourceCodeWarningFactory.attemptedBasicTypeArrayUsage(ln, pos, len, lnkPos));
                    continue block0;
                }
                tmpNumCasts += res;
            }
            if (foundMatch && tmpNumCasts < numCasts) {
                bestMatch = kf;
                numCasts = tmpNumCasts;
            } else if (foundMatch && tmpNumCasts == numCasts) {
                Object lnkPos = null;
                if (!bestMatch.isBuiltin() && !kf.isBuiltin()) {
                    lnkPos = new int[][]{{kf.getNode().getIdentifier().getLine(), kf.getNode().getIdentifier().getPos(), kf.getNode().getIdentifier().getText().length()}, {bestMatch.getNode().getIdentifier().getLine(), bestMatch.getNode().getIdentifier().getPos(), bestMatch.getNode().getIdentifier().getText().length()}};
                } else if (!bestMatch.isBuiltin()) {
                    lnkPos = new int[][]{{bestMatch.getNode().getIdentifier().getLine(), bestMatch.getNode().getIdentifier().getPos(), bestMatch.getNode().getIdentifier().getText().length()}};
                } else if (!kf.isBuiltin()) {
                    lnkPos = new int[][]{{kf.getNode().getIdentifier().getLine(), kf.getNode().getIdentifier().getPos(), kf.getNode().getIdentifier().getText().length()}};
                }
                warnings.addAll(localWarnings);
                String args1 = FunctionTable.paramsToString(bestMatch.getArgs());
                String args2 = FunctionTable.paramsToString(theirArgs);
                SourceCodeException.throwAmbiguous_Function(ln, pos, len, lnkPos, args1, args2, "<global>", name);
            }
            if (foundMatch) continue;
            foundMatch = true;
            bestMatch = kf;
            retType = kf.getReturnType().bind(tt);
            numCasts = tmpNumCasts;
        }
        if (foundMatch) {
            KArrayType actRT;
            KType bbase;
            KArrayType kat;
            KType normalReturnType = bestMatch.getReturnType();
            if (normalReturnType instanceof KArrayType && (kat = (KArrayType)normalReturnType).getBaseType() instanceof KParamType && (bbase = (actRT = (KArrayType)retType).getBaseType()) instanceof KBasicType && bbase != KBasicType.getString() && actRT.getDepth() == kat.getDepth()) {
                int depth = ((KArrayType)retType).getDepth();
                KType outRT = new KBoundClassType(((KBasicType)bbase).getClassType(), new TypeTable());
                for (int i = 0; i < depth; ++i) {
                    outRT = new KArrayType(outRT);
                }
                retType = outRT;
            }
            return new PairKFunctionReturnType(bestMatch, retType);
        }
        String args = FunctionTable.paramsToString(paramTypes);
        Iterator errit = fns.iterator();
        int i = 0;
        while (errit.hasNext()) {
            KFunction kf = (KFunction)errit.next();
            if (kf.isBuiltin()) continue;
            ++i;
        }
        int[][] lnkPos = new int[i][3];
        i = 0;
        errit = fns.iterator();
        while (errit.hasNext()) {
            KFunction kf = (KFunction)errit.next();
            if (kf.isBuiltin()) continue;
            lnkPos[i][0] = kf.getNode().getIdentifier().getLine();
            lnkPos[i][1] = kf.getNode().getIdentifier().getPos();
            lnkPos[i][2] = kf.getNode().getIdentifier().getText().length();
            ++i;
        }
        warnings.addAll(localWarnings);
        SourceCodeException.throwLost_Function_Possible(ln, pos, len, lnkPos, args, name, scope);
        return null;
    }

    public static String paramsToString(List l) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Iterator it = l.iterator();
        while (it.hasNext()) {
            KType kt = (KType)it.next();
            sb.append(kt.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public Map getBackingMap() {
        return this._lvlOneLookup;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Functions:");
        sb.append(IJavaCode.NEWLINE);
        Iterator it = this._lvlOneLookup.keySet().iterator();
        while (it.hasNext()) {
            Iterator it2 = ((Set)this._lvlOneLookup.get(it.next())).iterator();
            while (it2.hasNext()) {
                sb.append("\t");
                sb.append(it2.next().toString());
                if (!it2.hasNext()) continue;
                sb.append(IJavaCode.NEWLINE);
            }
            if (!it.hasNext()) continue;
            sb.append(IJavaCode.NEWLINE);
        }
        return sb.toString();
    }
}

