/*
 * Decompiled with CFR 0.152.
 */
package kenya.types.tables;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import kenya.errors.KenyaInternalError;
import kenya.types.KVariable;
import mediator.IJavaCode;

public class SymbolTable {
    private Map _gloConsts;
    private LinkedList _tableQueue = new LinkedList();

    public SymbolTable(Map globalConstants) {
        this._gloConsts = Collections.unmodifiableMap(globalConstants);
    }

    public SymbolTable() {
        this._gloConsts = Collections.unmodifiableMap(new HashMap());
    }

    public SymbolTable(SymbolTable base, SymbolTable local) {
        this._gloConsts = Collections.unmodifiableMap(base.collapse());
        this.push(local);
    }

    public boolean push(String name, KVariable var) {
        this.newLocalScope();
        return this.pushLocal(name, var);
    }

    public void newLocalScope() {
        this.push(new HashMap());
    }

    public boolean pushLocal(String name, KVariable var) {
        Map m = (Map)this._tableQueue.getFirst();
        if (this.containsLocalVariable(name)) {
            return false;
        }
        m.put(name, var);
        return true;
    }

    public boolean push(SymbolTable st) throws IllegalStateException {
        Map m = st.collapse();
        return this.push(m);
    }

    public boolean push(Map m) {
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.containsLocalVariable(name)) continue;
            return false;
        }
        this._tableQueue.addFirst(m);
        return true;
    }

    public void pop() {
        this._tableQueue.removeFirst();
    }

    public Map collapse() throws IllegalStateException {
        HashMap allMappings = new HashMap();
        Iterator it = this._tableQueue.iterator();
        while (it.hasNext()) {
            Map cScope = (Map)it.next();
            Iterator nit = cScope.keySet().iterator();
            while (nit.hasNext()) {
                Object o = nit.next();
                if (allMappings.containsKey(o)) {
                    throw new KenyaInternalError("Duplicate Mapping found in SymbolTable during collapse.");
                }
                allMappings.put(o, cScope.get(o));
            }
        }
        Iterator nit = this._gloConsts.keySet().iterator();
        while (nit.hasNext()) {
            Object o = nit.next();
            if (allMappings.containsKey(o)) {
                throw new KenyaInternalError("Duplicate Mapping found in SymbolTable during collapse.");
            }
            allMappings.put(o, this._gloConsts.get(o));
        }
        return allMappings;
    }

    public boolean containsVariable(String name) {
        return this.containsLocalVariable(name) || this.constansGlobalVariable(name);
    }

    private boolean containsLocalVariable(String name) {
        Iterator it = this._tableQueue.iterator();
        while (it.hasNext()) {
            Map cScope = (Map)it.next();
            if (!cScope.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    private boolean constansGlobalVariable(String name) {
        return this._gloConsts.containsKey(name);
    }

    public KVariable lookupVariable(String name) {
        Iterator it = this._tableQueue.iterator();
        while (it.hasNext()) {
            Map cScope = (Map)it.next();
            if (!cScope.containsKey(name)) continue;
            return (KVariable)cScope.get(name);
        }
        if (this._gloConsts.containsKey(name)) {
            return (KVariable)this._gloConsts.get(name);
        }
        throw new NoSuchElementException("Couldn't find variable");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Globals:" + IJavaCode.NEWLINE + "{");
        Iterator<Object> it = this._gloConsts.keySet().iterator();
        while (it.hasNext()) {
            KVariable kt = (KVariable)this._gloConsts.get(it.next());
            sb.append(kt);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        sb.append(IJavaCode.NEWLINE + "Scopes:" + IJavaCode.NEWLINE);
        it = this._tableQueue.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            sb.append("{");
            Iterator it2 = m.keySet().iterator();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                KVariable kt = (KVariable)m.get(name);
                sb.append(kt);
                if (!it2.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            if (!it.hasNext()) continue;
            sb.append(IJavaCode.NEWLINE);
        }
        sb.append(IJavaCode.NEWLINE);
        return sb.toString();
    }
}

