/*
 * Decompiled with CFR 0.152.
 */
package kenya.types.tables;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kenya.types.KParamType;
import kenya.types.KType;

public class TypeTable {
    private final Map _initial;

    public TypeTable(Map initialMappings) {
        this._initial = initialMappings;
    }

    public TypeTable(TypeTable clone) {
        this._initial = new HashMap();
        Iterator it = clone._initial.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            this._initial.put(o, clone._initial.get(o));
        }
    }

    public TypeTable() {
        this._initial = new HashMap();
    }

    public boolean put(KParamType src, KType target) {
        if (this._initial.containsKey(src)) {
            return false;
        }
        this._initial.put(src, target);
        return true;
    }

    public boolean remove(KParamType src) {
        if (this._initial.containsKey(src)) {
            this._initial.remove(src);
            return true;
        }
        return false;
    }

    public Iterator keyIterator() {
        return this._initial.keySet().iterator();
    }

    public KType lookup(KParamType source) throws NoSuchElementException {
        if (this._initial.containsKey(source)) {
            return (KType)this._initial.get(source);
        }
        throw new NoSuchElementException("Couldn't find a mapping for the parameter.");
    }

    public boolean containsKey(KParamType source) {
        return this._initial.containsKey(source);
    }

    public void force(KParamType source, KType target) {
        if (this._initial.containsKey(source)) {
            this._initial.remove(source);
        }
        this._initial.put(source, target);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator it2 = this._initial.keySet().iterator();
        while (it2.hasNext()) {
            KParamType kpt = (KParamType)it2.next();
            KType kt = (KType)this._initial.get(kpt);
            sb.append(kpt);
            sb.append("=>");
            sb.append(kt.getName());
            if (!it2.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

