/*
 * Decompiled with CFR 0.152.
 */
package kenya.types.tables;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import kenya.errors.KenyaInternalError;
import kenya.errors.KenyaPreconditionError;
import kenya.types.KVariable;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.ValuePair;
import kenya.values.IKValue;
import kenya.values.KBooleanValue;
import kenya.values.KUnassignedValue;
import kenya.values.KUnknownValue;
import kenya.values.util.KValueCalculator;
import kenya.values.util.MarkerKVariable;
import mediator.IJavaCode;

public class VariableTable {
    private Map _gloConsts;
    private LinkedList _tableQueue;

    public VariableTable() {
        this._gloConsts = new HashMap();
        this._tableQueue = new LinkedList();
    }

    private VariableTable(Map gloConsts, LinkedList tableQueue) {
        this._gloConsts = gloConsts;
        this._tableQueue = tableQueue;
    }

    public boolean addConstant(KVariable var, IKValue val) {
        if (this._gloConsts.containsKey(var)) {
            return false;
        }
        this._gloConsts.put(var, val);
        return true;
    }

    public Map getConstants() {
        return this._gloConsts;
    }

    public void pushSymbolTable(SymbolTable st) {
        this.pushScope();
        Map m = st.collapse();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String ident = (String)i.next();
            KVariable kv = (KVariable)m.get(ident);
            this.declareNew(kv);
            this.assignTo(kv, KUnknownValue.get());
        }
    }

    public void pushScope() {
        this._tableQueue.addFirst(new HashMap());
    }

    public void popScope() {
        this._tableQueue.removeFirst();
    }

    public boolean declareNew(KVariable n3w) {
        Map tsb = (Map)this._tableQueue.getFirst();
        if (tsb.containsKey(n3w)) {
            return false;
        }
        tsb.put(n3w, new ValuePair());
        return true;
    }

    public void assignTo(KVariable lhs, IKValue rhs) {
        if (lhs == MarkerKVariable.getArbitary()) {
            return;
        }
        if (lhs == MarkerKVariable.getEnumConst()) {
            throw new KenyaInternalError("Impossible");
        }
        Iterator it = this._tableQueue.iterator();
        while (it.hasNext()) {
            Map cScope = (Map)it.next();
            if (!cScope.containsKey(lhs)) continue;
            ValuePair vp = (ValuePair)cScope.get(lhs);
            vp.assign(rhs);
            return;
        }
        throw new NoSuchElementException("Cannot find " + lhs + " to assign to.");
    }

    private ValuePair lookupScope(KVariable val) {
        Iterator it = this._tableQueue.iterator();
        while (it.hasNext()) {
            Map cScope = (Map)it.next();
            if (!cScope.containsKey(val)) continue;
            return (ValuePair)cScope.get(val);
        }
        return null;
    }

    private IKValue lookupConsts(KVariable val) {
        if (this._gloConsts.containsKey(val)) {
            return (IKValue)this._gloConsts.get(val);
        }
        return null;
    }

    public IKValue lookup(KVariable val) {
        if (val == MarkerKVariable.getArbitary()) {
            return KUnknownValue.get();
        }
        if (val == MarkerKVariable.getEnumConst()) {
            throw KenyaPreconditionError.get();
        }
        ValuePair vp = this.lookupScope(val);
        if (vp != null) {
            return vp.getUnTracked();
        }
        IKValue cv = this.lookupConsts(val);
        if (cv != null) {
            return cv;
        }
        throw new NoSuchElementException("Could not lookup KVariable " + val);
    }

    public IKValue lookupTracked(KVariable val) {
        if (val == MarkerKVariable.getArbitary()) {
            return KUnknownValue.get();
        }
        if (val == MarkerKVariable.getEnumConst()) {
            throw KenyaPreconditionError.get();
        }
        ValuePair vp = this.lookupScope(val);
        if (vp != null) {
            return vp.getTracked();
        }
        IKValue cv = this.lookupConsts(val);
        if (cv != null) {
            return cv;
        }
        throw new NoSuchElementException("Could not lookup KVariable " + val);
    }

    public VariableTable createClone() {
        HashMap<KVariable, IKValue> cloneGlobals = new HashMap<KVariable, IKValue>();
        Iterator cgIt = this._gloConsts.keySet().iterator();
        while (cgIt.hasNext()) {
            KVariable kv = (KVariable)cgIt.next();
            IKValue ikv = (IKValue)this._gloConsts.get(kv);
            cloneGlobals.put(kv, ikv);
        }
        LinkedList cloneScopes = new LinkedList();
        Iterator scIt = this._tableQueue.iterator();
        while (scIt.hasNext()) {
            Map cScopeMap = (Map)scIt.next();
            HashMap<KVariable, Object> cScopeCloneMap = new HashMap<KVariable, Object>();
            Iterator cScopeKeyIt = cScopeMap.keySet().iterator();
            while (cScopeKeyIt.hasNext()) {
                KVariable kv = (KVariable)cScopeKeyIt.next();
                ValuePair vp = (ValuePair)cScopeMap.get(kv);
                cScopeCloneMap.put(kv, vp.clone());
            }
            cloneScopes.addLast(cScopeCloneMap);
        }
        return new VariableTable(cloneGlobals, cloneScopes);
    }

    public static VariableTable merge(VariableTable lhs, VariableTable rhs) {
        Map lhsConsts = lhs._gloConsts;
        Map rhsConsts = rhs._gloConsts;
        if (!((Object)lhsConsts).equals(rhsConsts)) {
            throw new IllegalArgumentException("Constants are not the same." + lhsConsts + IJavaCode.NEWLINE + rhsConsts);
        }
        HashMap<KVariable, IKValue> cloneGlobals = new HashMap<KVariable, IKValue>();
        Iterator cgIt = lhsConsts.keySet().iterator();
        while (cgIt.hasNext()) {
            KVariable kv = (KVariable)cgIt.next();
            IKValue ikv = (IKValue)lhsConsts.get(kv);
            cloneGlobals.put(kv, ikv);
        }
        LinkedList cloneScopes = new LinkedList();
        LinkedList lhsScopes = lhs._tableQueue;
        LinkedList rhsScopes = rhs._tableQueue;
        if (lhsScopes.size() != rhsScopes.size()) {
            throw new IllegalArgumentException("Do not have the same number of scopes." + lhsScopes + IJavaCode.NEWLINE + rhsScopes);
        }
        Iterator lhsScopeIt = lhsScopes.iterator();
        Iterator rhsScopeIt = rhsScopes.iterator();
        while (lhsScopeIt.hasNext() && rhsScopeIt.hasNext()) {
            Map lhsCScope = (Map)lhsScopeIt.next();
            Map rhsCScope = (Map)rhsScopeIt.next();
            HashMap<KVariable, ValuePair> thisCloneScope = new HashMap<KVariable, ValuePair>();
            if (lhsCScope.keySet().size() != rhsCScope.keySet().size()) {
                throw new IllegalArgumentException("Do not have the same number of elements in this scope." + lhsCScope + IJavaCode.NEWLINE + rhsCScope);
            }
            Iterator varIt = lhsCScope.keySet().iterator();
            while (varIt.hasNext()) {
                KVariable kv = (KVariable)varIt.next();
                if (!rhsCScope.containsKey(kv)) {
                    throw new IllegalArgumentException("Got a variable that is unmatched in other scope." + kv);
                }
                ValuePair lvp = (ValuePair)lhsCScope.get(kv);
                ValuePair rvp = (ValuePair)rhsCScope.get(kv);
                IKValue tracked = VariableTable.mergeValues(lvp.getTracked(), rvp.getTracked());
                IKValue untracked = VariableTable.mergeValues(lvp.getUnTracked(), rvp.getUnTracked());
                ValuePair ovp = new ValuePair(untracked, tracked);
                thisCloneScope.put(kv, ovp);
            }
            cloneScopes.addLast(thisCloneScope);
        }
        return new VariableTable(cloneGlobals, cloneScopes);
    }

    private static IKValue mergeValues(IKValue lhs, IKValue rhs) {
        if (lhs == KUnassignedValue.get() || rhs == KUnassignedValue.get()) {
            return KUnassignedValue.get();
        }
        if (lhs == KUnknownValue.get() || rhs == KUnknownValue.get()) {
            return KUnknownValue.get();
        }
        if (KValueCalculator.equal(lhs, rhs) == KBooleanValue.getTrue()) {
            return lhs;
        }
        return KUnknownValue.get();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Globals:" + IJavaCode.NEWLINE + "{");
        Iterator<Object> it = this._gloConsts.keySet().iterator();
        while (it.hasNext()) {
            KVariable kt = (KVariable)it.next();
            IKValue ikv = (IKValue)this._gloConsts.get(kt);
            sb.append(kt);
            sb.append("=");
            sb.append(ikv);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        sb.append(IJavaCode.NEWLINE);
        sb.append("Scopes:");
        sb.append(IJavaCode.NEWLINE);
        it = this._tableQueue.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            sb.append("{");
            Iterator it2 = m.keySet().iterator();
            while (it2.hasNext()) {
                KVariable var = (KVariable)it2.next();
                ValuePair vp = (ValuePair)m.get(var);
                sb.append(var);
                sb.append("=");
                sb.append(vp.getUnTracked());
                if (!it2.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            if (!it.hasNext()) continue;
            sb.append(IJavaCode.NEWLINE);
        }
        sb.append(IJavaCode.NEWLINE);
        return sb.toString();
    }
}

