/*
 * Decompiled with CFR 0.152.
 */
package kenya.values.util;

import kenya.errors.KenyaInternalError;
import kenya.errors.KenyaPreconditionError;
import kenya.values.IKNumericValue;
import kenya.values.IKValue;
import kenya.values.KBooleanValue;
import kenya.values.KCharValue;
import kenya.values.KDoubleValue;
import kenya.values.KEnumValue;
import kenya.values.KIntValue;
import kenya.values.KStringValue;
import kenya.values.KUnknownValue;

public class KValueCalculator {
    private KValueCalculator() {
    }

    public static IKValue add(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KStringValue) {
            return new KStringValue(lhs.getString() + rhs.getString());
        }
        if (rhs instanceof KStringValue) {
            return new KStringValue(lhs.getString() + rhs.getString());
        }
        if (lhs instanceof KCharValue) {
            KCharValue ldc = (KCharValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() + rdc.getValue();
                if (res <= 65535 && res >= 0) {
                    return new KCharValue((char)res);
                }
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() + rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() + rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KIntValue) {
            KIntValue ldc = (KIntValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() + rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() + rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() + rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KDoubleValue) {
            KDoubleValue ldc = (KDoubleValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                double res = ldc.getValue() + (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                double res = ldc.getValue() + (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = ldc.getValue() + rdc.getValue();
                return new KDoubleValue(res);
            }
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue sub(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KCharValue) {
            KCharValue ldc = (KCharValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() - rdc.getValue();
                if (res <= 65535 && res >= 0) {
                    return new KCharValue((char)res);
                }
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() - rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() - rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KIntValue) {
            KIntValue ldc = (KIntValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() - rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() - rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() - rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KDoubleValue) {
            KDoubleValue ldc = (KDoubleValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                double res = ldc.getValue() - (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                double res = ldc.getValue() - (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = ldc.getValue() - rdc.getValue();
                return new KDoubleValue(res);
            }
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue mult(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KCharValue) {
            KCharValue ldc = (KCharValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() * rdc.getValue();
                if (res <= 65535 && res >= 0) {
                    return new KCharValue((char)res);
                }
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() * rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() * rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KIntValue) {
            KIntValue ldc = (KIntValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() * rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() * rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() * rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KDoubleValue) {
            KDoubleValue ldc = (KDoubleValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                double res = ldc.getValue() * (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                double res = ldc.getValue() * (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = ldc.getValue() * rdc.getValue();
                return new KDoubleValue(res);
            }
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue div(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof IKNumericValue && ((IKNumericValue)rhs).equalsZero()) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KCharValue) {
            KCharValue ldc = (KCharValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() / rdc.getValue();
                if (res <= 65535 && res >= 0) {
                    return new KCharValue((char)res);
                }
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() / rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() / rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KIntValue) {
            KIntValue ldc = (KIntValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() / rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() / rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() / rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KDoubleValue) {
            KDoubleValue ldc = (KDoubleValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                double res = ldc.getValue() / (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                double res = ldc.getValue() / (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = ldc.getValue() / rdc.getValue();
                return new KDoubleValue(res);
            }
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue mod(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof IKNumericValue && ((IKNumericValue)rhs).equalsZero()) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KCharValue) {
            KCharValue ldc = (KCharValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() % rdc.getValue();
                if (res <= 65535 && res >= 0) {
                    return new KCharValue((char)res);
                }
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() % rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() % rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KIntValue) {
            KIntValue ldc = (KIntValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                int res = ldc.getValue() % rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                int res = ldc.getValue() % rdc.getValue();
                return new KIntValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = (double)ldc.getValue() % rdc.getValue();
                return new KDoubleValue(res);
            }
        } else if (lhs instanceof KDoubleValue) {
            KDoubleValue ldc = (KDoubleValue)lhs;
            if (rhs instanceof KCharValue) {
                KCharValue rdc = (KCharValue)rhs;
                double res = ldc.getValue() % (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KIntValue) {
                KIntValue rdc = (KIntValue)rhs;
                double res = ldc.getValue() % (double)rdc.getValue();
                return new KDoubleValue(res);
            }
            if (rhs instanceof KDoubleValue) {
                KDoubleValue rdc = (KDoubleValue)rhs;
                double res = ldc.getValue() % rdc.getValue();
                return new KDoubleValue(res);
            }
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue unSub(IKValue val) {
        if (val instanceof KUnknownValue) {
            return val;
        }
        if (val instanceof KCharValue) {
            KCharValue kcv = (KCharValue)val;
            return new KIntValue(-kcv.getValue());
        }
        if (val instanceof KIntValue) {
            KIntValue kiv = (KIntValue)val;
            return new KIntValue(-kiv.getValue());
        }
        if (val instanceof KDoubleValue) {
            KDoubleValue kdv = (KDoubleValue)val;
            return new KDoubleValue(-kdv.getValue());
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue plusplus(IKValue val) {
        if (val instanceof KUnknownValue) {
            return val;
        }
        if (val instanceof KCharValue) {
            KCharValue kcv = (KCharValue)val;
            int res = kcv.getValue() + '\u0001';
            if (res <= 65535 && res >= 0) {
                return new KCharValue((char)res);
            }
            return new KIntValue(res);
        }
        if (val instanceof KIntValue) {
            KIntValue kiv = (KIntValue)val;
            return new KIntValue(kiv.getValue() + 1);
        }
        if (val instanceof KDoubleValue) {
            KDoubleValue kdv = (KDoubleValue)val;
            return new KDoubleValue(kdv.getValue() + 1.0);
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue minusminus(IKValue val) {
        if (val instanceof KUnknownValue) {
            return val;
        }
        if (val instanceof KCharValue) {
            KCharValue kcv = (KCharValue)val;
            int res = kcv.getValue() - '\u0001';
            if (res <= 65535 && res >= 0) {
                return new KCharValue((char)res);
            }
            return new KIntValue(res);
        }
        if (val instanceof KIntValue) {
            KIntValue kiv = (KIntValue)val;
            return new KIntValue(kiv.getValue() - 1);
        }
        if (val instanceof KDoubleValue) {
            KDoubleValue kdv = (KDoubleValue)val;
            return new KDoubleValue(kdv.getValue() - 1.0);
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue unNeg(IKValue val) {
        if (val instanceof KUnknownValue) {
            return val;
        }
        if (val instanceof KBooleanValue) {
            KBooleanValue kbv = (KBooleanValue)val;
            return kbv.getNegation();
        }
        throw new KenyaInternalError("Precondition failed for ! (unary negation) in KValueCalculator: " + val);
    }

    public static IKValue or(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KBooleanValue && rhs instanceof KBooleanValue) {
            KBooleanValue kbl = (KBooleanValue)lhs;
            KBooleanValue kbr = (KBooleanValue)rhs;
            return KBooleanValue.get(kbl.getValue() || kbr.getValue());
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue xor(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KBooleanValue && rhs instanceof KBooleanValue) {
            KBooleanValue kbl = (KBooleanValue)lhs;
            KBooleanValue kbr = (KBooleanValue)rhs;
            return KBooleanValue.get(kbl.getValue() ^ kbr.getValue());
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue and(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof KBooleanValue && rhs instanceof KBooleanValue) {
            KBooleanValue kbl = (KBooleanValue)lhs;
            KBooleanValue kbr = (KBooleanValue)rhs;
            return KBooleanValue.get(kbl.getValue() && kbr.getValue());
        }
        throw new KenyaInternalError("Precondition failed for binary and in KValueCalculator: " + lhs + " && " + rhs);
    }

    public static IKValue equal(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof IKNumericValue && rhs instanceof IKNumericValue) {
            IKNumericValue lv = (IKNumericValue)lhs;
            IKNumericValue rv = (IKNumericValue)rhs;
            return KBooleanValue.get(lv.getDoubleValue() == rv.getDoubleValue());
        }
        if (lhs instanceof KEnumValue && rhs instanceof KEnumValue) {
            return KBooleanValue.get(lhs.equals(rhs));
        }
        if (lhs instanceof KBooleanValue && rhs instanceof KBooleanValue) {
            KBooleanValue lv = (KBooleanValue)lhs;
            KBooleanValue rv = (KBooleanValue)rhs;
            return KBooleanValue.get(lv.getValue() == rv.getValue());
        }
        return KUnknownValue.get();
    }

    public static IKValue unequal(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof IKNumericValue && rhs instanceof IKNumericValue) {
            IKNumericValue lv = (IKNumericValue)lhs;
            IKNumericValue rv = (IKNumericValue)rhs;
            return KBooleanValue.get(lv.getDoubleValue() != rv.getDoubleValue());
        }
        if (lhs instanceof KBooleanValue && rhs instanceof KBooleanValue) {
            KBooleanValue lv = (KBooleanValue)lhs;
            KBooleanValue rv = (KBooleanValue)rhs;
            return KBooleanValue.get(lv.getValue() != rv.getValue());
        }
        if (lhs instanceof KEnumValue && rhs instanceof KEnumValue) {
            return KBooleanValue.get(!lhs.equals(rhs));
        }
        return KUnknownValue.get();
    }

    public static IKValue less(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof IKNumericValue && rhs instanceof IKNumericValue) {
            IKNumericValue lv = (IKNumericValue)lhs;
            IKNumericValue rv = (IKNumericValue)rhs;
            return KBooleanValue.get(lv.getDoubleValue() < rv.getDoubleValue());
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue greater(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof IKNumericValue && rhs instanceof IKNumericValue) {
            IKNumericValue lv = (IKNumericValue)lhs;
            IKNumericValue rv = (IKNumericValue)rhs;
            return KBooleanValue.get(lv.getDoubleValue() > rv.getDoubleValue());
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue lessEq(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof IKNumericValue && rhs instanceof IKNumericValue) {
            IKNumericValue lv = (IKNumericValue)lhs;
            IKNumericValue rv = (IKNumericValue)rhs;
            return KBooleanValue.get(lv.getDoubleValue() <= rv.getDoubleValue());
        }
        throw KenyaPreconditionError.get();
    }

    public static IKValue greaterEq(IKValue lhs, IKValue rhs) {
        if (lhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (rhs instanceof KUnknownValue) {
            return KUnknownValue.get();
        }
        if (lhs instanceof IKNumericValue && rhs instanceof IKNumericValue) {
            IKNumericValue lv = (IKNumericValue)lhs;
            IKNumericValue rv = (IKNumericValue)rhs;
            return KBooleanValue.get(lv.getDoubleValue() >= rv.getDoubleValue());
        }
        throw KenyaPreconditionError.get();
    }
}

