/*
 * Decompiled with CFR 0.152.
 */
package mediator.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import kenya.errors.KenyaInternalError;
import kenya.passes.Util;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import kenya.types.KArrayType;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KClassType;
import kenya.types.KEnumType;
import kenya.types.KFunction;
import kenya.types.KParamType;
import kenya.types.KParamTypeMapper;
import kenya.types.KType;
import kenya.types.KVariable;
import kenya.types.tables.ClassTable;
import kenya.types.tables.FunctionTable;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.TypeTable;
import kenya.types.tables.VariableTable;
import mediator.util.AClassInstance;
import mediator.util.AFunctionInstance;
import mediator.util.AVariableInstance;
import mediator.util.IClassNameSorter;
import minijava.node.AClassDecDeclaration;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AFunctionApplication;
import minijava.node.AQualifiedName;
import minijava.node.Node;
import minijava.node.Start;

public class InformationHolder {
    private IClass[] _classes;
    private IClass[] _enums;
    private IVariable[] _consts;
    private IFunction[] _funcs;
    private final Start _rootNode;
    private final Map _typeMap = new HashMap();
    private final Map _funcMap;
    private final Map _ktMap;
    private final Set _arrayLengths;
    private final Set _enumChildSet;

    public InformationHolder(ClassTable types, FunctionTable functions, VariableTable consts, Set enumChildSet, Set arrayLengths, Map funcMap, Map ktMap, Start rootNode) {
        this._rootNode = rootNode;
        this._funcMap = funcMap;
        this._ktMap = ktMap;
        this._arrayLengths = arrayLengths;
        this._enumChildSet = enumChildSet;
        this.doBasics();
        this.doEnums(types);
        this.doClasses(types);
        this.doFunctions(functions);
        this.doConstants(consts);
    }

    public IClass[] getClasses() {
        return this._classes;
    }

    public IClass getTypeFromName(String name) {
        if (this._typeMap.containsKey(name)) {
            return (IClass)this._typeMap.get(name);
        }
        throw new NoSuchElementException(name);
    }

    public IVariable getConstantByName(String name) {
        for (int i = 0; i < this._consts.length; ++i) {
            if (!this._consts[i].getName().equals(name)) continue;
            return this._consts[i];
        }
        throw new NoSuchElementException("Cannot find that constant");
    }

    public IClass[] getEnums() {
        return this._enums;
    }

    public IVariable[] getConstants() {
        return this._consts;
    }

    public IFunction[] getFunctions() {
        return this._funcs;
    }

    public Start getRootNode() {
        return this._rootNode;
    }

    public IClass getVoid() {
        return (IClass)this._typeMap.get("void");
    }

    public KFunction getFunction(AFunctionApplication func) {
        return (KFunction)this._funcMap.get(func);
    }

    public IClass getTypeFromNode(Node n, IClass[] typeParams) {
        KType kt = (KType)this._ktMap.get(n);
        return this.getType(kt, this.paramArrayToMap(typeParams));
    }

    public boolean isArrayLengthReference(AQualifiedName node) {
        return this._arrayLengths.contains(node);
    }

    public boolean isEnumChildNode(Node node) {
        return this._enumChildSet.contains(node);
    }

    public boolean hasEnum(String name) {
        for (int i = 0; i < this._enums.length; ++i) {
            if (!this._enums[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void doBasics() {
        this._typeMap.put("void", new AClassInstance("void", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("boolean", new AClassInstance("boolean", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("char", new AClassInstance("char", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("int", new AClassInstance("int", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("double", new AClassInstance("double", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("Boolean", new AClassInstance("Boolean", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("Character", new AClassInstance("Character", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("Integer", new AClassInstance("Integer", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("Double", new AClassInstance("Double", new IClass[0], (ISourceCodeLocation)null, 3));
        this._typeMap.put("String", new AClassInstance("String", new IClass[0], (ISourceCodeLocation)null, 3));
    }

    private void doConstants(VariableTable consts) {
        Map m = consts.getConstants();
        LinkedList<IVariable> l = new LinkedList<IVariable>();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            KVariable kv = (KVariable)it.next();
            IVariable ivar = this.getVariable(kv, new HashMap());
            l.add(ivar);
        }
        this._consts = l.toArray(new IVariable[0]);
    }

    private void doFunctions(FunctionTable functions) {
        Map m = functions.getBackingMap();
        TreeSet s = new TreeSet(m.keySet());
        LinkedList<AFunctionInstance> l = new LinkedList<AFunctionInstance>();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Set fns = (Set)m.get(name);
            Iterator fnsIt = fns.iterator();
            while (fnsIt.hasNext()) {
                KFunction kf = (KFunction)fnsIt.next();
                if (kf.isBuiltin()) continue;
                HashSet<AClassInstance> typePSet = new HashSet<AClassInstance>();
                Iterator ity = kf.getTypeParamMap().keySet().iterator();
                while (ity.hasNext()) {
                    KParamType kpt = (KParamType)kf.getTypeParamMap().get(ity.next());
                    int[] pos = Util.getFirstIdent(kpt.getNode());
                    SourceCodeLocation scl = new SourceCodeLocation(pos[0], pos[1], pos[2]);
                    AClassInstance pt = new AClassInstance(kpt.getName(), new IClass[0], scl, 4);
                    typePSet.add(pt);
                }
                IClass[] typeParams = typePSet.toArray(new IClass[0]);
                Map paramMap = this.paramArrayToMap(typeParams);
                IClass returnType = this.getType(kf.getReturnType(), paramMap);
                List vars = kf.getVars();
                Iterator varIt = vars.iterator();
                IVariable[] arguments = new IVariable[vars.size()];
                int i = 0;
                while (varIt.hasNext()) {
                    arguments[i] = this.getVariable((KVariable)varIt.next(), paramMap);
                    ++i;
                }
                int[] pos = Util.getFirstIdent(kf.getNode().getIdentifier());
                SourceCodeLocation position = new SourceCodeLocation(pos[0], pos[1], pos[2]);
                AFunctionInstance afi = new AFunctionInstance(typeParams, name, returnType, arguments, position, kf.getNode());
                l.add(afi);
            }
        }
        this._funcs = l.toArray(new IFunction[0]);
    }

    private void doEnums(ClassTable types) {
        Iterator it = types.getEnumIterator();
        TreeSet<AClassInstance> enumSet = new TreeSet<AClassInstance>(new IClassNameSorter());
        while (it.hasNext()) {
            String enumName = (String)it.next();
            KEnumType ket = (KEnumType)types.getType(enumName);
            IClass[] paramList = new IClass[]{};
            int[] pos = Util.getFirstIdent(((AEnumDecDeclaration)types.getNode(enumName)).getIdentifier());
            String[] kids = ket.getChildren();
            SourceCodeLocation scl = new SourceCodeLocation(pos[0], pos[1], pos[2]);
            AClassInstance aci = new AClassInstance(enumName, paramList, scl, 1);
            aci.setEnumConsts(kids);
            this._typeMap.put(enumName, aci);
            enumSet.add(aci);
        }
        this._enums = enumSet.toArray(new IClass[0]);
    }

    private void doClasses(ClassTable types) {
        KClassType kct;
        Iterator it = types.getClassIterator();
        TreeSet<AClassInstance> classSet = new TreeSet<AClassInstance>(new IClassNameSorter());
        while (it.hasNext()) {
            String className = (String)it.next();
            if (types.getNode(className) == null) continue;
            kct = (KClassType)types.getType(className);
            List params = kct.getTypeParamList();
            Iterator pit = params.iterator();
            IClass[] paramList = new IClass[params.size()];
            int i = 0;
            while (pit.hasNext()) {
                KParamType kpt = (KParamType)pit.next();
                int[] pos = Util.getFirstIdent(kpt.getNode());
                SourceCodeLocation scl = new SourceCodeLocation(pos[0], pos[1], pos[2]);
                paramList[i] = new AClassInstance(kpt.getName(), new IClass[0], scl, 4);
                ++i;
            }
            int[] pos = Util.getFirstIdent(((AClassDecDeclaration)types.getNode(className)).getIdentifier());
            SourceCodeLocation scl = new SourceCodeLocation(pos[0], pos[1], pos[2]);
            AClassInstance aci = new AClassInstance(className, paramList, scl, 0);
            this._typeMap.put(className, aci);
            classSet.add(aci);
        }
        this._classes = classSet.toArray(new IClass[0]);
        it = types.getClassIterator();
        while (it.hasNext()) {
            String thisClassName = (String)it.next();
            if (types.getNode(thisClassName) == null) continue;
            kct = (KClassType)types.getType(thisClassName);
            SymbolTable st = kct.getChildren();
            AClassInstance ic = (AClassInstance)this._typeMap.get(thisClassName);
            ic.setDeclarations(this.getVariables(st, this.paramArrayToMap(ic.getTemplateParams())));
        }
    }

    private Map paramArrayToMap(IClass[] params) {
        HashMap<String, IClass> m = new HashMap<String, IClass>();
        for (int i = 0; i < params.length; ++i) {
            m.put(KParamTypeMapper.get().lookupName(params[i].getName()), params[i]);
        }
        return m;
    }

    private IVariable[] getVariables(SymbolTable st, Map params) {
        Map m = st.collapse();
        IVariable[] iv = new IVariable[m.keySet().size()];
        Iterator it = m.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String name = (String)it.next();
            KVariable kv = (KVariable)m.get(name);
            iv[i] = this.getVariable(kv, params);
            ++i;
        }
        return iv;
    }

    private IVariable getVariable(KVariable kv, Map params) {
        String name = kv.getName();
        int[] pos = Util.getFirstIdent(kv.getNode());
        SourceCodeLocation scl = new SourceCodeLocation(pos[0], pos[1], pos[2]);
        IClass type = this.getType(kv.getType(), params);
        return new AVariableInstance(name, scl, type);
    }

    public IClass getType(KType type, Map params) {
        if (type instanceof KArrayType) {
            KArrayType kat = (KArrayType)type;
            IClass underlying = this.getType(kat.getChildType(), params);
            return new AClassInstance(underlying.getName() + "[]", underlying.getTemplateParams(), underlying, 2);
        }
        if (type instanceof KBasicType) {
            return (IClass)this._typeMap.get(type.getName());
        }
        if (type instanceof KBoundClassType) {
            KBoundClassType kat = (KBoundClassType)type;
            IClass underlying = this.getType(kat.getBase(), params);
            TypeTable tt = kat.getBindings();
            if (underlying == null) {
                return (IClass)this._typeMap.get(type.getName().toLowerCase());
            }
            IClass[] newParams = new IClass[underlying.getTemplateParams().length];
            for (int i = 0; i < underlying.getTemplateParams().length; ++i) {
                newParams[i] = this.getType(tt.lookup(new KParamType(underlying.getTemplateParams()[i].getName(), false)), params);
            }
            return new AClassInstance(underlying.getName(), newParams, underlying, 0);
        }
        if (type instanceof KClassType) {
            return (IClass)this._typeMap.get(type.getName());
        }
        if (type instanceof KParamType) {
            return (IClass)params.get(KParamTypeMapper.get().lookupName(type.getName()));
        }
        if (type instanceof KEnumType) {
            return (IClass)this._typeMap.get(type.getName());
        }
        throw new KenyaInternalError("Failed precondition with type : " + type);
    }

    public boolean areClassBasicTypesUsed() {
        Iterator it = this._ktMap.entrySet().iterator();
        while (it.hasNext()) {
            KBoundClassType kbct;
            KType kt = (KType)it.next().getValue();
            if (!(kt instanceof KBoundClassType) || (kbct = (KBoundClassType)kt).getBase() != KClassType.getCharacter() && kbct.getBase() != KClassType.getDouble() && kbct.getBase() != KClassType.getInteger() && kbct.getBase() != KClassType.getBoolean()) continue;
            return true;
        }
        return false;
    }
}

