/*
 * Decompiled with CFR 0.152.
 */
package minijava.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import minijava.lexer.LexerException;
import minijava.node.EOF;
import minijava.node.TAnd;
import minijava.node.TAssert;
import minijava.node.TAssign;
import minijava.node.TBlank;
import minijava.node.TBoolean;
import minijava.node.TBracketPair;
import minijava.node.TBreak;
import minijava.node.TCase;
import minijava.node.TChar;
import minijava.node.TCharliteral;
import minijava.node.TColon;
import minijava.node.TComma;
import minijava.node.TComment;
import minijava.node.TConst;
import minijava.node.TDefault;
import minijava.node.TDivide;
import minijava.node.TDot;
import minijava.node.TDouble;
import minijava.node.TDpnumber;
import minijava.node.TElse;
import minijava.node.TEnum;
import minijava.node.TEqual;
import minijava.node.TFalse;
import minijava.node.TFor;
import minijava.node.TGreater;
import minijava.node.TGreaterequal;
import minijava.node.TIdentifier;
import minijava.node.TIf;
import minijava.node.TInt;
import minijava.node.TIntnumber;
import minijava.node.TKlass;
import minijava.node.TLBrace;
import minijava.node.TLBracket;
import minijava.node.TLParenthese;
import minijava.node.TLess;
import minijava.node.TLessequal;
import minijava.node.TMinus;
import minijava.node.TMinusminus;
import minijava.node.TMod;
import minijava.node.TNew;
import minijava.node.TNewLine;
import minijava.node.TNot;
import minijava.node.TNotequal;
import minijava.node.TNull;
import minijava.node.TOr;
import minijava.node.TPlus;
import minijava.node.TPlusplus;
import minijava.node.TRBrace;
import minijava.node.TRBracket;
import minijava.node.TRParenthese;
import minijava.node.TReservedWord;
import minijava.node.TReturn;
import minijava.node.TSemicolon;
import minijava.node.TString;
import minijava.node.TStringliteral;
import minijava.node.TSwitch;
import minijava.node.TTimes;
import minijava.node.TTraditionalComment;
import minijava.node.TTrue;
import minijava.node.TVoid;
import minijava.node.TWhile;
import minijava.node.TXor;
import minijava.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.INITIAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;
    static /* synthetic */ Class class$minijava$lexer$Lexer;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
        if (gotoTable == null) {
            try {
                int j;
                int i;
                DataInputStream s = new DataInputStream(new BufferedInputStream((class$minijava$lexer$Lexer == null ? (class$minijava$lexer$Lexer = Lexer.class$("minijava.lexer.Lexer")) : class$minijava$lexer$Lexer).getResourceAsStream("lexer.dat")));
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for (i = 0; i < gotoTable.length; ++i) {
                    length = s.readInt();
                    Lexer.gotoTable[i] = new int[length][][];
                    for (j = 0; j < gotoTable[i].length; ++j) {
                        length = s.readInt();
                        Lexer.gotoTable[i][j] = new int[length][3];
                        for (int k = 0; k < gotoTable[i][j].length; ++k) {
                            for (int l = 0; l < 3; ++l) {
                                Lexer.gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }
                length = s.readInt();
                accept = new int[length][];
                for (i = 0; i < accept.length; ++i) {
                    length = s.readInt();
                    Lexer.accept[i] = new int[length];
                    for (j = 0; j < accept[i].length; ++j) {
                        Lexer.accept[i][j] = s.readInt();
                    }
                }
                s.close();
            }
            catch (Exception e) {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block69: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block69;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 1: {
                    Token token = this.new1(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 2: {
                    Token token = this.new2(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 3: {
                    Token token = this.new3(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 4: {
                    Token token = this.new4(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 5: {
                    Token token = this.new5(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 6: {
                    Token token = this.new6(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 7: {
                    Token token = this.new7(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 8: {
                    Token token = this.new8(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 9: {
                    Token token = this.new9(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 10: {
                    Token token = this.new10(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 11: {
                    Token token = this.new11(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 12: {
                    Token token = this.new12(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 13: {
                    Token token = this.new13(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 14: {
                    Token token = this.new14(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 15: {
                    Token token = this.new15(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 16: {
                    Token token = this.new16(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 17: {
                    Token token = this.new17(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 18: {
                    Token token = this.new18(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 19: {
                    Token token = this.new19(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 20: {
                    Token token = this.new20(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 21: {
                    Token token = this.new21(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 22: {
                    Token token = this.new22(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 23: {
                    Token token = this.new23(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 24: {
                    Token token = this.new24(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 25: {
                    Token token = this.new25(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 26: {
                    Token token = this.new26(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 27: {
                    Token token = this.new27(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 28: {
                    Token token = this.new28(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 29: {
                    Token token = this.new29(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 30: {
                    Token token = this.new30(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 31: {
                    Token token = this.new31(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 32: {
                    Token token = this.new32(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 33: {
                    Token token = this.new33(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 34: {
                    Token token = this.new34(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 35: {
                    Token token = this.new35(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 36: {
                    Token token = this.new36(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 37: {
                    Token token = this.new37(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 38: {
                    Token token = this.new38(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 39: {
                    Token token = this.new39(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 40: {
                    Token token = this.new40(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 41: {
                    Token token = this.new41(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 42: {
                    Token token = this.new42(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 43: {
                    Token token = this.new43(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 44: {
                    Token token = this.new44(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 45: {
                    Token token = this.new45(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 46: {
                    Token token = this.new46(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 47: {
                    Token token = this.new47(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 48: {
                    Token token = this.new48(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 49: {
                    Token token = this.new49(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 50: {
                    Token token = this.new50(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 51: {
                    Token token = this.new51(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 52: {
                    Token token = this.new52(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 53: {
                    Token token = this.new53(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 54: {
                    Token token = this.new54(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 55: {
                    Token token = this.new55(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 56: {
                    Token token = this.new56(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 57: {
                    Token token = this.new57(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 58: {
                    Token token = this.new58(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 59: {
                    Token token = this.new59(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 60: {
                    Token token = this.new60(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 61: {
                    Token token = this.new61(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(String text, int line, int pos) {
        return new TReservedWord(text, line, pos);
    }

    Token new1(String text, int line, int pos) {
        return new TNewLine(text, line, pos);
    }

    Token new2(String text, int line, int pos) {
        return new TBlank(text, line, pos);
    }

    Token new3(String text, int line, int pos) {
        return new TComment(text, line, pos);
    }

    Token new4(String text, int line, int pos) {
        return new TTraditionalComment(text, line, pos);
    }

    Token new5(int line, int pos) {
        return new TBoolean(line, pos);
    }

    Token new6(int line, int pos) {
        return new TChar(line, pos);
    }

    Token new7(int line, int pos) {
        return new TInt(line, pos);
    }

    Token new8(int line, int pos) {
        return new TDouble(line, pos);
    }

    Token new9(int line, int pos) {
        return new TString(line, pos);
    }

    Token new10(int line, int pos) {
        return new TVoid(line, pos);
    }

    Token new11(int line, int pos) {
        return new TKlass(line, pos);
    }

    Token new12(int line, int pos) {
        return new TConst(line, pos);
    }

    Token new13(int line, int pos) {
        return new TIf(line, pos);
    }

    Token new14(int line, int pos) {
        return new TElse(line, pos);
    }

    Token new15(int line, int pos) {
        return new TWhile(line, pos);
    }

    Token new16(int line, int pos) {
        return new TReturn(line, pos);
    }

    Token new17(int line, int pos) {
        return new TSwitch(line, pos);
    }

    Token new18(int line, int pos) {
        return new TCase(line, pos);
    }

    Token new19(int line, int pos) {
        return new TBreak(line, pos);
    }

    Token new20(int line, int pos) {
        return new TDefault(line, pos);
    }

    Token new21(int line, int pos) {
        return new TFor(line, pos);
    }

    Token new22(int line, int pos) {
        return new TAssert(line, pos);
    }

    Token new23(int line, int pos) {
        return new TNew(line, pos);
    }

    Token new24(int line, int pos) {
        return new TEnum(line, pos);
    }

    Token new25(int line, int pos) {
        return new TTrue(line, pos);
    }

    Token new26(int line, int pos) {
        return new TFalse(line, pos);
    }

    Token new27(int line, int pos) {
        return new TNull(line, pos);
    }

    Token new28(int line, int pos) {
        return new TAnd(line, pos);
    }

    Token new29(int line, int pos) {
        return new TOr(line, pos);
    }

    Token new30(int line, int pos) {
        return new TXor(line, pos);
    }

    Token new31(int line, int pos) {
        return new TNot(line, pos);
    }

    Token new32(String text, int line, int pos) {
        return new TIdentifier(text, line, pos);
    }

    Token new33(String text, int line, int pos) {
        return new TStringliteral(text, line, pos);
    }

    Token new34(String text, int line, int pos) {
        return new TCharliteral(text, line, pos);
    }

    Token new35(int line, int pos) {
        return new TLParenthese(line, pos);
    }

    Token new36(int line, int pos) {
        return new TRParenthese(line, pos);
    }

    Token new37(int line, int pos) {
        return new TLBrace(line, pos);
    }

    Token new38(int line, int pos) {
        return new TRBrace(line, pos);
    }

    Token new39(int line, int pos) {
        return new TLBracket(line, pos);
    }

    Token new40(int line, int pos) {
        return new TRBracket(line, pos);
    }

    Token new41(String text, int line, int pos) {
        return new TBracketPair(text, line, pos);
    }

    Token new42(int line, int pos) {
        return new TSemicolon(line, pos);
    }

    Token new43(int line, int pos) {
        return new TColon(line, pos);
    }

    Token new44(int line, int pos) {
        return new TComma(line, pos);
    }

    Token new45(String text, int line, int pos) {
        return new TDot(text, line, pos);
    }

    Token new46(int line, int pos) {
        return new TPlus(line, pos);
    }

    Token new47(int line, int pos) {
        return new TPlusplus(line, pos);
    }

    Token new48(int line, int pos) {
        return new TMinus(line, pos);
    }

    Token new49(int line, int pos) {
        return new TMinusminus(line, pos);
    }

    Token new50(int line, int pos) {
        return new TTimes(line, pos);
    }

    Token new51(int line, int pos) {
        return new TDivide(line, pos);
    }

    Token new52(int line, int pos) {
        return new TMod(line, pos);
    }

    Token new53(int line, int pos) {
        return new TLess(line, pos);
    }

    Token new54(int line, int pos) {
        return new TLessequal(line, pos);
    }

    Token new55(int line, int pos) {
        return new TGreater(line, pos);
    }

    Token new56(int line, int pos) {
        return new TGreaterequal(line, pos);
    }

    Token new57(int line, int pos) {
        return new TEqual(line, pos);
    }

    Token new58(int line, int pos) {
        return new TNotequal(line, pos);
    }

    Token new59(int line, int pos) {
        return new TAssign(line, pos);
    }

    Token new60(String text, int line, int pos) {
        return new TIntnumber(text, line, pos);
    }

    Token new61(String text, int line, int pos) {
        return new TDpnumber(text, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        for (int i = length - 1; i >= acceptLength; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        for (int i = length - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(text.charAt(i));
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s = new StringBuffer(acceptLength);
        for (int i = 0; i < acceptLength; ++i) {
            s.append(this.text.charAt(i));
        }
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class State {
        public static final State INITIAL = new State(0);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

