/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.scope.MethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class StackMachine {
    private final Object lock = new Object();
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private InputStream in = System.in;
    private final Stack theStack = new Stack();
    private final Stack methodBoundaries = new Stack();
    private final Stack argPeekCounts = new Stack();
    private int currentBoundary = 0;
    private int currentArgPeekCount = 0;
    private final List positionReachedListeners = new ArrayList();
    private boolean stackMachineHalt = false;
    private boolean stackMachineContinue = true;
    private boolean stepMode = false;
    private IMethodScope methodScope = null;
    private IClosureScope closureScope = null;

    public synchronized IMethodScope getMethodScope() {
        if (this.methodScope == null) {
            this.methodScope = new MethodScope();
        }
        return this.methodScope;
    }

    public synchronized void setMethodScope(IMethodScope scope) {
        this.methodScope = scope;
    }

    public synchronized IClosureScope getClosureScope() {
        if (this.closureScope == null) {
            this.closureScope = new ClosureScope();
        }
        return this.closureScope;
    }

    public synchronized void setClosureScope(IClosureScope scope) {
        this.closureScope = scope;
    }

    public synchronized void push(IType object) {
        this.theStack.push(object);
    }

    public synchronized IType pop() {
        if (this.theStack.size() <= this.currentBoundary) {
            ++this.currentArgPeekCount;
            return (IType)this.theStack.get(this.currentBoundary - this.currentArgPeekCount);
        }
        return (IType)this.theStack.pop();
    }

    public synchronized void printStackPeek() {
        this.getOut().print(this.theStack.peek().toString());
    }

    public synchronized void printlnStackPeek() {
        this.getOut().println(this.theStack.peek().toString());
    }

    public synchronized void print(String value) {
        this.getOut().print(value);
    }

    public synchronized void println(String value) {
        this.getOut().println(value);
    }

    public synchronized void println() {
        this.getOut().println();
    }

    public void invokeMethod(String method) {
        if (this.getMethodScope() == null) {
            this.unableToFindMethod(method);
        } else {
            IMethodScope scope = this.getMethodScope();
            IInterpretedMethod currentMethod = scope.getCurrentMethod();
            if (currentMethod.isStatic()) {
                IInterpretedClass currentClass = currentMethod.getInterpretedClass();
                this.invokeMethod(currentClass, method);
            } else {
                IInterpretedClassInstance currentClassInstance = scope.getCurrentClassInstance();
                this.invokeMethod(currentClassInstance, method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeMethod(IInterpretedClass targetClass, String methodName) {
        IInterpretedMethod method = targetClass.getMethod(methodName);
        MethodScope scope = new MethodScope(method, targetClass);
        StackMachine stackMachine = this;
        synchronized (stackMachine) {
            this.getMethodScope().switchToNewScope(scope, this);
            this.methodBoundaries.push(new Integer(this.currentBoundary));
            this.currentBoundary = this.theStack.size();
            this.argPeekCounts.push(new Integer(this.currentArgPeekCount));
            this.currentArgPeekCount = 0;
        }
        method.invoke(this);
        stackMachine = this;
        synchronized (stackMachine) {
            IType returnResult = null;
            if (method.hasReturnType()) {
                returnResult = (IType)this.theStack.peek();
            }
            while (this.theStack.size() > this.currentBoundary) {
                this.theStack.pop();
            }
            if (method.hasReturnType()) {
                this.theStack.push(returnResult);
            }
            this.currentBoundary = (Integer)this.methodBoundaries.pop();
            this.currentArgPeekCount = (Integer)this.argPeekCounts.pop();
            scope.switchToPreviousScope(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeMethod(IInterpretedClassInstance targetClass, String methodName) {
        IInterpretedMethod method = targetClass.getMethod(methodName);
        MethodScope scope = new MethodScope(method, targetClass);
        StackMachine stackMachine = this;
        synchronized (stackMachine) {
            this.getMethodScope().switchToNewScope(scope, this);
            this.methodBoundaries.push(new Integer(this.currentBoundary));
            this.currentBoundary = this.theStack.size();
            this.argPeekCounts.push(new Integer(this.currentArgPeekCount));
            this.currentArgPeekCount = 0;
        }
        method.invoke(this);
        stackMachine = this;
        synchronized (stackMachine) {
            IType returnResult = null;
            if (method.hasReturnType()) {
                returnResult = (IType)this.theStack.peek();
            }
            while (this.theStack.size() > this.currentBoundary) {
                this.theStack.pop();
            }
            if (method.hasReturnType()) {
                this.theStack.push(returnResult);
            }
            this.currentBoundary = (Integer)this.methodBoundaries.pop();
            this.currentArgPeekCount = (Integer)this.argPeekCounts.pop();
            scope.switchToPreviousScope(this);
        }
    }

    private void unableToFindMethod(String method) {
        throw new RuntimeException("Unable to find method '" + method + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPositionReachedListener(IPointListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.positionReachedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePositionReachedListener(IPointListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.positionReachedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionReached(final Object data) {
        JobDispatch.enqueueJobAndWaitForFinish(new AbstractJob(){

            public void execute() {
                List listeners = StackMachine.this.getPositionReachedListeners();
                for (int idx = 0; idx < listeners.size(); ++idx) {
                    ((IPointListener)listeners.get(idx)).pointReached(data);
                }
            }
        });
        if (this.getStepMode()) {
            Object object = this.lock;
            synchronized (object) {
                this.setStackMachineHalt(true);
                this.setStackMachineContinue(false);
                while (!this.getStackMachineContinue()) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.setStackMachineHalt(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getPositionReachedListeners() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList(this.positionReachedListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStackMachineHalt(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.stackMachineHalt = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStackMachineContinue(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.stackMachineContinue = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getStackMachineContinue() {
        Object object = this.lock;
        synchronized (object) {
            return this.stackMachineContinue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getStackMachineHalt() {
        Object object = this.lock;
        synchronized (object) {
            return this.stackMachineHalt;
        }
    }

    public void resume() {
        this.resume(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(boolean step) {
        Object object = this.lock;
        synchronized (object) {
            if (this.getStackMachineHalt()) {
                this.stepMode = step;
                this.setStackMachineContinue(true);
                this.lock.notifyAll();
            }
        }
    }

    public void step() {
        this.resume(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepMode(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.stepMode = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getStepMode() {
        Object object = this.lock;
        synchronized (object) {
            return this.stepMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getIn() {
        Object object = this.lock;
        synchronized (object) {
            return this.in;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIn(InputStream in) {
        Object object = this.lock;
        synchronized (object) {
            this.in = in;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream getErr() {
        Object object = this.lock;
        synchronized (object) {
            return this.err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErr(PrintStream err) {
        Object object = this.lock;
        synchronized (object) {
            this.err = err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream getOut() {
        Object object = this.lock;
        synchronized (object) {
            return this.out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOut(PrintStream out) {
        Object object = this.lock;
        synchronized (object) {
            this.out = out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.setStepMode(false);
            this.resume();
            try {
                this.in.close();
                this.out.close();
            }
            catch (IOException e) {
                System.err.println("IO error when shutting down SM.");
                e.printStackTrace(System.err);
            }
        }
    }
}

