/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.misc;

import java.util.ArrayList;
import java.util.List;
import kenya.Kenya;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobRunner;

public class JobDispatch {
    private static final int MAX_IDLE_THREAD_COUNT = 10;
    private static final int PRESPAWN_THREAD_COUNT = 5;
    private static boolean shutDown = false;
    private static final List runningThreads = new ArrayList();
    private static final Object lock = new Object();
    private static final List outStandingJobs = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueueJob(AbstractJob job) {
        if (Kenya.DEBUG_OUTPUT) {
            System.out.println("Enqueuing");
        }
        Object object = lock;
        synchronized (object) {
            outStandingJobs.add(job);
            while (JobDispatch.getIdleThreadCount() < outStandingJobs.size()) {
                JobDispatch.spawnThread();
            }
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueueJobAndWaitForFinish(AbstractJob job) {
        if (Kenya.DEBUG_OUTPUT) {
            System.out.println("Enqueuing");
        }
        AbstractJob abstractJob = job;
        synchronized (abstractJob) {
            Object object = lock;
            synchronized (object) {
                outStandingJobs.add(job);
                while (JobDispatch.getIdleThreadCount() < outStandingJobs.size()) {
                    JobDispatch.spawnThread();
                }
                lock.notifyAll();
            }
            while (!job.isFinished()) {
                try {
                    job.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownAllJobs() {
        Object object = lock;
        synchronized (object) {
            shutDown = true;
            runningThreads.clear();
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void spawnThread() {
        Object object = lock;
        synchronized (object) {
            JobRunner jr = new JobRunner(lock, outStandingJobs);
            runningThreads.add(jr);
            new Thread(jr).start();
            while (!jr.isRunning()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getIdleThreadCount() {
        Object object = lock;
        synchronized (object) {
            int count = 0;
            for (int idx = 0; idx < runningThreads.size(); ++idx) {
                JobRunner jr = (JobRunner)runningThreads.get(idx);
                if (!jr.isRunning() || !jr.isIdle()) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isThreadRunning(JobRunner jr) {
        Object object = lock;
        synchronized (object) {
            if (shutDown) {
                return false;
            }
            if (runningThreads.contains(jr)) {
                return JobDispatch.getIdleThreadCount() <= 10;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void threadExiting(JobRunner jr) {
        Object object = lock;
        synchronized (object) {
            runningThreads.remove(jr);
            if (Kenya.DEBUG_OUTPUT) {
                System.out.println("Thread exited.");
            }
        }
    }

    static {
        for (int idx = 0; idx < 5; ++idx) {
            JobDispatch.spawnThread();
        }
    }
}

